/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.datastream.impl;

import com.ti.debug.engine.datastream.impl.DataWaiter;
import com.ti.debug.engine.datastream.impl.InputStream;
import com.ti.debug.engine.datastream.impl.StreamCloser;
import com.ti.xpcom.interfaces.dsIInputStream;
import java.io.IOException;

class InputStreamAdapter
extends java.io.InputStream {
    private final InputStream xpcomInputStream;
    private final StreamCloser<dsIInputStream> streamCloser;
    private final DataWaiter newDataWaiter;

    InputStreamAdapter(dsIInputStream inputStream) {
        this.xpcomInputStream = new InputStream(inputStream);
        this.streamCloser = new StreamCloser<dsIInputStream>(this.xpcomInputStream);
        this.newDataWaiter = new DataWaiter(this.streamCloser, this.xpcomInputStream.onDataAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        StreamCloser<dsIInputStream> streamCloser = this.streamCloser;
        synchronized (streamCloser) {
            this.streamCloser.assertNotClosed();
            return this.xpcomInputStream.available();
        }
    }

    @Override
    public void close() throws IOException {
        this.streamCloser.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int amountRead = 0;
        StreamCloser<dsIInputStream> streamCloser = this.streamCloser;
        synchronized (streamCloser) {
            this.streamCloser.assertNotClosed();
            this.newDataWaiter.reset();
            amountRead = this.xpcomInputStream.read(b, off, len);
        }
        if (0 == amountRead) {
            this.newDataWaiter.waitForData();
            streamCloser = this.streamCloser;
            synchronized (streamCloser) {
                this.streamCloser.assertNotClosed();
                amountRead = this.xpcomInputStream.read(b, off, len);
            }
        }
        return amountRead;
    }

    @Override
    public int read() throws IOException {
        byte[] localBuffer = new byte[1];
        this.read(localBuffer);
        return localBuffer[0];
    }

    public int hashCode() {
        return this.xpcomInputStream.hashCode();
    }
}

