/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.datastream.impl;

import com.ti.debug.engine.datastream.impl.DataWaiter;
import com.ti.debug.engine.datastream.impl.OutputStream;
import com.ti.debug.engine.datastream.impl.StreamCloser;
import com.ti.xpcom.interfaces.dsIOutputStream;
import java.io.IOException;

class OutputStreamAdapter
extends java.io.OutputStream {
    private final OutputStream xpcomOutputStream;
    private final StreamCloser<dsIOutputStream> streamCloser;
    private final DataWaiter writeWaiter;

    OutputStreamAdapter(dsIOutputStream outputStream) {
        this.xpcomOutputStream = new OutputStream(outputStream);
        this.streamCloser = new StreamCloser<dsIOutputStream>(this.xpcomOutputStream);
        this.writeWaiter = new DataWaiter(this.streamCloser, this.xpcomOutputStream.onWriteComplete());
    }

    @Override
    public void close() throws IOException {
        this.streamCloser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] b) throws IOException {
        StreamCloser<dsIOutputStream> streamCloser = this.streamCloser;
        synchronized (streamCloser) {
            this.streamCloser.assertNotClosed();
            this.writeWaiter.reset();
            this.xpcomOutputStream.write(b);
        }
        this.writeWaiter.waitForData();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] localBuffer = new byte[]{(byte)b};
        this.write(localBuffer);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] localBuffer = new byte[len];
        System.arraycopy(b, off, localBuffer, 0, len);
        this.write(localBuffer);
    }

    public int hashCode() {
        return this.xpcomOutputStream.hashCode();
    }
}

