/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.datastream.impl;

import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.datastream.BaseTargetDataStructure;
import com.ti.debug.engine.datastream.IStreamFactory;
import com.ti.debug.engine.datastream.StreamConfiguration;
import com.ti.debug.engine.datastream.impl.ExceptionTranslator;
import com.ti.debug.engine.datastream.impl.InputStream;
import com.ti.debug.engine.datastream.impl.InputStreamAdapter;
import com.ti.debug.engine.datastream.impl.OutputStream;
import com.ti.debug.engine.datastream.impl.OutputStreamAdapter;
import com.ti.debug.engine.datastream.tcl.IInputStream;
import com.ti.debug.engine.datastream.tcl.IOutputStream;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.Register;
import com.ti.xpcom.interfaces.dsIGetStream;
import com.ti.xpcom.interfaces.dsIInputStream;
import com.ti.xpcom.interfaces.dsIOutputStream;
import com.ti.xpcom.interfaces.dsIRegisterInfo;
import com.ti.xpcom.interfaces.dsIStreamException;
import com.ti.xpcom.interfaces.dsITargetData;
import java.io.IOException;
import java.util.Collection;

public class StreamFactory
extends AComparableDisposable<dsIGetStream>
implements IStreamFactory,
com.ti.debug.engine.datastream.tcl.IStreamFactory {
    private final ExceptionTranslator exceptionTranslator = new ExceptionTranslator();

    public StreamFactory(dsIGetStream getStream) {
        super(getStream);
    }

    @Override
    public java.io.InputStream getJTAGInputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration) throws IOException {
        return this.getJTAGInputStream(targetDataStructure, configuration, null);
    }

    @Override
    public java.io.InputStream getJTAGInputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration, IDspValue errorCountAddress) throws IOException {
        return new InputStreamAdapter(this.getXpcomInputStream(targetDataStructure, configuration, errorCountAddress));
    }

    @Override
    public java.io.InputStream getStopModeJTAGInputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration) throws IOException {
        return new InputStreamAdapter(this.getXpcomStopModeInputStream(targetDataStructure, configuration));
    }

    @Override
    public java.io.OutputStream getJTAGOutputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration) throws IOException {
        return this.getJTAGOutputStream(targetDataStructure, configuration, null, null);
    }

    @Override
    public java.io.OutputStream getJTAGOutputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration, IRegister interruptRegister, IDspValue interruptValue) throws IOException {
        return new OutputStreamAdapter(this.getXpcomOutputStream(targetDataStructure, configuration, interruptRegister, interruptValue));
    }

    @Override
    public java.io.InputStream getGTIInputStream(byte[] setupData) throws IOException {
        return new InputStreamAdapter(this.getXpcomGTIInputStream(setupData));
    }

    @Override
    public void setJTAGStreamUpdateLocations(Collection<IDspValue> locations) throws IOException {
        this.exceptionTranslator.checkForErrors(((dsIGetStream)this.wrappedObject).clearStreamUpdateLocations());
        for (IDspValue location : locations) {
            this.exceptionTranslator.checkForErrors(((dsIGetStream)this.wrappedObject).addStreamUpdateLocation((dsITargetData)((DspValue)location).getWrappedObject()));
        }
    }

    @Override
    public IInputStream getRawJTAGInputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration, IDspValue errorCountAddress) throws IOException {
        return new InputStream(this.getXpcomInputStream(targetDataStructure, configuration, errorCountAddress));
    }

    @Override
    public IInputStream getRawStopModeJTAGInputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration) throws IOException {
        return new InputStream(this.getXpcomStopModeInputStream(targetDataStructure, configuration));
    }

    @Override
    public IOutputStream getRawJTAGOutputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration, IRegister interruptRegister, IDspValue interruptValue) throws IOException {
        return new OutputStream(this.getXpcomOutputStream(targetDataStructure, configuration, interruptRegister, interruptValue));
    }

    @Override
    public IInputStream getRawGTIInputStream(byte[] setupData) throws IOException {
        return new InputStream(this.getXpcomGTIInputStream(setupData));
    }

    private dsIInputStream getXpcomInputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration, IDspValue errorCountAddress) throws IOException {
        dsIStreamException[] streamException = new dsIStreamException[1];
        dsIInputStream inputStream = ((dsIGetStream)this.wrappedObject).getInputStream(targetDataStructure.pageNumber, (dsITargetData)((DspValue)targetDataStructure.readPointerAddress).getWrappedObject(), (dsITargetData)((DspValue)targetDataStructure.writePointerAddress).getWrappedObject(), (dsITargetData)((DspValue)targetDataStructure.queueStartAddress).getWrappedObject(), targetDataStructure.queueLength, DspValue.translateFromDspValueTypeEnum(targetDataStructure.pointerType), targetDataStructure.pointerOffset, targetDataStructure.packData, configuration.blockUntilAccessesAllowed, configuration.contiguousBlocks, configuration.priority, null == errorCountAddress ? null : (dsITargetData)((DspValue)errorCountAddress).getWrappedObject(), streamException);
        this.exceptionTranslator.checkForErrors(streamException[0]);
        return inputStream;
    }

    private dsIInputStream getXpcomStopModeInputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration) throws IOException {
        dsIStreamException[] streamException = new dsIStreamException[1];
        dsIInputStream inputStream = ((dsIGetStream)this.wrappedObject).getStopModeInputStream(targetDataStructure.pageNumber, (dsITargetData)((DspValue)targetDataStructure.readPointerAddress).getWrappedObject(), (dsITargetData)((DspValue)targetDataStructure.writePointerAddress).getWrappedObject(), (dsITargetData)((DspValue)targetDataStructure.queueStartAddress).getWrappedObject(), targetDataStructure.queueLength, DspValue.translateFromDspValueTypeEnum(targetDataStructure.pointerType), targetDataStructure.pointerOffset, targetDataStructure.packData, configuration.contiguousBlocks, streamException);
        this.exceptionTranslator.checkForErrors(streamException[0]);
        return inputStream;
    }

    private dsIOutputStream getXpcomOutputStream(BaseTargetDataStructure targetDataStructure, StreamConfiguration configuration, IRegister interruptRegister, IDspValue interruptValue) throws IOException {
        dsIStreamException[] streamException = new dsIStreamException[1];
        dsIOutputStream outputStream = ((dsIGetStream)this.wrappedObject).getOutputStream(targetDataStructure.pageNumber, (dsITargetData)((DspValue)targetDataStructure.readPointerAddress).getWrappedObject(), (dsITargetData)((DspValue)targetDataStructure.writePointerAddress).getWrappedObject(), (dsITargetData)((DspValue)targetDataStructure.queueStartAddress).getWrappedObject(), targetDataStructure.queueLength, DspValue.translateFromDspValueTypeEnum(targetDataStructure.pointerType), targetDataStructure.pointerOffset, targetDataStructure.packData, configuration.blockUntilAccessesAllowed, configuration.priority, null == interruptRegister ? null : (dsIRegisterInfo)((Register)interruptRegister).getWrappedObject(), null == interruptValue ? null : (dsITargetData)((DspValue)interruptValue).getWrappedObject(), streamException);
        this.exceptionTranslator.checkForErrors(streamException[0]);
        return outputStream;
    }

    private dsIInputStream getXpcomGTIInputStream(byte[] setupData) throws IOException {
        dsIStreamException[] streamException = new dsIStreamException[1];
        dsIInputStream inputStream = ((dsIGetStream)this.wrappedObject).getGTIInputStream(setupData.length, setupData, streamException);
        this.exceptionTranslator.checkForErrors(streamException[0]);
        return inputStream;
    }
}

