/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.events.data.impl;

import com.ti.debug.engine.events.data.IRefreshEventData;

public class RefreshEventData
implements IRefreshEventData {
    private final IRefreshEventData.RefreshReason reason;

    public RefreshEventData(int numberEventData) {
        this.reason = this.translateReason(numberEventData);
    }

    private IRefreshEventData.RefreshReason translateReason(int numberEventData) {
        switch (numberEventData) {
            case 0: {
                return IRefreshEventData.RefreshReason.TargetHalt;
            }
            case 1: {
                return IRefreshEventData.RefreshReason.ProgramLoad;
            }
            case 2: {
                return IRefreshEventData.RefreshReason.Restart;
            }
            case 3: {
                return IRefreshEventData.RefreshReason.TargetConnected;
            }
            case 4: {
                return IRefreshEventData.RefreshReason.MemMapChanged;
            }
            case 5: {
                return IRefreshEventData.RefreshReason.ExtendedMemoryChanged;
            }
            case 6: {
                return IRefreshEventData.RefreshReason.SimModeChanged;
            }
            case 7: {
                return IRefreshEventData.RefreshReason.UserRequested;
            }
            case 8: {
                return IRefreshEventData.RefreshReason.NonDebugChange;
            }
            case 9: {
                return IRefreshEventData.RefreshReason.ProbePointHit;
            }
            case 10: {
                return IRefreshEventData.RefreshReason.TargetWrite;
            }
        }
        throw new RuntimeException("Invalid refresh reason type");
    }

    @Override
    public IRefreshEventData.RefreshReason getReasonForRefresh() {
        return this.reason;
    }

    @Override
    public IRefreshEventData.RefreshType getRefreshType() {
        if (IRefreshEventData.RefreshReason.TargetWrite == this.reason) {
            return IRefreshEventData.RefreshType.RetainHighlights;
        }
        return IRefreshEventData.RefreshType.FullRefresh;
    }

    @Override
    public void acquire() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return false;
    }
}

