/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.events.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

abstract class AManagedEvent<Listener> {
    private final Map<Listener, WeakReference<Listener>> registeredCallbacksMap = new WeakHashMap<Listener, WeakReference<Listener>>();
    private final Collection<WeakReference<Listener>> registeredCallbacks = new LinkedList<WeakReference<Listener>>();
    private boolean isRegistered = false;

    AManagedEvent() {
    }

    protected synchronized void addEventListener(Listener listener) {
        WeakReference<Listener> weakRef = this.registeredCallbacksMap.get(listener);
        if (null == weakRef) {
            weakRef = new WeakReference<Listener>(listener);
            this.registeredCallbacksMap.put(listener, weakRef);
            this.registeredCallbacks.add(weakRef);
            if (!this.isRegistered) {
                this.registerForEvents();
                this.isRegistered = true;
            }
        }
    }

    protected synchronized void removeEventListener(Listener listener) {
        WeakReference<Listener> weakRef = this.registeredCallbacksMap.remove(listener);
        if (null != weakRef) {
            weakRef.clear();
        }
    }

    protected synchronized Collection<Listener> getListeners() {
        ArrayList listeners = new ArrayList();
        Iterator<WeakReference<Listener>> iterator = this.registeredCallbacks.iterator();
        while (iterator.hasNext()) {
            Object listener = iterator.next().get();
            if (null == listener) {
                iterator.remove();
                continue;
            }
            listeners.add(listener);
        }
        if (this.isRegistered && this.registeredCallbacks.isEmpty()) {
            this.unregisterForEvents();
            this.isRegistered = false;
        }
        return listeners;
    }

    protected void registerForEvents() {
    }

    protected void unregisterForEvents() {
    }
}

