/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.framework;

import com.ti.debug.engine.framework.IDisposable;
import java.util.ArrayList;

public class StackTraceLogEntry {
    public static boolean ENABLE_STACK_TRACE_LOGGING = null != System.getProperty("ENABLE.STACK.TRACE.LOGGING");
    public static int MAX_STACK_TRACE_LEVELS = 10;
    private String className;
    private Event eventCreate;
    private Event eventFinalDispose;
    private ArrayList<Event> addRefEvents;
    private ArrayList<Event> removeRefEvents;

    public StackTraceLogEntry(IDisposable myObject) {
        this.className = myObject.getClass().getName();
        this.addRefEvents = new ArrayList();
        this.removeRefEvents = new ArrayList();
    }

    public void logCreate(Throwable t) {
        StackTraceElement[] s = this.truncateStackTrace(t.getStackTrace());
        this.eventCreate = new Event(s);
    }

    public void logFinalDispose(Throwable t) {
        StackTraceElement[] s = this.truncateStackTrace(t.getStackTrace());
        this.eventFinalDispose = new Event(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAddRef(Throwable t) {
        StackTraceElement[] s = this.truncateStackTrace(t.getStackTrace());
        ArrayList<Event> arrayList = this.addRefEvents;
        synchronized (arrayList) {
            this.addRefEvents.add(new Event(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRemoveRef(Throwable t) {
        StackTraceElement[] s = this.truncateStackTrace(t.getStackTrace());
        ArrayList<Event> arrayList = this.removeRefEvents;
        synchronized (arrayList) {
            this.removeRefEvents.add(new Event(s));
        }
    }

    private StackTraceElement[] truncateStackTrace(StackTraceElement[] s) {
        int length = Math.min(MAX_STACK_TRACE_LEVELS, s.length);
        StackTraceElement[] result = new StackTraceElement[length];
        for (int i = 0; i < length; ++i) {
            result[i] = s[i];
        }
        return result;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("||======================================================================\n");
        s.append("|| CLASS:  " + this.className + "\n");
        s.append("||----------------------------------------------------------------------\n");
        s.append("|| CONSTRUCTOR:\n");
        s.append("||----------------------------------------------------------------------\n");
        s.append(this.buildTree(this.eventCreate.getStackTrace()));
        if (this.addRefEvents.size() > 0) {
            s.append("||----------------------------------------------------------------------\n");
            s.append("|| ADD REFERENCE:\n");
            s.append("||----------------------------------------------------------------------\n");
            s.append(this.buildMultiTree(this.addRefEvents));
        }
        if (this.removeRefEvents.size() > 0) {
            s.append("||----------------------------------------------------------------------\n");
            s.append("|| REMOVE REFERENCE:\n");
            s.append("||----------------------------------------------------------------------\n");
            s.append(this.buildMultiTree(this.removeRefEvents));
        }
        if (this.eventFinalDispose != null) {
            s.append("||----------------------------------------------------------------------\n");
            s.append("|| FINAL DISPOSE:\n");
            s.append("||----------------------------------------------------------------------\n");
            s.append(this.buildTree(this.eventFinalDispose.getStackTrace()));
        }
        s.append("||======================================================================\n");
        return s.toString();
    }

    private String buildMultiTree(ArrayList<Event> a) {
        StringBuffer t = new StringBuffer();
        for (Event currentEvent : a) {
            long delta = currentEvent.getTimeStamp() - this.eventCreate.getTimeStamp();
            t.append("||  TIME:  +" + delta + "ms\n");
            t.append(this.buildTree(currentEvent.getStackTrace()));
        }
        return t.toString();
    }

    private String buildTree(StackTraceElement[] stackTrace) {
        StringBuffer t = new StringBuffer();
        for (int i = 0; i < stackTrace.length; ++i) {
            String line = "||  ";
            for (int padding = 0; padding < i; ++padding) {
                line = line + "-";
            }
            line = line + this.buildStackFrameMessage(stackTrace[i]);
            t.append(line);
            t.append("\n");
        }
        t.append("||\n");
        return t.toString();
    }

    private String buildStackFrameMessage(StackTraceElement element) {
        String filename = element.getFileName();
        int lineNumber = element.getLineNumber();
        String className = element.getClassName();
        String methodName = element.getMethodName();
        return filename + ", line " + Integer.toString(lineNumber) + " {" + className + "::" + methodName + "}" + ")";
    }

    static class Event {
        private long timeStamp = System.currentTimeMillis();
        private StackTraceElement[] stackTrace;

        public Event(StackTraceElement[] stackTrace) {
            this.stackTrace = stackTrace;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }
    }
}

