/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.genericproperties.impl;

import com.ti.debug.engine.genericproperties.impl.ActivityProperty;
import com.ti.debug.genericproperties.IIntegerProperty;
import com.ti.debug.genericproperties.IProperty;
import com.ti.debug.genericproperties.IPropertyOperations;
import java.util.Arrays;

public class ActivityIntegerProperty
extends ActivityProperty
implements IIntegerProperty {
    private long myValue;
    private long[] validPropValues = null;
    private IIntegerProperty.IntegerValueRange validPropRange = null;

    private ActivityIntegerProperty() {
        super("I", "shouldn't exist", null, true, false);
    }

    public ActivityIntegerProperty(String name, String description, IProperty parent, boolean disabled, boolean editable, long value) throws IPropertyOperations.PropertyException {
        super(name, description, parent, disabled, editable);
        this.internalSetValue(value, true);
    }

    public ActivityIntegerProperty(String name, String description, IProperty parent, boolean disabled, boolean editable, long[] validValues, int valueIndex) throws IPropertyOperations.PropertyException {
        super(name, description, parent, disabled, editable);
        if (validValues == null || validValues.length == 0) {
            throw new IPropertyOperations.PropertyException("Some valid integer property values must be provided");
        }
        this.validPropValues = validValues;
        Arrays.sort(this.validPropValues);
        if (valueIndex < 0 || valueIndex >= validValues.length) {
            throw new IPropertyOperations.PropertyException("Initial value for integer property is invalid");
        }
        this.internalSetValue(this.validPropValues[valueIndex], true);
    }

    public ActivityIntegerProperty(String name, String description, IProperty parent, boolean disabled, boolean editable, long minValue, long maxValue, long value) throws IPropertyOperations.PropertyException {
        super(name, description, parent, disabled, editable);
        this.validPropRange = new IIntegerProperty.IntegerValueRange(minValue, maxValue);
        this.internalSetValue(value, true);
        if (value != this.getValue()) {
            throw new IPropertyOperations.PropertyException("Invalid property value specified");
        }
    }

    @Override
    public IIntegerProperty.IntegerValueRange getAllowedRange() {
        return this.validPropRange;
    }

    @Override
    public long[] getAllowedValues() {
        return this.validPropValues;
    }

    @Override
    public long getValue() {
        return this.myValue;
    }

    @Override
    public void setValue(long value) {
        this.internalSetValue(value, false);
    }

    private void internalSetValue(long value, boolean bInitializing) {
        if (!(bInitializing || this.editable() && !this.disabled())) {
            return;
        }
        if (this.validPropRange != null && (value < this.validPropRange.getMinimumValue() || value > this.validPropRange.getMaximumValue())) {
            return;
        }
        if (this.validPropValues != null && Arrays.binarySearch(this.validPropValues, value) < 0) {
            return;
        }
        this.myValue = value;
    }

    @Override
    public boolean equalTo(IProperty prop) {
        if (prop instanceof ActivityIntegerProperty) {
            if (!super.equalTo(prop)) {
                return false;
            }
            ActivityIntegerProperty toCompare = (ActivityIntegerProperty)prop;
            if (toCompare.getValue() != this.getValue()) {
                return false;
            }
            if (this.getAllowedRange() != null && !this.getAllowedRange().equalTo(toCompare.getAllowedRange()) || this.getAllowedRange() == null && toCompare.getAllowedRange() != null) {
                return false;
            }
            return Arrays.equals(this.getAllowedValues(), toCompare.getAllowedValues());
        }
        return false;
    }
}

