/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.genericproperties.impl;

import com.ti.debug.engine.genericproperties.impl.ActivityProperties;
import com.ti.debug.genericproperties.IProperties;
import com.ti.debug.genericproperties.IProperty;
import com.ti.debug.genericproperties.IPropertyOperations;

public class ActivityProperty
implements IProperty {
    private boolean bDisabled;
    private boolean bEditable;
    String sName;
    String sDescription;
    IProperty myParent;
    ActivityProperties mySubProperties;

    private ActivityProperty() {
    }

    public ActivityProperty(String name, String description, IProperty parent, boolean disabled, boolean editable) {
        this.sName = name;
        this.sDescription = description;
        this.myParent = parent;
        this.mySubProperties = new ActivityProperties();
        this.setDisabled(disabled);
        this.setEditable(editable);
    }

    public void setEditable(boolean bEditable) {
        this.bEditable = bEditable;
    }

    public void setDisabled(boolean bDisabled) {
        this.bDisabled = bDisabled;
    }

    @Override
    public boolean disabled() {
        return this.bDisabled;
    }

    @Override
    public boolean editable() {
        return this.bEditable;
    }

    @Override
    public String getDescription() {
        return this.sDescription;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public IProperty getParentProperty() {
        return this.myParent;
    }

    public boolean addProperty(IProperty newProperty) throws IPropertyOperations.PropertyException {
        if (newProperty == null) {
            throw new IPropertyOperations.PropertyException("null property is trying to be added as property");
        }
        return this.mySubProperties.addProperty(newProperty);
    }

    @Override
    public IProperties getSubProperties() {
        return this.mySubProperties;
    }

    @Override
    public boolean equalTo(IProperty prop) {
        if (this == prop) {
            return true;
        }
        if (prop == null) {
            return false;
        }
        return prop instanceof ActivityProperty && ((ActivityProperty)prop).getDescription().equals(this.sDescription) && ((ActivityProperty)prop).getName().equals(this.sName) && ((ActivityProperty)prop).disabled() == this.disabled() && ((ActivityProperty)prop).editable() == this.editable() && this.mySubProperties.equalTo(prop.getSubProperties());
    }
}

