/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.genericproperties.impl;

import com.ti.debug.engine.genericproperties.impl.ActivityProperty;
import com.ti.debug.genericproperties.IProperty;
import com.ti.debug.genericproperties.IPropertyOperations;
import com.ti.debug.genericproperties.IStringProperty;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Vector;

public class ActivityStringProperty
extends ActivityProperty
implements IStringProperty {
    private String sValue = null;
    private AbstractList<String> validPropValues = null;

    private ActivityStringProperty() {
        super("I", "shouldn't exist", null, true, false);
    }

    public ActivityStringProperty(String name, String description, IProperty parent, boolean disabled, boolean editable, String value) throws IPropertyOperations.PropertyException {
        super(name, description, parent, disabled, editable);
        this.internalSetValue(value, true);
    }

    public ActivityStringProperty(String name, String description, IProperty parent, boolean disabled, boolean editable, AbstractList<String> validValues, Integer valueIndex) throws IPropertyOperations.PropertyException {
        super(name, description, parent, disabled, editable);
        if (validValues == null || validValues.size() == 0) {
            throw new IPropertyOperations.PropertyException("String property cannot be constructed with empty valid values list");
        }
        this.validPropValues = new Vector<String>(validValues);
        if (valueIndex < 0 || valueIndex >= validValues.size()) {
            throw new IPropertyOperations.PropertyException("Invalid valid value index provided for initial property value");
        }
        this.setValue(validValues.get(valueIndex));
    }

    @Override
    public String[] getAllowedValues() {
        if (this.validPropValues != null) {
            String[] toReturn = new String[this.validPropValues.size()];
            this.validPropValues.toArray(toReturn);
            return toReturn;
        }
        return new String[0];
    }

    @Override
    public String getValue() {
        return this.sValue;
    }

    @Override
    public void setValue(String value) {
        this.internalSetValue(value, false);
    }

    private void internalSetValue(String value, boolean bInitializing) {
        if (!(bInitializing || this.editable() && !this.disabled())) {
            return;
        }
        if (this.validPropValues == null) {
            this.sValue = value;
            return;
        }
        for (String validString : this.validPropValues) {
            if (!validString.equals(value)) continue;
            this.sValue = value;
            return;
        }
    }

    @Override
    public boolean equalTo(IProperty prop) {
        if (prop instanceof ActivityStringProperty) {
            return super.equalTo(prop) && ((ActivityStringProperty)prop).getValue().equals(this.getValue()) && Arrays.equals(((ActivityStringProperty)prop).getAllowedValues(), this.getAllowedValues());
        }
        return false;
    }
}

