/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.framework.ImplementationComparable;
import com.ti.debug.engine.impl.DspMemory;
import com.ti.debug.engine.impl.DspValue;
import com.ti.xpcom.interfaces.dsIMemory;
import com.ti.xpcom.interfaces.dsITargetData;
import java.util.List;

abstract class ADspMemory
extends ImplementationComparable<dsIMemory>
implements IDspMemory {
    public ADspMemory(dsIMemory memory) {
        super(memory);
    }

    @Override
    public void assign(IDspMemory memSrc) {
        ADspMemory mem = (ADspMemory)memSrc;
        ((dsIMemory)this.wrappedObject).assign(mem.getWrappedMemory());
    }

    @Override
    public void changeStartAddress(IDspValue addrs) {
        DspValue addr = (DspValue)addrs;
        ((dsIMemory)this.wrappedObject).changeStartAddress(addr.getWrappedTargetData());
    }

    @Override
    public void copyFromMemory(IDspMemory memSrc, int srcAddrOffset, int destAddrOffset, int len) {
        ADspMemory mem = (ADspMemory)memSrc;
        ((dsIMemory)this.wrappedObject).copyFromMemory(mem.getWrappedMemory(), srcAddrOffset, destAddrOffset, len);
    }

    @Override
    public void copyFromMemoryByAddr(IDspMemory memSrc, IDspValue srcAddr, IDspValue destAddr, int len) {
        ADspMemory mem = (ADspMemory)memSrc;
        ((dsIMemory)this.wrappedObject).copyFromMemoryByAddr(mem.getWrappedMemory(), ((DspValue)srcAddr).getWrappedTargetData(), ((DspValue)destAddr).getWrappedTargetData(), len);
    }

    @Override
    public int copyOverlappingMemory(IDspMemory memSrc) {
        ADspMemory mem = (ADspMemory)memSrc;
        return ((dsIMemory)this.wrappedObject).copyOverlappingMemory(mem.getWrappedMemory());
    }

    @Override
    public void fillMem(IDspValue val) {
        DspValue value = (DspValue)val;
        ((dsIMemory)this.wrappedObject).fillMem(value.getWrappedTargetData());
    }

    @Override
    public void fillMemByLong(int val) {
        ((dsIMemory)this.wrappedObject).fillMemByLong(val);
    }

    @Override
    public int getDspValue(IDspValue dspValue, int offset) {
        dsITargetData targetData = ((DspValue)dspValue).getWrappedTargetData();
        int[] errorCode = new int[]{0};
        ((dsIMemory)this.wrappedObject).getValue(targetData, offset, errorCode);
        return errorCode[0];
    }

    @Override
    public IDspMemory2 getIDspMemory2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return ((dsIMemory)this.wrappedObject).getLength();
    }

    @Override
    public int getMem(int addrOffset) {
        return ((dsIMemory)this.wrappedObject).getMem(addrOffset);
    }

    @Override
    public int getMemByAddr(IDspValue addr) {
        DspValue val = (DspValue)addr;
        return ((dsIMemory)this.wrappedObject).getMemByAddr(val.getWrappedTargetData());
    }

    @Override
    public int getPageNumber() {
        return ((dsIMemory)this.wrappedObject).getPageNumber();
    }

    @Override
    public void getStartAddress(IDspValue addr) {
        ((dsIMemory)this.wrappedObject).getStartAddress(((DspValue)addr).getWrappedTargetData());
    }

    @Override
    public int overlap(IDspMemory memSrc) {
        ADspMemory mem = (ADspMemory)memSrc;
        return ((dsIMemory)this.wrappedObject).overlap(mem.getWrappedMemory());
    }

    @Override
    public void setDspValue(IDspValue val, int addrOffset) {
        DspValue value = (DspValue)val;
        ((dsIMemory)this.wrappedObject).setValue(value.getWrappedTargetData(), addrOffset);
    }

    @Override
    public int setLength(int length) {
        ((dsIMemory)this.wrappedObject).setLength(length);
        return length;
    }

    @Override
    public void setMem(int addrOffset, int val) {
        ((dsIMemory)this.wrappedObject).setMem(addrOffset, val);
    }

    @Override
    public void setMemByAddr(IDspValue addr, int val) {
        DspValue value = (DspValue)addr;
        ((dsIMemory)this.wrappedObject).setMemByAddr(value.getWrappedTargetData(), val);
    }

    @Override
    public void setPageNumber(int nPage) {
        ((dsIMemory)this.wrappedObject).setPageNumber((short)nPage);
    }

    public dsIMemory getWrappedMemory() {
        return (dsIMemory)this.wrappedObject;
    }

    @Override
    public int getErrorCode(int addrOffset) {
        return ((dsIMemory)this.wrappedObject).getErrorCode(addrOffset);
    }

    @Override
    public String getErrorString(int addrOffset, boolean isWrite) {
        return ((dsIMemory)this.wrappedObject).getErrorString(addrOffset, isWrite);
    }

    @Override
    public int getValueByAddr(IDspValue val, IDspValue addr) {
        dsITargetData targetData = ((DspValue)val).getWrappedTargetData();
        dsITargetData targetAddress = ((DspValue)addr).getWrappedTargetData();
        int[] errorCode = new int[]{0};
        ((dsIMemory)this.wrappedObject).getValueByAddr(targetData, targetAddress, errorCode);
        return errorCode[0];
    }

    @Override
    public void setValueByAddr(IDspValue val, IDspValue addr) {
        dsITargetData targetData = ((DspValue)val).getWrappedTargetData();
        dsITargetData targetAddress = ((DspValue)addr).getWrappedTargetData();
        ((dsIMemory)this.wrappedObject).setValueByAddr(targetData, targetAddress);
    }

    @Override
    public int[] getValues(IDspValue dspValueType, int addrOffset, long[][] values) {
        int[][] errorArray = new int[][]{{0}};
        long[] errorCount = new long[]{0L};
        long dataCount = values[0].length;
        dsITargetData targetData = ((DspValue)dspValueType).getWrappedTargetData();
        ((dsIMemory)this.wrappedObject).getValues(targetData, addrOffset, dataCount, values, errorCount, errorArray);
        return errorArray[0];
    }

    @Override
    public int[] getValues(IDspValue dspValueType, int addrOffset, int[][] values) {
        long[][] valuesLong = new long[][]{new long[values[0].length]};
        int[] errors = this.getValues(dspValueType, addrOffset, valuesLong);
        for (int i = 0; i < values[0].length; ++i) {
            values[0][i] = (int)valuesLong[0][i];
        }
        return errors;
    }

    @Override
    public int getValues(List<IDspMemory.IMemoryValue> memValues, IDspValue dspValueType, IDspValue.Format format, int addrOffset) {
        String[][] dataArray = new String[][]{{""}};
        int[][] hitCodeArray = new int[][]{{0}};
        int[][] errorArray = new int[][]{{0}};
        String[][] errorStringArray = new String[][]{{""}};
        int[][] errorCodes = new int[][]{{0}};
        long[] errorCount = new long[]{0L};
        int count = memValues.size();
        int lastError = 0;
        dsITargetData targetDataType = ((DspValue)dspValueType).getWrappedTargetData();
        ((dsIMemory)this.wrappedObject).getValuesAsString(targetDataType, format.translateToDspValueFormatEnum(), addrOffset, count, dataArray, hitCodeArray, errorCount, errorArray);
        for (int i = 0; i < count; ++i) {
            IDspMemory.IMemoryValue memVal = memValues.get(i);
            memVal.setData(dataArray[0][i]);
            memVal.setGtiHitCode(hitCodeArray[0][i]);
        }
        if (errorCount[0] > 0L) {
            int typeSize = targetDataType.sizeOf((short)this.getPageNumber());
            ((dsIMemory)this.wrappedObject).getErrors(errorCount[0], errorArray[0], errorCodes, errorStringArray);
            int i = 0;
            while ((long)i < errorCount[0]) {
                int indexIntoMemValues = (errorArray[0][i] - addrOffset) / typeSize;
                IDspMemory.IMemoryValue memVal = memValues.get(indexIntoMemValues);
                lastError = errorCodes[0][i];
                memVal.setErrorCode(errorCodes[0][i]);
                memVal.setErrorString(errorStringArray[0][i]);
                ++i;
            }
        }
        return lastError;
    }

    @Override
    public boolean compare(IDspMemory toCompare, int[] offset) {
        return ((dsIMemory)this.wrappedObject).compare((dsIMemory)((DspMemory)toCompare).wrappedObject, offset);
    }
}

