/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IActionGroup;
import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspBoards;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspTasks;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.ISynchronousGroup;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.types.IBooleanEventListener;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.DspTask;
import com.ti.xpcom.interfaces.dsIActionGroup;
import com.ti.xpcom.interfaces.dsITarget;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class ActionGroup
extends AComparableDisposable<dsIActionGroup>
implements IActionGroup,
ISynchronousGroup {
    private final HashSet<IDspTask> tasksCache = new HashSet();
    private final IDspBoards boards;
    private final ISimpleEvent managedOnSyncModeDisabled;

    ActionGroup(dsIActionGroup actionGroup, IDspBoards boards) {
        super(actionGroup);
        this.boards = boards;
        this.managedOnSyncModeDisabled = new ManagedSimpleEvent(((dsIActionGroup)this.wrappedObject).onSyncModeDisabled());
    }

    private Collection<IDspTask> toCollection(IDspTask dspTask) {
        Vector<IDspTask> tasks = new Vector<IDspTask>();
        tasks.add(dspTask);
        return tasks;
    }

    @Override
    public void add(IDspTask dspTask) {
        this.add(this.toCollection(dspTask));
    }

    @Override
    public void remove(IDspTask dspTask) {
        this.remove(this.toCollection(dspTask));
    }

    private dsITarget[] toXpcomArray(Collection<IDspTask> tasks) {
        dsITarget[] array = new dsITarget[tasks.size()];
        int i = 0;
        for (IDspTask task : tasks) {
            array[i++] = ((DspTask)task).getWrappedTarget();
        }
        return array;
    }

    @Override
    public void add(Collection<IDspTask> tasks) {
        ((dsIActionGroup)this.wrappedObject).add(tasks.size(), this.toXpcomArray(tasks));
        this.tasksCache.addAll(tasks);
    }

    @Override
    public void remove(Collection<IDspTask> tasks) {
        ((dsIActionGroup)this.wrappedObject).remove(tasks.size(), this.toXpcomArray(tasks));
        this.tasksCache.removeAll(tasks);
    }

    @Override
    public boolean canAdd(Collection<IDspTask> tasks) {
        return ((dsIActionGroup)this.wrappedObject).canAdd(tasks.size(), this.toXpcomArray(tasks));
    }

    @Override
    public boolean canRemove(Collection<IDspTask> tasks) {
        return ((dsIActionGroup)this.wrappedObject).canRemove(tasks.size(), this.toXpcomArray(tasks));
    }

    @Override
    public void asmStepInto() {
        ((dsIActionGroup)this.wrappedObject).asmStepInto();
    }

    @Override
    public void asmStepOver() {
        ((dsIActionGroup)this.wrappedObject).asmStepOver();
    }

    @Override
    public void halt() {
        ((dsIActionGroup)this.wrappedObject).halt();
    }

    @Override
    public void run() {
        ((dsIActionGroup)this.wrappedObject).run();
    }

    @Override
    public void sourceStepInto() {
        ((dsIActionGroup)this.wrappedObject).sourceStepInto();
    }

    @Override
    public void sourceStepOver() {
        ((dsIActionGroup)this.wrappedObject).sourceStepOver();
    }

    @Override
    public void stepOut() {
        ((dsIActionGroup)this.wrappedObject).stepOut();
    }

    @Override
    public int getCount() {
        return ((dsIActionGroup)this.wrappedObject).getCount();
    }

    @Override
    public IDspTask getItem(int index) {
        return new DspTask(((dsIActionGroup)this.wrappedObject).item(index), false);
    }

    private boolean isSourceStepIntoAllowed() {
        int size = this.getCount();
        for (int i = 0; i < size; ++i) {
            IDspTask task = this.getItem(i);
            IDspUser user = task.createDspUser();
            boolean allowed = user.getSrcStepIntoAllowed();
            if (allowed) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stepInto() {
        if (this.isSourceStepIntoAllowed()) {
            this.sourceStepInto();
        } else {
            this.asmStepInto();
        }
    }

    @Override
    public void stepOver() {
        if (this.isSourceStepIntoAllowed()) {
            this.sourceStepOver();
        } else {
            this.asmStepOver();
        }
    }

    private Stack<IDspTask> getTasksInSetupOrder() {
        Stack<IDspTask> orderedTasks = new Stack<IDspTask>();
        for (int boardIndex = this.boards.getCount() - 1; boardIndex >= 0; --boardIndex) {
            this.getTasksInSetupOrder(orderedTasks, this.boards.getItem(boardIndex).getDspTasks());
            this.getTasksInSetupOrder(orderedTasks, this.boards.getItem(boardIndex).getNonDebugTasks());
        }
        return orderedTasks;
    }

    private void getTasksInSetupOrder(Stack<IDspTask> orderedTasks, IDspTasks tasks) {
        for (int taskIndex = tasks.getCount() - 1; taskIndex >= 0; --taskIndex) {
            IDspTask task = tasks.getItem(taskIndex);
            if (!this.tasksCache.contains(task)) continue;
            orderedTasks.push(task);
        }
    }

    @Override
    public ICancelable targetConnect(IBooleanEventListener listener) {
        return new PerformOperationOnGroup(listener){

            @Override
            protected ICancelable doOperation(IDspTask nextTask, IBooleanEventListener listener) {
                return nextTask.getTargetConnection().targetConnect(listener);
            }
        };
    }

    @Override
    public ICancelable targetDisconnect(final ISimpleEventListener listener) {
        IBooleanEventListener listenerAdapter = null;
        if (null != listener) {
            listenerAdapter = new IBooleanEventListener(){

                @Override
                public void onEvent(boolean data) {
                    listener.onEvent();
                }
            };
        }
        return new PerformOperationOnGroup(listenerAdapter){

            @Override
            protected ICancelable doOperation(IDspTask nextTask, final IBooleanEventListener listener) {
                return nextTask.getTargetConnection().targetDisconnect(new ISimpleEventListener(){

                    @Override
                    public void onEvent() {
                        listener.onEvent(true);
                    }
                });
            }
        };
    }

    @Override
    public void cpuReset() {
        if (!this.tasksCache.isEmpty()) {
            if (this.isSyncModeEnabled()) {
                this.tasksCache.iterator().next().getResetManager().getAdvancedResets().getDefaultReset().issueReset();
            } else {
                for (IDspTask task : this.tasksCache) {
                    task.getResetManager().getAdvancedResets().getDefaultReset().issueReset();
                }
            }
        }
    }

    @Override
    public boolean willOperationsBeSynchronous() {
        return ((dsIActionGroup)this.wrappedObject).willOperationsBeSynchronous();
    }

    @Override
    public boolean canEnableSyncMode() {
        return ((dsIActionGroup)this.wrappedObject).canToggleSyncMode();
    }

    @Override
    public boolean isSyncModeEnabled() {
        return ((dsIActionGroup)this.wrappedObject).isSyncModeEnabled();
    }

    @Override
    public void enableSyncMode(boolean enable) {
        ((dsIActionGroup)this.wrappedObject).enableSyncMode(enable);
    }

    @Override
    public ISimpleEvent onSyncModeDisabled() {
        return this.managedOnSyncModeDisabled;
    }

    static /* synthetic */ Stack access$000(ActionGroup x0) {
        return x0.getTasksInSetupOrder();
    }

    private abstract class PerformOperationOnGroup
    implements ICancelable {
        private ICancelable cancelable = null;
        private final Stack<IDspTask> tasksToConnect = ActionGroup.access$000(ActionGroup.this);
        private final IBooleanEventListener listener;

        private PerformOperationOnGroup(IBooleanEventListener listener) {
            this.listener = listener;
            this.doOperationOnNextTask(new IBooleanEventListener(){

                @Override
                public void onEvent(boolean successful) {
                    if (!successful) {
                        PerformOperationOnGroup.this.allOperationsComplete(false);
                    } else {
                        PerformOperationOnGroup.this.doOperationOnNextTask(this);
                    }
                }
            });
        }

        private void doOperationOnNextTask(IBooleanEventListener callback) {
            if (this.tasksToConnect.isEmpty()) {
                this.allOperationsComplete(true);
            } else {
                this.cancelable = this.doOperation(this.tasksToConnect.pop(), callback);
            }
        }

        private void allOperationsComplete(boolean success) {
            this.cancelable = null;
            if (null != this.listener) {
                this.listener.onEvent(success);
            }
        }

        protected abstract ICancelable doOperation(IDspTask var1, IBooleanEventListener var2);

        @Override
        public boolean cancel() {
            if (null == this.cancelable) {
                return false;
            }
            return this.cancelable.cancel();
        }
    }
}

