/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IAdvancedReset;
import com.ti.debug.engine.IAdvancedResets;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.AdvancedReset;
import com.ti.debug.engine.impl.FunctionResultCache;
import com.ti.xpcom.interfaces.dsIResetCollection;
import java.util.List;
import java.util.Vector;

public class AdvancedResets
extends AComparableDisposable<dsIResetCollection>
implements IAdvancedResets {
    private final ISimpleEvent onResetsChanged;
    private final FunctionResultCache<Integer> getCountCache;
    private final FunctionResultCache<List<IAdvancedReset>> itemCache;

    AdvancedResets(dsIResetCollection resetCollection) {
        super(resetCollection);
        this.onResetsChanged = new ManagedSimpleEvent(resetCollection.onResetsChanged());
        this.getCountCache = new ResetCache<Integer>(){

            @Override
            protected Integer fetchUncachedValue() {
                return ((dsIResetCollection)AdvancedResets.this.wrappedObject).getCount();
            }
        };
        this.itemCache = new ResetCache<List<IAdvancedReset>>(){

            @Override
            protected List<IAdvancedReset> fetchUncachedValue() {
                Vector<IAdvancedReset> collection = new Vector<IAdvancedReset>();
                int count = AdvancedResets.this.getCount();
                for (int i = 0; i < count; ++i) {
                    collection.add(new AdvancedReset(((dsIResetCollection)AdvancedResets.this.wrappedObject).item(i)));
                }
                return collection;
            }
        };
    }

    @Override
    public int getCount() {
        return this.getCountCache.fetch();
    }

    @Override
    public IAdvancedReset item(int index) {
        return this.itemCache.fetch().get(index);
    }

    @Override
    public IAdvancedReset getDefaultReset() {
        return this.item(0);
    }

    private abstract class ResetCache<ResultType>
    extends FunctionResultCache<ResultType> {
        ResetCache() {
            this.InvalidateOn(AdvancedResets.this.onResetsChanged);
        }
    }
}

