/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IActionGroup;
import com.ti.debug.engine.IActivityProviderServer;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspBoard;
import com.ti.debug.engine.IDspBoards;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspTasks;
import com.ti.debug.engine.IGenericComponent;
import com.ti.debug.engine.IProfDataServer;
import com.ti.debug.engine.IProgressTask;
import com.ti.debug.engine.ISynchronousGroup;
import com.ti.debug.engine.ITransaction;
import com.ti.debug.engine.cce.CCEDebugEngine;
import com.ti.debug.engine.dialogs.IBaseDialog;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.impl.ManagedStringEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.events.types.IStringEvent;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.ActionGroup;
import com.ti.debug.engine.impl.DspBoards;
import com.ti.debug.engine.impl.EmptyTransaction;
import com.ti.debug.engine.impl.FunctionResultCache;
import com.ti.debug.engine.impl.ProfileDataServer;
import com.ti.debug.engine.impl.SimpleEvent;
import com.ti.debug.engine.profileactivities.ActivityProviderServer;
import com.ti.debug.engine.profileactivities.ProfileActivityProviderFactory;
import com.ti.debug.engine.xpcom.event.impl.MessageDialogEventTranslator;
import com.ti.debug.engine.xpcom.event.impl.ProgressTasksTranslator;
import com.ti.logger.IDSLogger;
import com.ti.logger.impl.DSLogger;
import com.ti.utility.filesystem.FSUtil;
import com.ti.xpcom.interfaces.dsIDebugger;
import com.ti.xpcom.interfaces.dsIErrorOutput;
import com.ti.xpcom.interfaces.dsIMessageDialogs;
import com.ti.xpcom.interfaces.dsIProgressTasks;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Application
extends AComparableDisposable<dsIDebugger>
implements IApplication {
    protected boolean bUsingXPCOMRuntime = true;
    protected dsIProgressTasks wrappedProgressTasks;
    protected dsIMessageDialogs wrappedMessageDialogs;
    protected ActivityProviderServer wrappedActivityProvider;
    protected ManagedObjectEvent<IEventData<IProgressTask>> managedOnTaskStart;
    protected ManagedStringEvent managedOnError;
    protected ManagedStringEvent managedOnFatal;
    protected ManagedStringEvent managedOnWarning;
    protected ManagedStringEvent managedOnInfo;
    protected ManagedObjectEvent<IBaseDialog> managedOnMessageDialog;
    private ManagedSimpleEvent managedOnConfigureFailed;
    private ManagedSimpleEvent managedOnConfigured;
    private ManagedSimpleEvent managedOnDeConfigured;
    private IDSLogger loggerInstance = DSLogger.getLogger();
    protected Logger traceLog;
    private static final String NS_XDEBUGSERVERCONTRACTID = "@ti.com/DebugServer;1";
    private final FunctionResultCache<IDspBoards> boardsCache;
    private File currentConfiguration;
    private ISimpleEventListener onConfigureListener;
    private Object postConfigureLock = new Object();
    private boolean isConfigured = false;
    private final Map<String, IGenericComponent> genericComponents = new HashMap<String, IGenericComponent>();
    private final SimpleEvent onDisposeEvent = new SimpleEvent();
    private dsIErrorOutput wrappedErrorOutput;
    private static Collection<ISimpleEventListener> listenerReferences = new HashSet<ISimpleEventListener>();
    protected static CCEDebugEngine.PollingThread pollingThread = null;

    public Application() {
        super((dsIDebugger)com.ti.debug.engine.xpcom.Runtime.getInstance().createComponent(NS_XDEBUGSERVERCONTRACTID, "{bfab7a88-14c8-48be-8729-f7701e4e0f35}"));
        this.wrappedActivityProvider = ActivityProviderServer.getActivityProviderServer();
        this.wrappedProgressTasks = (dsIProgressTasks)((dsIDebugger)this.wrappedObject).queryInterface("{25dd797e-b119-4666-8fdb-5b197ba07c6e}");
        this.managedOnTaskStart = new ManagedObjectEvent<IEventData<IProgressTask>>(this.wrappedProgressTasks.onTaskStart(), new ProgressTasksTranslator());
        this.wrappedMessageDialogs = (dsIMessageDialogs)((dsIDebugger)this.wrappedObject).queryInterface("{87923885-a065-4077-b187-2b5284f53e36}");
        this.managedOnMessageDialog = new ManagedObjectEvent<IBaseDialog>(this.wrappedMessageDialogs.onMessageDialog(), new MessageDialogEventTranslator());
        this.wrappedErrorOutput = (dsIErrorOutput)((dsIDebugger)this.wrappedObject).queryInterface("{438eddab-53f6-4bb1-9bad-70907641e733}");
        this.managedOnFatal = new ManagedStringEvent(this.wrappedErrorOutput.onFatal());
        this.managedOnError = new ManagedStringEvent(this.wrappedErrorOutput.onError());
        this.managedOnWarning = new ManagedStringEvent(this.wrappedErrorOutput.onWarning());
        this.managedOnInfo = new ManagedStringEvent(this.wrappedErrorOutput.onInfo());
        this.managedOnConfigureFailed = new ManagedSimpleEvent(((dsIDebugger)this.wrappedObject).onConfigureFailed());
        this.managedOnConfigured = new ManagedSimpleEvent(((dsIDebugger)this.wrappedObject).onConfigured());
        this.managedOnDeConfigured = new ManagedSimpleEvent(((dsIDebugger)this.wrappedObject).onDeConfigured());
        this.boardsCache = new FunctionResultCache<IDspBoards>(){
            {
                this.InvalidateOn(Application.this.managedOnDeConfigured);
            }

            @Override
            protected IDspBoards fetchUncachedValue() {
                return new DspBoards(((dsIDebugger)Application.this.wrappedObject).getDevices());
            }
        };
    }

    @Override
    public IDspBoards getDspBoards() {
        return this.boardsCache.fetch();
    }

    @Override
    public IProfDataServer getProfileDataServer() {
        return new ProfileDataServer(((dsIDebugger)this.wrappedObject).getProfileDataServer());
    }

    @Override
    public IActivityProviderServer getActivityProviderServer() {
        return this.wrappedActivityProvider;
    }

    @Override
    public void initialize(String systemSetupXmlPath) throws IApplication.InitializationException {
        class WaitForConfigure
        implements IObjectEventListener<IApplication.InitializationException> {
            private IApplication.InitializationException exception = null;
            private boolean gotEvent = false;
            private final Object lock = new Object();

            WaitForConfigure() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(IApplication.InitializationException data) {
                Object object = this.lock;
                synchronized (object) {
                    this.exception = data;
                    this.gotEvent = true;
                    this.lock.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void go() throws IApplication.InitializationException {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.gotEvent) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (null != this.exception) {
                        throw this.exception;
                    }
                }
            }
        }
        WaitForConfigure waitForConfigure = new WaitForConfigure();
        this.configure(systemSetupXmlPath, waitForConfigure, true);
        waitForConfigure.go();
    }

    @Override
    public ICancelable configure(String systemSetupXmlPath, IObjectEventListener<IApplication.InitializationException> callback) {
        return this.configure(systemSetupXmlPath, callback, true);
    }

    private ICancelable returnWithError(IObjectEventListener<IApplication.InitializationException> callback, IApplication.InitializationException exception) {
        if (null != callback) {
            callback.onEvent(exception);
        }
        return new ICancelable(){

            @Override
            public boolean cancel() {
                return false;
            }
        };
    }

    protected ICancelable configure(String systemSetupXmlPath, IObjectEventListener<IApplication.InitializationException> callback, boolean initializeGenericComponents) {
        return this.configure(systemSetupXmlPath, callback, initializeGenericComponents, false);
    }

    protected ICancelable configure(String systemSetupXmlPath, final IObjectEventListener<IApplication.InitializationException> callback, final boolean initializeGenericComponents, boolean disableCtools) {
        if (!com.ti.debug.engine.xpcom.Runtime.isASCII(systemSetupXmlPath)) {
            String message = "The target configuration path: " + systemSetupXmlPath + " contains invalid characters: ";
            for (int i = 0; i < systemSetupXmlPath.length(); ++i) {
                if (systemSetupXmlPath.charAt(i) <= '\u007f') continue;
                message = message + "\n" + systemSetupXmlPath.charAt(i);
            }
            return this.returnWithError(callback, new IApplication.InitializationException(message, false));
        }
        if (this.isConfigured()) {
            if (this.currentConfiguration.equals(new File(systemSetupXmlPath))) {
                return this.returnWithError(callback, null);
            }
            String message = "The target configuration " + systemSetupXmlPath + " is not compatible with the current target configuration " + this.currentConfiguration;
            return this.returnWithError(callback, new IApplication.InitializationException(message, false));
        }
        this.currentConfiguration = new File(systemSetupXmlPath);
        this.onConfigureListener = new ISimpleEventListener(){

            @Override
            public void onEvent() {
                Application.this.managedOnConfigured.removeISimpleEventListener(this);
                Application.this.managedOnConfigureFailed.removeISimpleEventListener(this);
                Thread postConfigure = new Thread("Post configure operations"){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                Application.this.postConfigure(initializeGenericComponents);
                                if (null != callback) {
                                    callback.onEvent(null);
                                }
                            }
                            catch (IApplication.InitializationException e) {
                                if (null == callback) break block3;
                                callback.onEvent(e);
                            }
                        }
                    }
                };
                postConfigure.start();
            }
        };
        this.managedOnConfigured.addISimpleEventListener(this.onConfigureListener);
        this.managedOnConfigureFailed.addISimpleEventListener(this.onConfigureListener);
        ((dsIDebugger)this.wrappedObject).configure(systemSetupXmlPath, disableCtools);
        this.kickPolling();
        return new ICancelable(){

            @Override
            public boolean cancel() {
                if (!Application.this.isConfigured()) {
                    Application.this.deConfigure();
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postConfigure(boolean initializeGenericComponents) throws IApplication.InitializationException {
        Object object = this.postConfigureLock;
        synchronized (object) {
            if (((dsIDebugger)this.wrappedObject).getInitialized()) {
                ProfileActivityProviderFactory.getFactory().generateActivityProviders(this);
                try {
                    if (initializeGenericComponents) {
                        this.initializeGenericComponents();
                    }
                    this.isConfigured = true;
                }
                catch (Exception e) {
                    this.deConfigure();
                    throw new IApplication.InitializationException(e.getMessage(), false);
                }
            } else {
                throw this.getInitializationException();
            }
        }
    }

    private IApplication.InitializationException getInitializationException() {
        boolean[] hasUserSeenError = new boolean[1];
        String message = ((dsIDebugger)this.wrappedObject).getInitError(hasUserSeenError);
        return new IApplication.InitializationException(message, hasUserSeenError[0]);
    }

    @Override
    public ISynchronousGroup createSynchronousGroup() {
        return (ISynchronousGroup)this.createActionGroup();
    }

    @Override
    public IActionGroup createActionGroup() {
        return new ActionGroup(((dsIDebugger)this.wrappedObject).createActionGroup(), this.getDspBoards());
    }

    @Override
    public IStringEvent onError() {
        return this.managedOnError;
    }

    @Override
    public IStringEvent onFatal() {
        return this.managedOnFatal;
    }

    @Override
    public IStringEvent onInfo() {
        return this.managedOnInfo;
    }

    @Override
    public IStringEvent onWarning() {
        return this.managedOnWarning;
    }

    @Override
    public IObjectEvent<IEventData<IProgressTask>> onTaskStart() {
        return this.managedOnTaskStart;
    }

    private void initializeGenericComponents() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        IDspBoards boards = this.getDspBoards();
        int boardCount = boards.getCount();
        for (int curBoard = 0; curBoard < boardCount; ++curBoard) {
            IDspBoard board = boards.getItem(curBoard);
            IDspTasks tasks = board.getDspTasks();
            this.addComponents(tasks);
            tasks = board.getNonDebugTasks();
            this.addComponents(tasks);
        }
    }

    private void addComponents(IDspTasks tasks) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int taskCount = tasks.getCount();
        for (int curTask = 0; curTask < taskCount; ++curTask) {
            IDspTask task = tasks.getItem(curTask);
            IGenericComponent debugSession = this.createDebugSession(task);
            IGenericComponent rtdxSession = this.createRTDXSession(debugSession);
            this.genericComponents.put(task.getFullPathName() + debugSession.getClass().toString(), debugSession);
            this.genericComponents.put(task.getFullPathName() + rtdxSession.getClass().toString(), rtdxSession);
        }
    }

    private IGenericComponent createDebugSession(IDspTask task) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> sessionDefinition = Class.forName("com.ti.debug.engine.scripting.DebugSession");
        Class[] constructorSignature = new Class[]{IApplication.class, IDspTask.class};
        Constructor<?> sessionConstructor = sessionDefinition.getConstructor(constructorSignature);
        Object[] constructorArgs = new Object[]{this, task};
        IGenericComponent genericComponent = (IGenericComponent)sessionConstructor.newInstance(constructorArgs);
        return genericComponent;
    }

    private IGenericComponent createRTDXSession(IGenericComponent debugSession) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> sessionDefinition = Class.forName("com.ti.debug.engine.scripting.RTDXSession");
        Class[] constructorSignature = new Class[]{IGenericComponent.class};
        Constructor<?> sessionConstructor = sessionDefinition.getConstructor(constructorSignature);
        Object[] constructorArgs = new Object[]{debugSession};
        IGenericComponent genericComponent = (IGenericComponent)sessionConstructor.newInstance(constructorArgs);
        return genericComponent;
    }

    @Override
    public IGenericComponent getComponent(String taskName, String componentName) {
        return this.genericComponents.get(taskName + componentName);
    }

    @Override
    public ISimpleEvent onDispose() {
        return this.onDisposeEvent;
    }

    @Override
    public IObjectEvent<IBaseDialog> onMessageDialog() {
        return this.managedOnMessageDialog;
    }

    @Override
    public ITransaction beginDebuggerAccess() {
        return new EmptyTransaction();
    }

    @Override
    public ICancelable deConfigure(final ISimpleEventListener callback) {
        class OnDeconfigure
        implements ISimpleEventListener {
            public OnDeconfigure() {
                listenerReferences.add(this);
            }

            public void unregister() {
                listenerReferences.remove(this);
                Application.this.managedOnDeConfigured.removeISimpleEventListener(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent() {
                try {
                    if (null != callback) {
                        callback.onEvent();
                    }
                }
                finally {
                    Application.this.loggerInstance = null;
                    this.unregister();
                }
            }
        }
        OnDeconfigure onDeconfigure = new OnDeconfigure();
        this.managedOnDeConfigured.addISimpleEventListener(onDeconfigure);
        try {
            this.shutdown();
        }
        catch (RuntimeException e) {
            onDeconfigure.unregister();
            throw e;
        }
        return new ICancelable(){

            @Override
            public boolean cancel() {
                return false;
            }
        };
    }

    protected void deConfigure() {
        class WaitForSimpleEvent
        implements ISimpleEventListener {
            private volatile boolean gotEvent = false;

            WaitForSimpleEvent() {
            }

            @Override
            public synchronized void onEvent() {
                this.gotEvent = true;
                this.notify();
            }

            public synchronized void waitForEvent() {
                if (!this.gotEvent) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        WaitForSimpleEvent waiter = new WaitForSimpleEvent();
        this.deConfigure(waiter);
        waiter.waitForEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        Object object = this.postConfigureLock;
        synchronized (object) {
            if (this.isConfigured()) {
                ProfileActivityProviderFactory.getFactory().destroyActivityProviders();
            }
            this.isConfigured = false;
            for (IGenericComponent component : this.genericComponents.values()) {
                try {
                    component.terminate();
                }
                catch (Exception e) {
                    assert (false);
                    e.printStackTrace();
                }
            }
            ((dsIDebugger)this.wrappedObject).deConfigure();
        }
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    public String getConfiguration() {
        if (this.isConfigured()) {
            return this.currentConfiguration.getPath();
        }
        return null;
    }

    private void kickPolling() {
        if (null != pollingThread) {
            pollingThread.wakeUp();
        }
    }

    @Override
    public Process testConnection(String ccxmlFile, int connectionNumber, String commandLine) throws IOException {
        commandLine = this.replaceBoardDataFile(ccxmlFile, connectionNumber, commandLine);
        commandLine = this.replaceCcsBase(commandLine);
        return Runtime.getRuntime().exec(commandLine, null, this.workingDirectory(commandLine));
    }

    private File workingDirectory(String commandLine) {
        File commandPath = new File(new StringTokenizer(commandLine).nextToken());
        if (commandPath.isAbsolute() && commandPath.isFile()) {
            return commandPath.getParentFile();
        }
        return null;
    }

    private String replaceCcsBase(String commandLine) {
        return commandLine.replace("%ccs_base%", FSUtil.FSUtil_Get_Base_Dir(com.ti.debug.engine.xpcom.Runtime.getFSUtil()));
    }

    private String replaceBoardDataFile(String ccxmlFile, int connectionNumber, String commandLine) throws IOException {
        if (commandLine.contains("%boarddatafile%")) {
            String[] errorMessage = new String[1];
            String sBoardDataFile = ((dsIDebugger)this.wrappedObject).generateBoardDataFile(ccxmlFile, connectionNumber, errorMessage);
            if (null != errorMessage[0]) {
                throw new IOException(errorMessage[0]);
            }
            commandLine = commandLine.replace("%boarddatafile%", "\"" + sBoardDataFile + "\"");
        }
        return commandLine;
    }
}

