/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IBreakpointIntegerProperty;
import com.ti.debug.engine.impl.BreakpointProperty;
import com.ti.xpcom.interfaces.dsIBreakpointIntegerProperty;

public class BreakpointIntegerProperty
extends BreakpointProperty
implements IBreakpointIntegerProperty {
    private static final long LOWER_MASK = 0xFFFFFFFFL;
    private static final long UPPER_MASK = -4294967296L;
    private dsIBreakpointIntegerProperty wrappedBreakpointIntegerProperty;

    BreakpointIntegerProperty(dsIBreakpointIntegerProperty breakpointIntegerProperty) {
        super(breakpointIntegerProperty);
        this.wrappedBreakpointIntegerProperty = breakpointIntegerProperty;
    }

    public int getValue(int[] pnUpperBits) {
        long value = this.wrappedBreakpointIntegerProperty.getValue();
        pnUpperBits[0] = (int)((value | 0xFFFFFFFF00000000L) >> 32);
        int lowerBits = (int)(value | 0xFFFFFFFFL);
        return lowerBits;
    }

    public void setValue(int nUpperBits, int nLowerBits) {
        long value = (long)nUpperBits << 32 | (long)nLowerBits;
        this.wrappedBreakpointIntegerProperty.setValue(value);
    }

    @Override
    public long[] getAllowedValues() {
        long[] values = null;
        int numValues = this.wrappedBreakpointIntegerProperty.getNumAllowedValues();
        if (numValues < 0) {
            return values;
        }
        values = new long[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = this.wrappedBreakpointIntegerProperty.getAllowedValue(i);
        }
        return values;
    }

    @Override
    public long getValue() {
        return this.wrappedBreakpointIntegerProperty.getValue();
    }

    @Override
    public boolean hasAllowedRange(long[] min, long[] max) {
        return this.wrappedBreakpointIntegerProperty.hasAllowedRange(min, max);
    }

    @Override
    public void setValue(long value) {
        this.wrappedBreakpointIntegerProperty.setValue(value);
    }

    @Override
    public IBreakpointIntegerProperty.DisplaySuggestion getDisplaySuggestion() {
        switch (this.wrappedBreakpointIntegerProperty.getDisplaySuggestion()) {
            default: {
                assert (false);
            }
            case 0: {
                return IBreakpointIntegerProperty.DisplaySuggestion.HEX;
            }
            case 1: 
        }
        return IBreakpointIntegerProperty.DisplaySuggestion.DEC;
    }
}

