/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IBreakpoint;
import com.ti.debug.engine.IBreakpointActionListeners;
import com.ti.debug.engine.IBreakpointLocation;
import com.ti.debug.engine.IBreakpointManager;
import com.ti.debug.engine.IBreakpoints;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.impl.Breakpoint;
import com.ti.debug.engine.impl.BreakpointActionListeners;
import com.ti.debug.engine.impl.BreakpointLocation;
import com.ti.debug.engine.impl.Breakpoints;
import com.ti.debug.engine.impl.DspTask;
import com.ti.debug.engine.xpcom.event.impl.ABreakpointManagerEvents;
import com.ti.xpcom.interfaces.dsIBreakpoint;
import com.ti.xpcom.interfaces.dsIBreakpointException;
import com.ti.xpcom.interfaces.dsIBreakpointManager;
import com.ti.xpcom.interfaces.dsIBreakpointManagerEvents;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BreakpointManager
extends ABreakpointManagerEvents
implements IBreakpointManager {
    protected final dsIBreakpointManager wrappedBreakpointManager;
    private IDspUser dspUser = null;
    private DspTask dspTask = null;
    private final ISimpleEventListener allowedToAccessCacheInvalidator = new ISimpleEventListener(){

        @Override
        public void onEvent() {
            BreakpointManager.this.allowUserToModifyCache.clear();
        }
    };
    private final Map<Integer, Boolean> allowUserToModifyCache = Collections.synchronizedMap(new HashMap());
    private ITargetConnection targetConnection = null;
    private int numBreakpointTypesCache = 1;
    private boolean isNumBreakpointTypesCacheValid = false;

    BreakpointManager(dsIBreakpointManager breakpointManager) {
        super((dsIBreakpointManagerEvents)breakpointManager.queryInterface("{bbd503c6-93ab-4cd1-949c-8fbb321e5334}"));
        this.wrappedBreakpointManager = breakpointManager;
    }

    BreakpointManager(BreakpointManager breakpointManager) {
        super(breakpointManager);
        this.wrappedBreakpointManager = breakpointManager.wrappedBreakpointManager;
        this.setDspTask(breakpointManager.dspTask);
        assert (this.dspUser != null);
        assert (this.targetConnection != null);
    }

    protected void checkForException(dsIBreakpointException e) throws IBreakpointManager.BreakpointException {
        if (null != e) {
            if (e.isExpected()) {
                throw new IBreakpointManager.BreakpointExpectedException(e.getExplanation());
            }
            throw new IBreakpointManager.BreakpointException(e.getExplanation());
        }
    }

    @Override
    public void add(IBreakpoint breakpoint) {
        dsIBreakpoint realBreakpoint = ((Breakpoint)breakpoint).getWrappedBreakpoint();
        this.wrappedBreakpointManager.add(realBreakpoint);
    }

    @Override
    public boolean capablePrecisePCBreakpoint(int nType) {
        return this.wrappedBreakpointManager.capablePrecisePCBreak(nType);
    }

    @Override
    public IBreakpoint createBreakpoint(int type) {
        return new Breakpoint(this.wrappedBreakpointManager.createBreakpoint(type));
    }

    @Override
    public void createGroup(String psGroupName) {
        this.wrappedBreakpointManager.createGroup(psGroupName);
    }

    @Override
    public IBreakpointLocation createLocation() {
        return new BreakpointLocation(this.wrappedBreakpointManager.createLocation());
    }

    @Override
    public void deleteGroup(String psGroupName) {
        this.wrappedBreakpointManager.deleteGroup(psGroupName);
    }

    @Override
    public synchronized void disable(IBreakpoint breakpoint) throws IBreakpointManager.BreakpointExpectedException, IBreakpointManager.BreakpointException {
        this.checkForException(this.wrappedBreakpointManager.disable(((Breakpoint)breakpoint).getWrappedBreakpoint()));
    }

    @Override
    public synchronized void enable(IBreakpoint breakpoint) throws IBreakpointManager.BreakpointExpectedException, IBreakpointManager.BreakpointException {
        this.checkForException(this.wrappedBreakpointManager.enable(((Breakpoint)breakpoint).getWrappedBreakpoint()));
    }

    @Override
    public synchronized void addAndEnable(IBreakpoint breakpoint) throws IBreakpointManager.BreakpointExpectedException, IBreakpointManager.BreakpointException {
        this.checkForException(this.wrappedBreakpointManager.addAndEnable(((Breakpoint)breakpoint).getWrappedBreakpoint()));
    }

    @Override
    public synchronized void addAndPlaceInLastDebugState(IBreakpoint breakpoint) {
        this.wrappedBreakpointManager.addAndPlaceInLastDebugState(((Breakpoint)breakpoint).getWrappedBreakpoint());
    }

    @Override
    public IBreakpointActionListeners getActionListeners() {
        return new BreakpointActionListeners(this.wrappedBreakpointManager.getActionListeners());
    }

    @Override
    public String getBreakpointType(int nVal) {
        return this.wrappedBreakpointManager.breakpointType(nVal);
    }

    @Override
    public IBreakpoints getBreakpoints(int state) {
        return new Breakpoints(this.wrappedBreakpointManager.getBreakpoints(state));
    }

    @Override
    public IBreakpoints getBreakpointsByLocation(int eState, IBreakpointLocation pLocation) {
        return new Breakpoints(this.wrappedBreakpointManager.getBreakpointsByLocation(eState, ((BreakpointLocation)pLocation).getWrappedBreakpointLocation()));
    }

    @Override
    public String getGroup(int nGroupNum) {
        return this.wrappedBreakpointManager.group(nGroupNum);
    }

    @Override
    public int getNumGroups() {
        return this.wrappedBreakpointManager.numGroups();
    }

    @Override
    public IBreakpoints getUserBreakpoints(int state) {
        return new Breakpoints(this.wrappedBreakpointManager.getUserBreakpoints(state));
    }

    @Override
    public void remove(IBreakpoint breakpoint) {
        this.wrappedBreakpointManager.remove(((Breakpoint)breakpoint).getWrappedBreakpoint());
    }

    @Override
    public void restoreConfiguration(String psFileName) throws IBreakpointManager.BreakpointException {
        String sError = this.wrappedBreakpointManager.restoreConfiguration(psFileName);
        if (sError.length() != 0) {
            throw new IBreakpointManager.BreakpointException(sError);
        }
    }

    @Override
    public void saveConfiguration(String psFileName) throws IBreakpointManager.BreakpointException {
        String sError = this.wrappedBreakpointManager.saveConfiguration(psFileName);
        if (sError.length() != 0) {
            throw new IBreakpointManager.BreakpointException(sError);
        }
    }

    @Override
    public IBreakpoint createBreakpointFromString(String serializationData) throws IBreakpointManager.BreakpointException {
        String[] sError = new String[1];
        dsIBreakpoint breakpoint = this.wrappedBreakpointManager.createBreakpointFromString(serializationData, sError);
        if (sError[0].length() != 0) {
            throw new IBreakpointManager.BreakpointException(sError[0]);
        }
        return new Breakpoint(breakpoint);
    }

    void setDspTask(DspTask task) {
        this.dspTask = task;
        this.dspUser = task.createDspUser();
        this.targetConnection = task.getTargetConnection();
        this.dspUser.onAllowedUserAccessesChanged().addISimpleEventListener(this.allowedToAccessCacheInvalidator);
    }

    @Override
    public boolean allowUserToModify(int breakpointType) {
        Boolean value = this.allowUserToModifyCache.get(new Integer(breakpointType));
        if (null == value) {
            value = new Boolean(this.wrappedBreakpointManager.allowUserToModify(breakpointType));
            this.allowUserToModifyCache.put(new Integer(breakpointType), value);
        }
        return value;
    }

    @Override
    public int getNumBreakpointTypes() {
        if (this.isNumBreakpointTypesCacheValid) {
            return this.numBreakpointTypesCache;
        }
        int numBreakpointTypes = this.wrappedBreakpointManager.getNumBreakpointTypes();
        if (null != this.dspUser && ITargetConnection.ConnectionStatus.CONNECTED == this.targetConnection.getConnectionStatus()) {
            this.numBreakpointTypesCache = numBreakpointTypes;
            this.isNumBreakpointTypesCacheValid = true;
        }
        return numBreakpointTypes;
    }

    @Override
    public boolean isHardware(int nType) {
        return this.wrappedBreakpointManager.isHardware(nType);
    }

    @Override
    public void forceSourceFileResolve() {
        this.wrappedBreakpointManager.forceSourceFileResolve();
    }

    @Override
    public boolean getSkipBreakpoints() {
        return this.wrappedBreakpointManager.getSkipBreakpoints();
    }

    @Override
    public void setSkipBreakpoints(boolean aSkipBreakpoints) throws IBreakpointManager.BreakpointExpectedException, IBreakpointManager.BreakpointException {
        this.checkForException(this.wrappedBreakpointManager.setSkipBreakpoints(aSkipBreakpoints));
    }

    @Override
    public boolean allowUserToSkipBreakpoints() {
        return this.wrappedBreakpointManager.allowUserToSkipBreakpoints();
    }
}

