/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IBreakpoint;
import com.ti.debug.engine.IBreakpointManager;
import com.ti.debug.engine.IBreakpointModifier;
import com.ti.debug.engine.IBreakpointProperties;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.impl.ObjectEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.impl.Breakpoint;
import com.ti.debug.engine.impl.BreakpointManager;
import com.ti.debug.engine.impl.BreakpointProperties;
import com.ti.debug.engine.xpcom.event.impl.BreakpointDataTranslator;
import com.ti.xpcom.interfaces.dsIBreakpointManagerEvents;

public class BreakpointModifier
extends BreakpointManager
implements IBreakpointModifier {
    private boolean isModifying = false;
    private final ISimpleEventListener onBeginBreakpointModifyListener = new ISimpleEventListener(){

        @Override
        public void onEvent() {
            BreakpointModifier.this.isModifying = true;
        }
    };
    private final IObjectEventListener<IEventData<IBreakpoint>> onBreakpointModifiedListener = new IObjectEventListener<IEventData<IBreakpoint>>(){

        @Override
        public void onEvent(IEventData<IBreakpoint> data) {
            BreakpointModifier.this.isModifying = false;
            BreakpointModifier.this.onBreakpointModified.fireEvent(data);
        }
    };
    private final ManagedSimpleEvent onBeginBreakpointModify;
    private final ObjectEvent<IEventData<IBreakpoint>> onBreakpointModified = new ObjectEvent();
    private final SuppressEvent onBreakpointEnabled;
    private final SuppressEvent onBreakpointDisabled;
    private final ManagedObjectEvent<IEventData<IBreakpoint>> onPrivateBreakpointModified;
    private final SuppressEvent onBreakpointAdded = new SuppressEvent(super.onBreakpointAdded(), new ObjectEvent<IEventData<IBreakpoint>>());
    private final SuppressEvent onBreakpointRemoved = new SuppressEvent(super.onBreakpointRemoved(), new ObjectEvent<IEventData<IBreakpoint>>());

    BreakpointModifier(BreakpointManager breakpointManager) {
        super(breakpointManager);
        this.onBreakpointEnabled = new SuppressEvent(super.onBreakpointEnabled(), this.onBreakpointModified);
        this.onBreakpointDisabled = new SuppressEvent(super.onBreakpointDisabled(), this.onBreakpointModified);
        this.onBeginBreakpointModify = new ManagedSimpleEvent(((dsIBreakpointManagerEvents)this.getWrappedObject()).onBeginBreakpointModify());
        this.onBeginBreakpointModify.addISimpleEventListener(this.onBeginBreakpointModifyListener);
        this.onPrivateBreakpointModified = new ManagedObjectEvent<IEventData<IBreakpoint>>(((dsIBreakpointManagerEvents)this.getWrappedObject()).onBreakpointModified(), new BreakpointDataTranslator());
        this.onPrivateBreakpointModified.addIObjectEventListener(this.onBreakpointModifiedListener);
    }

    @Override
    public void modify(IBreakpoint breakpoint, IBreakpointProperties properties) throws IBreakpointManager.BreakpointExpectedException, IBreakpointManager.BreakpointException {
        this.checkForException(this.wrappedBreakpointManager.modify(((Breakpoint)breakpoint).getWrappedBreakpoint(), ((BreakpointProperties)properties).getWrappedBreakpointProperties()));
    }

    @Override
    public void modify(IBreakpoint breakpoint, String serializationData) throws IBreakpointManager.BreakpointExpectedException, IBreakpointManager.BreakpointException {
        this.modify(breakpoint, this.createBreakpointFromString(serializationData).getProperties());
    }

    @Override
    public IObjectEvent<IEventData<IBreakpoint>> onModified() {
        return this.onBreakpointModified;
    }

    @Override
    public IObjectEvent<IEventData<IBreakpoint>> onBreakpointAdded() {
        return this.onBreakpointAdded.getSuppressedEvent();
    }

    @Override
    public IObjectEvent<IEventData<IBreakpoint>> onBreakpointRemoved() {
        return this.onBreakpointRemoved.getSuppressedEvent();
    }

    @Override
    public IObjectEvent<IEventData<IBreakpoint>> onBreakpointDisabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IObjectEvent<IEventData<IBreakpoint>> onBreakpointEnabled() {
        throw new UnsupportedOperationException();
    }

    private class SuppressEvent {
        private final ObjectEvent<IEventData<IBreakpoint>> suppressedEvent;
        private final IObjectEventListener<IEventData<IBreakpoint>> listener = new IObjectEventListener<IEventData<IBreakpoint>>(){

            @Override
            public void onEvent(IEventData<IBreakpoint> data) {
                if (!BreakpointModifier.this.isModifying) {
                    SuppressEvent.this.suppressedEvent.fireEvent(data);
                }
            }
        };

        SuppressEvent(IObjectEvent<IEventData<IBreakpoint>> unsuppressedEvent, ObjectEvent<IEventData<IBreakpoint>> suppressedEvent) {
            unsuppressedEvent.addIObjectEventListener(this.listener);
            this.suppressedEvent = suppressedEvent;
        }

        ObjectEvent<IEventData<IBreakpoint>> getSuppressedEvent() {
            return this.suppressedEvent;
        }
    }
}

