/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICallFrame;
import com.ti.debug.engine.ICallStack;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IFunctionInfo;
import com.ti.debug.engine.ILineInfo;

public class CallFrame
implements ICallFrame {
    private ICallStack parent;
    private IFunctionInfo funcInfo;
    private IDspValue fp;
    private IDspValue pc;
    private int level;
    private ICallFrame.Type type;

    public CallFrame(ICallStack parent, IFunctionInfo funcInfo, IDspValue fp, IDspValue pc, int level, ICallFrame.Type type) {
        this.parent = parent;
        this.funcInfo = funcInfo;
        this.fp = fp;
        this.pc = pc;
        this.level = level;
        this.type = type;
    }

    @Override
    public ICallStack getParent() {
        return this.parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public ICallFrame.Type getType() {
        return this.type;
    }

    @Override
    public IFunctionInfo getFunctionInfo() {
        return this.funcInfo;
    }

    @Override
    public IDspValue getFP() {
        return this.fp;
    }

    @Override
    public IDspValue getPC() {
        return this.pc;
    }

    private String getSymbolString() {
        if (0 != this.funcInfo.getName().length()) {
            int[] index = new int[]{0};
            ILineInfo lineInfo = this.funcInfo.getStaticLineInfo();
            lineInfo.lookupLineByAddress(this.pc.toUnsignedInt(), index);
            return this.funcInfo + " at " + this.funcInfo.getFileFullName() + ":" + lineInfo.getLineNum(index[0]);
        }
        return "<symbol is not available>";
    }

    @Override
    public String toString() {
        return this.level + " " + this.getSymbolString() + " PC = " + this.pc + " FP = " + this.fp;
    }
}

