/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICallFrame;
import com.ti.debug.engine.ICallStack;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.types.INumberEvent;
import com.ti.debug.engine.events.types.INumberEventCallback;
import com.ti.debug.engine.events.types.INumberEventListener;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.CallFrame;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.FunctionInfo;
import com.ti.xpcom.interfaces.dsICallStack;
import com.ti.xpcom.interfaces.dsIFunctionInfo;
import com.ti.xpcom.interfaces.dsITargetData;

public class CallStack
extends AComparableDisposable<dsICallStack>
implements ICallStack {
    private ManagedSimpleEvent managedOnCallStackChanged;
    private ManagedSimpleEvent managedOnCallStackInvalidated;
    static final INumberEvent deprecatedEvent = new INumberEvent(){

        @Override
        public void addListener(INumberEventCallback l) {
        }

        @Override
        public void removeListener(INumberEventCallback l) {
        }

        @Override
        public void addINumberEventListener(INumberEventListener listener) {
        }

        @Override
        public void removeINumberEventListener(INumberEventListener listener) {
        }
    };

    public CallStack(dsICallStack callStack) {
        super(callStack);
        this.managedOnCallStackChanged = new ManagedSimpleEvent(((dsICallStack)this.wrappedObject).onCallStackChanged());
        this.managedOnCallStackInvalidated = new ManagedSimpleEvent(((dsICallStack)this.wrappedObject).onCallStackInvalidated());
    }

    @Override
    public int getNumFrames() {
        return ((dsICallStack)this.wrappedObject).getNumFrames();
    }

    private ICallStack.FrameInfo.Type ToFrameInfoType(long lFrameType) {
        ICallStack.FrameInfo.Type eType = ICallStack.FrameInfo.Type.Cpu;
        if (1L == lFrameType) {
            eType = ICallStack.FrameInfo.Type.Kernel;
        } else if (2L == lFrameType) {
            eType = ICallStack.FrameInfo.Type.User;
        }
        return eType;
    }

    @Override
    public ICallStack.FrameInfo getFrameInfo(int frame) {
        dsIFunctionInfo[] ppFunctionInfo = new dsIFunctionInfo[]{null};
        dsITargetData[] ppFP = new dsITargetData[]{null};
        dsITargetData[] ppPC = new dsITargetData[]{null};
        long lFrameType = ((dsICallStack)this.wrappedObject).getFrameInfo(frame, ppFunctionInfo, ppFP, ppPC);
        return new ICallStack.FrameInfo(new FunctionInfo(ppFunctionInfo[0]), new DspValue(ppFP[0]), new DspValue(ppPC[0]), frame, this.ToFrameInfoType(lFrameType));
    }

    @Override
    public ISimpleEvent onCallStackChanged() {
        return this.managedOnCallStackChanged;
    }

    @Override
    public ISimpleEvent onCallStackInvalidated() {
        return this.managedOnCallStackInvalidated;
    }

    @Override
    public INumberEvent onCallStackFrameChanged() {
        return deprecatedEvent;
    }

    @Override
    public boolean isConstructed() {
        return ((dsICallStack)this.wrappedObject).isCallstackConstructed();
    }

    public String toString() {
        String string = new String();
        if (this.isConstructed()) {
            int numFrames = this.getNumFrames();
            for (int frame = 0; frame < numFrames; ++frame) {
                string = string + this.getFrameInfo(frame) + "\n";
            }
            string = string + "Unwind halted because " + this.reasonUnwindHalted();
        } else {
            string = "Call stack is not constructed";
        }
        return string;
    }

    private ICallFrame.Type ToCallFrameType(long lFrameType) {
        ICallFrame.Type eType = ICallFrame.Type.Cpu;
        if (1L == lFrameType) {
            eType = ICallFrame.Type.Kernel;
        } else if (2L == lFrameType) {
            eType = ICallFrame.Type.User;
        }
        return eType;
    }

    @Override
    public ICallFrame getFrame(int level) {
        dsIFunctionInfo[] ppFunctionInfo = new dsIFunctionInfo[]{null};
        dsITargetData[] ppFP = new dsITargetData[]{null};
        dsITargetData[] ppPC = new dsITargetData[]{null};
        long lFrameType = ((dsICallStack)this.wrappedObject).getFrameInfo(level, ppFunctionInfo, ppFP, ppPC);
        return new CallFrame(this, new FunctionInfo(ppFunctionInfo[0]), new DspValue(ppFP[0]), new DspValue(ppPC[0]), level, this.ToCallFrameType(lFrameType));
    }

    @Override
    public String reasonUnwindHalted() {
        return ((dsICallStack)this.wrappedObject).reasonUnwindHalted();
    }

    public dsICallStack getWrappedTargetData() {
        return (dsICallStack)this.wrappedObject;
    }
}

