/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDisAsmAlignResult;
import com.ti.debug.engine.IDisAsmManager;
import com.ti.debug.engine.IDisAsmPatchResult;
import com.ti.debug.engine.IDisAsmRequest;
import com.ti.debug.engine.IDisAsmResult;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.Cancelable;
import com.ti.debug.engine.impl.DisAsmRequest;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectEventListenerOneTimeFilter;
import com.ti.debug.engine.xpcom.event.impl.AEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.DisAsmAlignResultTranslator;
import com.ti.debug.engine.xpcom.event.impl.DisAsmPatchResultTranslator;
import com.ti.debug.engine.xpcom.event.impl.DisAsmRequestTranslator;
import com.ti.debug.engine.xpcom.event.impl.DisAsmResultTranslator;
import com.ti.xpcom.interfaces.dsIDisAsmManager;
import com.ti.xpcom.interfaces.dsIDisAsmRequest;
import com.ti.xpcom.interfaces.dsIObjectEventCallback;
import com.ti.xpcom.interfaces.nsISupports;

public class DisAsmManager
extends AComparableDisposable<dsIDisAsmManager>
implements IDisAsmManager {
    private ManagedObjectEvent<IDisAsmRequest> managedOnComplete;

    public DisAsmManager(dsIDisAsmManager manager) {
        super(manager);
        this.managedOnComplete = new ManagedObjectEvent<IDisAsmRequest>(((dsIDisAsmManager)this.wrappedObject).onRequestCompleted(), new DisAsmRequestTranslator());
    }

    @Override
    public IDisAsmRequest createRangeRequest(long startAddress, long endAddress) {
        return new DisAsmRequest(((dsIDisAsmManager)this.wrappedObject).createRangeRequest(startAddress, endAddress));
    }

    @Override
    public IDisAsmRequest createScrollDownRequest(long startAddress, int numberOfLines) {
        return new DisAsmRequest(((dsIDisAsmManager)this.wrappedObject).createScrollDownRequest(startAddress, numberOfLines));
    }

    @Override
    public IDisAsmRequest createScrollUpRequest(long endAddress, int numberOfLines, boolean bExact) {
        return new DisAsmRequest(((dsIDisAsmManager)this.wrappedObject).createScrollUpRequest(endAddress, numberOfLines, bExact));
    }

    @Override
    public IDisAsmRequest createScrollUpRequest(long endAddress, int numberOfLines) {
        return new DisAsmRequest(((dsIDisAsmManager)this.wrappedObject).createScrollUpRequest(endAddress, numberOfLines, false));
    }

    @Override
    public void addRequest(IDisAsmRequest req) {
        ((dsIDisAsmManager)this.wrappedObject).addRequest((dsIDisAsmRequest)((DisAsmRequest)req).getWrappedObject());
    }

    @Override
    public ICancelable addRequest(final IDisAsmRequest req, IObjectEventListener<IDisAsmRequest> callback) {
        ObjectEventListenerOneTimeFilter<IDisAsmRequest> listenerFilter = new ObjectEventListenerOneTimeFilter<IDisAsmRequest>(callback, this.onRequestCompleted(), new IFilterStrategy<IDisAsmRequest>(){

            @Override
            public boolean filter(IDisAsmRequest data) {
                return !data.equals(req);
            }
        });
        try {
            Cancelable cancelable = new Cancelable(((dsIDisAsmManager)this.wrappedObject).addRequest((dsIDisAsmRequest)((DisAsmRequest)req).getWrappedObject()));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }

    @Override
    public ICancelable disassemble(long startAddress, long endAddress, boolean bNeedSourceLineInfo, IObjectEventListener<IDisAsmResult> callback) {
        return new Cancelable(((dsIDisAsmManager)this.wrappedObject).disassemble(startAddress, endAddress, bNeedSourceLineInfo, new AdaptCallback<IDisAsmResult>(callback, new DisAsmResultTranslator())));
    }

    @Override
    public ICancelable alignAddress(long address, IObjectEventListener<IDisAsmAlignResult> callback) {
        return new Cancelable(((dsIDisAsmManager)this.wrappedObject).alignAddress(address, new AdaptCallback<IDisAsmAlignResult>(callback, new DisAsmAlignResultTranslator())));
    }

    @Override
    public ICancelable patchAsm(long address, String instruction, IObjectEventListener<IDisAsmPatchResult> callback) {
        return new Cancelable(((dsIDisAsmManager)this.wrappedObject).patchAsm(address, instruction, new AdaptCallback<IDisAsmPatchResult>(callback, new DisAsmPatchResultTranslator())));
    }

    @Override
    public boolean doesTargetSupportPatchAsm() {
        return ((dsIDisAsmManager)this.wrappedObject).getPatchAsmCapable();
    }

    @Override
    public long getMinOpcodeSize() {
        return ((dsIDisAsmManager)this.wrappedObject).getMinOpcodeSize();
    }

    @Override
    public long getMaxDistanceFromLabel() {
        return ((dsIDisAsmManager)this.wrappedObject).getMaxDistanceFromLabel();
    }

    @Override
    public void setMaxDistanceFromLabel(long aMaxDistanceFromLabel) {
        ((dsIDisAsmManager)this.wrappedObject).setMaxDistanceFromLabel(aMaxDistanceFromLabel);
    }

    @Override
    public boolean isAddressAtPC(long address) {
        return ((dsIDisAsmManager)this.wrappedObject).isAddressAtPC(address);
    }

    @Override
    public IObjectEvent<IDisAsmRequest> onRequestCompleted() {
        return this.managedOnComplete;
    }

    private static class AdaptCallback<DataType>
    implements dsIObjectEventCallback {
        private IObjectEventListener<DataType> callback;
        private final AEventDataTranslator<DataType> translator;

        AdaptCallback(IObjectEventListener<DataType> callback, AEventDataTranslator<DataType> translator) {
            this.callback = callback;
            this.translator = translator;
        }

        @Override
        public void onEvent(nsISupports data) {
            this.callback.onEvent(this.translator.translate(data));
            this.callback = null;
        }

        @Override
        public nsISupports queryInterface(String iid) {
            if (iid.equals("{fc313e57-e763-4dba-8b46-01e9e239322e}") || iid.equals("{00000000-0000-0000-c000-000000000046}")) {
                return this;
            }
            return null;
        }
    }
}

