/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IBreakpoint;
import com.ti.debug.engine.IBreakpointLocation;
import com.ti.debug.engine.IBreakpointManager;
import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDisAsmManager;
import com.ti.debug.engine.IDisAssemble;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IGelFiles;
import com.ti.debug.engine.IOnChipAnalysis;
import com.ti.debug.engine.IPinConnect;
import com.ti.debug.engine.IPipeLine;
import com.ti.debug.engine.IPortConnect;
import com.ti.debug.engine.IProcessorInfo;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.IRegisterServer;
import com.ti.debug.engine.IRouterSystemFeature;
import com.ti.debug.engine.ISymbolManager;
import com.ti.debug.engine.ITransaction;
import com.ti.debug.engine.dialogs.IStdInDialog;
import com.ti.debug.engine.events.data.IControlPointEventData;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.data.IFileLoadedEventData;
import com.ti.debug.engine.events.data.IGelTextOutData;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.data.IPriorityFileLoadedEventData;
import com.ti.debug.engine.events.data.IRefreshEventData;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.events.data.ITargetPropertyData;
import com.ti.debug.engine.events.impl.BooleanEvent;
import com.ti.debug.engine.events.impl.ManagedBooleanEvent;
import com.ti.debug.engine.events.impl.ManagedNumberEvent;
import com.ti.debug.engine.events.impl.ManagedNumberToObjectEvent;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.impl.ManagedPriorityObjectEvent;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.impl.ManagedStringEvent;
import com.ti.debug.engine.events.impl.ManagedTargetIOEventToStringEvent;
import com.ti.debug.engine.events.tcl.IDspUserEvents;
import com.ti.debug.engine.events.types.IBooleanEvent;
import com.ti.debug.engine.events.types.IBooleanEventListener;
import com.ti.debug.engine.events.types.INumberEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.events.types.IStringEvent;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.framework.ICloneableWrapper;
import com.ti.debug.engine.impl.DspMemory;
import com.ti.debug.engine.impl.DspRegister;
import com.ti.debug.engine.impl.DspTask;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.EmptyTransaction;
import com.ti.debug.engine.impl.FunctionResultCache;
import com.ti.debug.engine.impl.LegacyOnRefreshFilter;
import com.ti.debug.engine.impl.ObjectToSimpleEventAdapter;
import com.ti.debug.engine.impl.RefreshTransaction;
import com.ti.debug.engine.impl.RegisteredView;
import com.ti.debug.engine.impl.RouterSystemFeature;
import com.ti.debug.engine.xpcom.event.impl.ControlPointControlEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.ExpressionEvaluationDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.FileLoadedEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.GELTextOutDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.HaltEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.MemoryAccessEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.PriorityFileLoadedEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.RefreshEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.RegisterAccessEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.StdInEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.TargetPropertyDataTranslator;
import com.ti.xpcom.interfaces.dsIControlPointControl;
import com.ti.xpcom.interfaces.dsIDspUser;
import com.ti.xpcom.interfaces.dsIDspUserBreakpoints;
import com.ti.xpcom.interfaces.dsIErrorOutput;
import com.ti.xpcom.interfaces.dsIExpressionEvaluation;
import com.ti.xpcom.interfaces.dsIGELTextOutEvent;
import com.ti.xpcom.interfaces.dsIGelFileListEvents;
import com.ti.xpcom.interfaces.dsIMemory;
import com.ti.xpcom.interfaces.dsIMemoryAccess;
import com.ti.xpcom.interfaces.dsIMemoryMap;
import com.ti.xpcom.interfaces.dsIProgramLoaderEvents;
import com.ti.xpcom.interfaces.dsIRefreshControl;
import com.ti.xpcom.interfaces.dsIRefreshEvents;
import com.ti.xpcom.interfaces.dsIRegister;
import com.ti.xpcom.interfaces.dsIRegisterAccess;
import com.ti.xpcom.interfaces.dsIResetControlEvents;
import com.ti.xpcom.interfaces.dsIRouterSystemFeatures;
import com.ti.xpcom.interfaces.dsIRunControl;
import com.ti.xpcom.interfaces.dsIRunControlEvents;
import com.ti.xpcom.interfaces.dsISourceStepping;
import com.ti.xpcom.interfaces.dsISymbolManagerEvents;
import com.ti.xpcom.interfaces.dsITargetData;
import com.ti.xpcom.interfaces.dsITargetIO;
import com.ti.xpcom.interfaces.dsITargetProperties;
import java.util.HashMap;
import java.util.Map;

public class DspUser
extends AComparableDisposable<dsIDspUser>
implements IDspUser,
ICloneableWrapper,
IDspUserEvents {
    private dsIDspUserBreakpoints wrappedDspUserBreakpoints;
    dsIExpressionEvaluation wrappedExpressionEvaluation;
    dsIMemoryAccess wrappedMemoryAccess;
    private dsIMemoryMap wrappedMemoryMap;
    dsIRegisterAccess wrappedRegisterAccess;
    dsIRunControl wrappedRunControl;
    private dsISourceStepping wrappedSourceStepping;
    private dsISymbolManagerEvents wrappedSymbolManagerEvents;
    private dsIResetControlEvents wrappedResetControlEvents;
    private dsITargetIO wrappedTargetIO;
    private dsIProgramLoaderEvents wrappedProgramLoaderEvents;
    private dsIRunControlEvents wrappedRunControlEvents;
    private dsIGELTextOutEvent wrappedGELTextOutEvent;
    private dsIErrorOutput wrappedErrorOutput;
    private dsIRefreshControl wrappedRefreshControl;
    private dsIRefreshEvents wrappedRefreshEvents;
    private dsITargetProperties wrappedTargetProperties;
    private dsIRouterSystemFeatures wrappedRouterSystemFeatures;
    private dsIControlPointControl wrappedControlPointControl;
    private dsIGelFileListEvents wrappedGelFileListEvents;
    private final DspTask parentTask;
    private final IBreakpointManager breakpointManager;
    private final IRegisterServer registerServer;
    private ManagedObjectEvent<IEventData<IDspValue>> managedOnHalt;
    private ManagedSimpleEvent managedOnRunning;
    private ManagedNumberEvent managedOnTargetHaltDetected;
    private ManagedNumberEvent managedOnRestart;
    private ManagedSimpleEvent managedOnAlreadyRunning;
    private ManagedSimpleEvent managedOnPowerStatusChanged;
    private ManagedSimpleEvent managedOnSecureStatusChanged;
    private ManagedSimpleEvent managedOnExecutionStatusChanged;
    private ManagedSimpleEvent managedOnEmulatorReset;
    private ManagedSimpleEvent managedOnHaltOnResetChanged;
    private ManagedSimpleEvent managedOnHeldInReset;
    private ManagedNumberEvent managedOnReset;
    private ManagedSimpleEvent managedOnStartFileLoad;
    private ManagedPriorityObjectEvent<IPriorityFileLoadedEventData> managedOnPriorityFileLoaded;
    private ManagedObjectEvent<IFileLoadedEventData> managedOnFileLoaded;
    private ManagedObjectEvent<IExpressionEvaluationData> managedOnCExprEvaluated;
    private ManagedBooleanEvent managedOnNewSymbols;
    private ManagedSimpleEvent managedOnNewSymbolsOffline;
    private ManagedBooleanEvent managedOnExtMemoryChanged;
    private ManagedSimpleEvent managedOnMemoryMapUpdate;
    private ManagedObjectEvent<IMemoryAccessEventData> managedOnMemoryRequestComplete;
    private ManagedObjectEvent<IMemoryAccessEventData> managedOnMemoryUpdate;
    private ManagedObjectEvent<IRegisterAccessEventData> managedOnRegisterRequestComplete;
    private ManagedObjectEvent<IRegisterAccessEventData> managedOnRegisterUpdate;
    private ManagedTargetIOEventToStringEvent managedOnStdOut;
    private ManagedTargetIOEventToStringEvent managedOnStdErr;
    private ManagedObjectEvent<IStdInDialog> managedOnStdIn;
    private ManagedObjectEvent<IGelTextOutData> managedOnGELTextOut;
    private ManagedSimpleEvent managedOnContinuousRefreshUpdate;
    private ManagedSimpleEvent managedOnRealtimeModeSwitch;
    private ManagedStringEvent managedOnFatal;
    private ManagedStringEvent managedOnError;
    private ManagedStringEvent managedOnWarning;
    private ManagedStringEvent managedOnInfo;
    private ManagedObjectEvent<ITargetPropertyData> managedOnPropertyGet;
    private ManagedObjectEvent<ITargetPropertyData> managedOnPropertySet;
    private ManagedSimpleEvent managedOnAllowedUserAccessesChanged;
    private final ManagedNumberToObjectEvent<IRefreshEventData> managedOnRefresh;
    private ManagedObjectEvent<IControlPointEventData> managedOnControlPointHit;
    private ManagedSimpleEvent managedOnGelFileListChanged;
    private final ISimpleEvent legacyOnRefresh;
    private final IProcessorInfo processorInfo;
    private final AddressSizeCache addressSizeCache;
    private volatile Boolean capableFreeRunCache = null;
    private final SteppingAllowedCache getSrcStepIntoAllowedCache;
    private final SteppingAllowedCache getSrcStepOverAllowedCache;
    private final SteppingAllowedCache getStepOutAllowedCache;
    private final SteppingAllowedCache getAsmStepIntoAllowedCache;
    private final SteppingAllowedCache getAsmStepOverAllowedCache;
    private static final Map<IDspUser.AccessType, Integer> accessTypeMap = new HashMap<IDspUser.AccessType, Integer>(){
        private static final long serialVersionUID = 515638815425955486L;
        {
            this.put(IDspUser.AccessType.ACCESS_TYPE_MEMORY_READ, 0);
            this.put(IDspUser.AccessType.ACCESS_TYPE_MEMORY_WRITE, 1);
            this.put(IDspUser.AccessType.ACCESS_TYPE_REGISTER_READ, 2);
            this.put(IDspUser.AccessType.ACCESS_TYPE_REGISTER_WRITE, 3);
            this.put(IDspUser.AccessType.ACCESS_TYPE_EXPRESSION_EVALUATION, 4);
            this.put(IDspUser.AccessType.ACCESS_TYPE_LOCAL_LOOKUP, 5);
        }
    };
    private final IBooleanEvent onRemoveDebugState = new BooleanEvent(){
        private final ISimpleEventListener listener = new ISimpleEventListener(){

            @Override
            public void onEvent() {
                this.fireEvent(true);
            }
        };

        @Override
        protected void registerForEvents() {
            DspUser.this.parentTask.getTargetConnection().onRemoveDebugState().addISimpleEventListener(this.listener);
        }

        @Override
        protected void unregisterForEvents() {
            DspUser.this.parentTask.getTargetConnection().onRemoveDebugState().removeISimpleEventListener(this.listener);
        }
    };

    DspUser(DspTask parentTask, dsIDspUser user, IProcessorInfo processorInfo, IBreakpointManager breakpointManager, IRegisterServer regServer) {
        super(user);
        this.processorInfo = processorInfo;
        this.parentTask = parentTask;
        this.breakpointManager = breakpointManager;
        this.registerServer = regServer;
        this.wrappedDspUserBreakpoints = (dsIDspUserBreakpoints)((dsIDspUser)this.wrappedObject).queryInterface("{4147907a-b389-4573-82c5-d25538223096}");
        this.wrappedExpressionEvaluation = (dsIExpressionEvaluation)((dsIDspUser)this.wrappedObject).queryInterface("{10cb8763-aa29-4f76-8857-e4e0b0a0e6b4}");
        this.wrappedMemoryAccess = (dsIMemoryAccess)((dsIDspUser)this.wrappedObject).queryInterface("{7718907f-55c7-4d2d-9f62-54e2ed7de981}");
        this.wrappedMemoryMap = (dsIMemoryMap)((dsIDspUser)this.wrappedObject).queryInterface("{4124a40c-c9d7-4995-90a6-69833cc59a1b}");
        this.wrappedRegisterAccess = (dsIRegisterAccess)((dsIDspUser)this.wrappedObject).queryInterface("{68a39ea0-f352-47c7-8f45-7a1b40f577ac}");
        this.wrappedRunControl = (dsIRunControl)((dsIDspUser)this.wrappedObject).queryInterface("{b27440c3-1bdf-4c28-a87e-b5f06cdc92a9}");
        this.wrappedSourceStepping = (dsISourceStepping)((dsIDspUser)this.wrappedObject).queryInterface("{295a15d8-0bbd-4ee9-b88f-9801e226539c}");
        this.wrappedSymbolManagerEvents = (dsISymbolManagerEvents)((dsIDspUser)this.wrappedObject).queryInterface("{679ef005-e753-443d-84cb-4e7a505d426a}");
        this.wrappedResetControlEvents = (dsIResetControlEvents)((dsIDspUser)this.wrappedObject).queryInterface("{54025e78-824b-4660-b73a-1e7f8a52ff63}");
        this.wrappedTargetIO = (dsITargetIO)((dsIDspUser)this.wrappedObject).queryInterface("{2af14381-307d-4031-88f8-e77f02919b02}");
        this.wrappedProgramLoaderEvents = (dsIProgramLoaderEvents)((dsIDspUser)this.wrappedObject).queryInterface("{b1659323-f11c-4754-aeca-dab761503243}");
        this.wrappedRunControlEvents = (dsIRunControlEvents)((dsIDspUser)this.wrappedObject).queryInterface("{5bf1055f-ca1e-4b70-8900-2e6fcf4d52c5}");
        this.wrappedGELTextOutEvent = (dsIGELTextOutEvent)((dsIDspUser)this.wrappedObject).queryInterface("{03ec404a-bd66-4c78-9c98-22fd4468e1b1}");
        this.wrappedErrorOutput = (dsIErrorOutput)((dsIDspUser)this.wrappedObject).queryInterface("{438eddab-53f6-4bb1-9bad-70907641e733}");
        this.wrappedRefreshControl = (dsIRefreshControl)((dsIDspUser)this.wrappedObject).queryInterface("{59bc7eec-3db4-42a5-a5bd-6a1b8d48b043}");
        this.wrappedRefreshEvents = (dsIRefreshEvents)((dsIDspUser)this.wrappedObject).queryInterface("{be8fa9cf-e761-45f4-922c-583952adc2b1}");
        this.wrappedControlPointControl = (dsIControlPointControl)((dsIDspUser)this.wrappedObject).queryInterface("{819d574c-b352-4e3c-874a-b49cdc0f40c9}");
        this.wrappedTargetProperties = (dsITargetProperties)((dsIDspUser)this.wrappedObject).queryInterface("{2d6d19ad-cfcf-42ce-8cd5-9121b802edf2}");
        this.wrappedRouterSystemFeatures = (dsIRouterSystemFeatures)((dsIDspUser)this.wrappedObject).queryInterface("{56d15aae-6e7f-418a-a68b-a5c83cae4b27}");
        this.wrappedGelFileListEvents = (dsIGelFileListEvents)((dsIDspUser)this.wrappedObject).queryInterface("{0142fa53-887a-4d9e-b1ae-ed1f1aa81a50}");
        this.managedOnHalt = new ManagedObjectEvent<IEventData<IDspValue>>(this.wrappedRunControlEvents.onHalt(), new HaltEventDataTranslator());
        this.managedOnRunning = new ManagedSimpleEvent(this.wrappedRunControlEvents.onRunning());
        this.managedOnTargetHaltDetected = new ManagedNumberEvent(this.wrappedRunControlEvents.onTargetHaltDetected());
        this.managedOnRestart = new ManagedNumberEvent(this.wrappedRunControlEvents.onRestart());
        this.managedOnAlreadyRunning = new ManagedSimpleEvent(this.wrappedRunControlEvents.onAlreadyRunning());
        this.managedOnPowerStatusChanged = new ManagedSimpleEvent(this.wrappedRunControlEvents.onPowerStatusChanged());
        this.managedOnSecureStatusChanged = new ManagedSimpleEvent(this.wrappedRunControlEvents.onSecureStatusChanged());
        this.managedOnExecutionStatusChanged = new ManagedSimpleEvent(this.wrappedRunControlEvents.onExecutionStatusChanged());
        this.managedOnEmulatorReset = new ManagedSimpleEvent(this.wrappedResetControlEvents.onEmulatorReset());
        this.managedOnHaltOnResetChanged = new ManagedSimpleEvent(this.wrappedResetControlEvents.onHaltOnResetChanged());
        this.managedOnHeldInReset = new ManagedSimpleEvent(this.wrappedResetControlEvents.onHeldInReset());
        this.managedOnReset = new ManagedNumberEvent(this.wrappedResetControlEvents.onReset());
        this.managedOnStartFileLoad = new ManagedSimpleEvent(this.wrappedProgramLoaderEvents.onStartFileLoad());
        this.managedOnPriorityFileLoaded = new ManagedPriorityObjectEvent<IPriorityFileLoadedEventData>(this.wrappedProgramLoaderEvents.onPriorityFileLoaded(), new PriorityFileLoadedEventDataTranslator());
        this.managedOnFileLoaded = new ManagedObjectEvent<IFileLoadedEventData>(this.wrappedProgramLoaderEvents.onFileLoaded(), new FileLoadedEventDataTranslator());
        this.managedOnCExprEvaluated = new ManagedObjectEvent<IExpressionEvaluationData>(this.wrappedExpressionEvaluation.onCExprEvaluated(), new ExpressionEvaluationDataTranslator());
        this.managedOnNewSymbols = new ManagedBooleanEvent(this.wrappedSymbolManagerEvents.onNewSymbols());
        this.managedOnNewSymbolsOffline = new ManagedSimpleEvent(this.wrappedSymbolManagerEvents.onNewSymbolsOffline());
        this.managedOnExtMemoryChanged = new ManagedBooleanEvent(this.wrappedMemoryAccess.onExtMemoryChanged());
        this.managedOnMemoryMapUpdate = new ManagedSimpleEvent(this.wrappedMemoryMap.onMemoryMapUpdate());
        this.managedOnMemoryRequestComplete = new ManagedObjectEvent<IMemoryAccessEventData>(this.wrappedMemoryAccess.onMemoryRequestComplete(), new MemoryAccessEventDataTranslator());
        this.managedOnMemoryUpdate = new ManagedObjectEvent<IMemoryAccessEventData>(this.wrappedMemoryAccess.onMemoryUpdate(), new MemoryAccessEventDataTranslator());
        this.managedOnRegisterRequestComplete = new ManagedObjectEvent<IRegisterAccessEventData>(this.wrappedRegisterAccess.onRegisterRequestComplete(), new RegisterAccessEventDataTranslator());
        this.managedOnRegisterUpdate = new ManagedObjectEvent<IRegisterAccessEventData>(this.wrappedRegisterAccess.onRegisterUpdate(), new RegisterAccessEventDataTranslator());
        this.managedOnStdErr = new ManagedTargetIOEventToStringEvent(this.wrappedTargetIO.onStdErr());
        this.managedOnStdOut = new ManagedTargetIOEventToStringEvent(this.wrappedTargetIO.onStdOut());
        this.managedOnStdIn = new ManagedObjectEvent<IStdInDialog>(this.wrappedTargetIO.onStdIn(), new StdInEventDataTranslator());
        this.managedOnGELTextOut = new ManagedObjectEvent<IGelTextOutData>(this.wrappedGELTextOutEvent.onGELTextOut(), new GELTextOutDataTranslator());
        this.managedOnFatal = new ManagedStringEvent(this.wrappedErrorOutput.onFatal());
        this.managedOnError = new ManagedStringEvent(this.wrappedErrorOutput.onError());
        this.managedOnWarning = new ManagedStringEvent(this.wrappedErrorOutput.onWarning());
        this.managedOnInfo = new ManagedStringEvent(this.wrappedErrorOutput.onInfo());
        this.managedOnAllowedUserAccessesChanged = new ManagedSimpleEvent(this.wrappedRefreshControl.onAllowedUserAccessesChanged());
        this.managedOnRefresh = new ManagedNumberToObjectEvent<IRefreshEventData>(this.wrappedRefreshEvents.onRefresh(), new RefreshEventDataTranslator());
        this.legacyOnRefresh = new ObjectToSimpleEventAdapter<IRefreshEventData>(this.managedOnRefresh, new LegacyOnRefreshFilter());
        this.managedOnPropertyGet = new ManagedObjectEvent<ITargetPropertyData>(this.wrappedTargetProperties.onPropertyGet(), new TargetPropertyDataTranslator());
        this.managedOnPropertySet = new ManagedObjectEvent<ITargetPropertyData>(this.wrappedTargetProperties.onPropertySet(), new TargetPropertyDataTranslator());
        this.managedOnControlPointHit = new ManagedObjectEvent<IControlPointEventData>(this.wrappedControlPointControl.onControlPointHit(), new ControlPointControlEventDataTranslator());
        this.managedOnGelFileListChanged = new ManagedSimpleEvent(this.wrappedGelFileListEvents.onGelFileListChanged());
        this.addressSizeCache = new AddressSizeCache();
        this.getSrcStepIntoAllowedCache = new SteppingAllowedCache(){

            @Override
            protected Boolean fetchUncachedValue() {
                return DspUser.this.wrappedSourceStepping.getStepIntoAllowed();
            }
        };
        this.getSrcStepOverAllowedCache = new SteppingAllowedCache(){

            @Override
            protected Boolean fetchUncachedValue() {
                return DspUser.this.wrappedSourceStepping.getStepOverAllowed();
            }
        };
        this.getStepOutAllowedCache = new SteppingAllowedCache(){

            @Override
            protected Boolean fetchUncachedValue() {
                return DspUser.this.wrappedSourceStepping.getStepOutAllowed();
            }
        };
        this.getAsmStepIntoAllowedCache = new SteppingAllowedCache(){

            @Override
            protected Boolean fetchUncachedValue() {
                return DspUser.this.wrappedSourceStepping.getAsmStepIntoAllowed();
            }
        };
        this.getAsmStepOverAllowedCache = new SteppingAllowedCache(){

            @Override
            protected Boolean fetchUncachedValue() {
                return DspUser.this.wrappedSourceStepping.getAsmStepOverAllowed();
            }
        };
    }

    DspUser(DspUser toCopy) {
        super(toCopy);
        this.processorInfo = toCopy.processorInfo;
        this.parentTask = toCopy.parentTask;
        this.wrappedObject = toCopy.wrappedObject;
        this.breakpointManager = toCopy.breakpointManager;
        this.registerServer = toCopy.registerServer;
        this.wrappedDspUserBreakpoints = toCopy.wrappedDspUserBreakpoints;
        this.wrappedExpressionEvaluation = toCopy.wrappedExpressionEvaluation;
        this.wrappedMemoryAccess = toCopy.wrappedMemoryAccess;
        this.wrappedMemoryMap = toCopy.wrappedMemoryMap;
        this.wrappedRegisterAccess = toCopy.wrappedRegisterAccess;
        this.wrappedRunControl = toCopy.wrappedRunControl;
        this.wrappedSourceStepping = toCopy.wrappedSourceStepping;
        this.wrappedSymbolManagerEvents = toCopy.wrappedSymbolManagerEvents;
        this.wrappedResetControlEvents = toCopy.wrappedResetControlEvents;
        this.wrappedTargetIO = toCopy.wrappedTargetIO;
        this.wrappedProgramLoaderEvents = toCopy.wrappedProgramLoaderEvents;
        this.wrappedRunControlEvents = toCopy.wrappedRunControlEvents;
        this.wrappedGELTextOutEvent = toCopy.wrappedGELTextOutEvent;
        this.wrappedErrorOutput = toCopy.wrappedErrorOutput;
        this.wrappedRefreshControl = toCopy.wrappedRefreshControl;
        this.wrappedRefreshEvents = toCopy.wrappedRefreshEvents;
        this.wrappedControlPointControl = toCopy.wrappedControlPointControl;
        this.wrappedTargetProperties = toCopy.wrappedTargetProperties;
        this.wrappedRouterSystemFeatures = toCopy.wrappedRouterSystemFeatures;
        this.wrappedGelFileListEvents = toCopy.wrappedGelFileListEvents;
        this.managedOnHalt = toCopy.managedOnHalt;
        this.managedOnRunning = toCopy.managedOnRunning;
        this.managedOnTargetHaltDetected = toCopy.managedOnTargetHaltDetected;
        this.managedOnRestart = toCopy.managedOnRestart;
        this.managedOnAlreadyRunning = toCopy.managedOnAlreadyRunning;
        this.managedOnPowerStatusChanged = toCopy.managedOnPowerStatusChanged;
        this.managedOnSecureStatusChanged = toCopy.managedOnSecureStatusChanged;
        this.managedOnExecutionStatusChanged = toCopy.managedOnExecutionStatusChanged;
        this.managedOnEmulatorReset = toCopy.managedOnEmulatorReset;
        this.managedOnHaltOnResetChanged = toCopy.managedOnHaltOnResetChanged;
        this.managedOnHeldInReset = toCopy.managedOnHeldInReset;
        this.managedOnReset = toCopy.managedOnReset;
        this.managedOnStartFileLoad = toCopy.managedOnStartFileLoad;
        this.managedOnPriorityFileLoaded = toCopy.managedOnPriorityFileLoaded;
        this.managedOnFileLoaded = toCopy.managedOnFileLoaded;
        this.managedOnCExprEvaluated = toCopy.managedOnCExprEvaluated;
        this.managedOnNewSymbols = toCopy.managedOnNewSymbols;
        this.managedOnNewSymbolsOffline = toCopy.managedOnNewSymbolsOffline;
        this.managedOnExtMemoryChanged = toCopy.managedOnExtMemoryChanged;
        this.managedOnMemoryMapUpdate = toCopy.managedOnMemoryMapUpdate;
        this.managedOnMemoryRequestComplete = toCopy.managedOnMemoryRequestComplete;
        this.managedOnMemoryUpdate = toCopy.managedOnMemoryUpdate;
        this.managedOnRegisterRequestComplete = toCopy.managedOnRegisterRequestComplete;
        this.managedOnRegisterUpdate = toCopy.managedOnRegisterUpdate;
        this.managedOnStdErr = toCopy.managedOnStdErr;
        this.managedOnStdOut = toCopy.managedOnStdOut;
        this.managedOnStdIn = toCopy.managedOnStdIn;
        this.managedOnGELTextOut = toCopy.managedOnGELTextOut;
        this.managedOnFatal = toCopy.managedOnFatal;
        this.managedOnError = toCopy.managedOnError;
        this.managedOnWarning = toCopy.managedOnWarning;
        this.managedOnInfo = toCopy.managedOnInfo;
        this.managedOnAllowedUserAccessesChanged = toCopy.managedOnAllowedUserAccessesChanged;
        this.managedOnRefresh = toCopy.managedOnRefresh;
        this.legacyOnRefresh = toCopy.legacyOnRefresh;
        this.managedOnPropertyGet = toCopy.managedOnPropertyGet;
        this.managedOnPropertySet = toCopy.managedOnPropertySet;
        this.managedOnControlPointHit = toCopy.managedOnControlPointHit;
        this.managedOnGelFileListChanged = toCopy.managedOnGelFileListChanged;
        this.addressSizeCache = toCopy.addressSizeCache;
        this.getSrcStepIntoAllowedCache = toCopy.getSrcStepIntoAllowedCache;
        this.getSrcStepOverAllowedCache = toCopy.getSrcStepOverAllowedCache;
        this.getStepOutAllowedCache = toCopy.getStepOutAllowedCache;
        this.getAsmStepIntoAllowedCache = toCopy.getAsmStepIntoAllowedCache;
        this.getAsmStepOverAllowedCache = toCopy.getAsmStepOverAllowedCache;
    }

    @Override
    public void addBreakPointByExpression(String bkptExpression, String condition) {
        try {
            IBreakpoint breakpoint = this.breakpointManager.createBreakpoint(0);
            IBreakpointLocation location = this.breakpointManager.createLocation();
            location.setSymbolicLocation(bkptExpression);
            breakpoint.setPrecisePCBreak(location);
            location = null;
            breakpoint.setLogicalCondition(condition);
            this.breakpointManager.add(breakpoint);
            this.breakpointManager.enable(breakpoint);
            breakpoint = null;
        }
        catch (IBreakpointManager.BreakpointException breakpointException) {
            // empty catch block
        }
    }

    @Override
    public void addBreakPointByLine(String srcFileName, int lineNumber, String condition) {
        this.wrappedDspUserBreakpoints.addBreakPointByLine(srcFileName, lineNumber, condition);
    }

    @Override
    public void addBreakpoint(IDspValue addr, String condition) {
        this.wrappedDspUserBreakpoints.addBreakPoint(((DspValue)addr).getWrappedTargetData(), condition);
    }

    @Override
    public void addProbePointFileIO(String strFileIO, IDspValue ioAddr, int ioLength, boolean inout, IDspValue profileAddr, String condition) {
        this.wrappedDspUserBreakpoints.addProbePointFileIO(strFileIO, (dsITargetData)((DspValue)ioAddr).getWrappedObject(), ioLength, inout, (dsITargetData)((DspValue)profileAddr).getWrappedObject(), condition);
    }

    @Override
    public void addProbePointFileIOByLine(String strFileIO, IDspValue ioAddr, int ioLength, boolean inout, String strFileName, int lineNumber, String condition) {
        this.wrappedDspUserBreakpoints.addProbePointFileIOByLine(strFileIO, (dsITargetData)((DspValue)ioAddr).getWrappedObject(), ioLength, inout, strFileName, lineNumber, condition);
    }

    private AddressSizesInBits uncachedAddrSizeInBits() {
        long[] arraySize = new long[1];
        short[][] pageNumbers = new short[1][];
        short[][] sizesPerPage = new short[1][];
        boolean safeToCache = this.wrappedMemoryAccess.addrSizeInBits(arraySize, pageNumbers, sizesPerPage);
        return new AddressSizesInBits(pageNumbers[0], sizesPerPage[0], safeToCache);
    }

    @Override
    public int addrSizeInBits(short pageNumber) {
        return this.addressSizeCache.fetch().get(pageNumber);
    }

    @Override
    public short addressableDataSizeInBits(short pageNum) {
        return this.wrappedMemoryAccess.addressableDataSizeInBits(pageNum);
    }

    @Override
    public void animate() {
        this.wrappedRunControl.animate();
    }

    @Override
    public boolean breakPointSet(IDspValue bkptAddr) {
        return this.wrappedDspUserBreakpoints.breakPointSet(((DspValue)bkptAddr).getWrappedTargetData());
    }

    @Override
    public boolean breakPointSetByLine(String srcFileName, int lineNumber) {
        return this.wrappedDspUserBreakpoints.breakPointSetByLine(srcFileName, lineNumber);
    }

    @Override
    public String cEvalErrorMessage(short errorCode) {
        return this.wrappedExpressionEvaluation.cEvalErrorMessage(errorCode);
    }

    @Override
    public boolean capableLowPowerRun() {
        return this.wrappedRunControl.getCapableLowPowerRun();
    }

    @Override
    public int connectionStatus() {
        switch (this.parentTask.getTargetConnection().getConnectionStatus()) {
            case CONNECTED: {
                return 0;
            }
            case CONNECTING: {
                return 1;
            }
            case DISCONNECTED: {
                return 2;
            }
            case DISCONNECTING: {
                return 3;
            }
        }
        throw new RuntimeException("Unknown connection type");
    }

    @Override
    public IDisAssemble createDisAssemble() {
        return this.parentTask.createDisAssemble();
    }

    @Override
    public IDisAsmManager createDisAsmManager() {
        return this.parentTask.createDisAsmManager();
    }

    @Override
    public IDspMemory createDspMemory(IDspValue startAddress, int length, short pageNumber) {
        return new DspMemory(this.wrappedMemoryAccess.createMemory(((DspValue)startAddress).getWrappedTargetData(), length, pageNumber));
    }

    @Override
    public IDspRegister createDspRegister(int startRegisterID) {
        return new DspRegister(this.wrappedRegisterAccess.createDspRegister(startRegisterID, 1L));
    }

    @Override
    public IDspValue createDspValue(int type, int initialValue) {
        return new DspValue(((dsIDspUser)this.wrappedObject).createTargetData((short)type, initialValue));
    }

    @Override
    public IDspValue createDspValue(IDspValue.Type type, int initialValue) {
        return new DspValue(((dsIDspUser)this.wrappedObject).createTargetData(DspValue.translateFromDspValueTypeEnum(type), initialValue));
    }

    @Override
    public IDspValue createDspValue(IDspValue.Type type, long initialValue) {
        return new DspValue(((dsIDspUser)this.wrappedObject).createTargetData64(DspValue.translateFromDspValueTypeEnum(type), initialValue));
    }

    @Override
    public boolean disconnectCapable() {
        return this.parentTask.getTargetConnection().disconnectCapable();
    }

    @Override
    public int enableMemoryMap(boolean bMapOn) {
        return this.wrappedMemoryMap.enableMemoryMap(bMapOn);
    }

    private boolean internalFindMemoryMapSection(IDspValue ulAddress, short usPage, IDspValue pStartAddress, IDspValue pEndAddress, boolean[] bReadable, boolean[] bWriteable, String[] holdAttribute) {
        dsITargetData addressValue = ((DspValue)ulAddress).getWrappedTargetData();
        return this.wrappedMemoryMap.findMemoryMapSection(addressValue, usPage, ((DspValue)pStartAddress).getWrappedTargetData(), ((DspValue)pEndAddress).getWrappedTargetData(), bReadable, bWriteable, holdAttribute);
    }

    @Override
    public boolean findMemoryMapSection(IDspValue ulAddress, short usPage, IDspValue pStartAddress, IDspValue pEndAddress, boolean[] bReadable, boolean[] bWriteable) {
        String[] holdAttribute = new String[]{""};
        return this.internalFindMemoryMapSection(ulAddress, usPage, pStartAddress, pEndAddress, bReadable, bWriteable, holdAttribute);
    }

    @Override
    public void freeRun() {
        this.wrappedRunControl.freeRun();
    }

    @Override
    public int getDspRegisterID(String name) {
        IRegister regInfo = this.registerServer.findRegisterByName(name);
        if (null != regInfo) {
            return regInfo.getAddress();
        }
        return -1;
    }

    @Override
    public boolean getEnableProfileClock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getFP(IDspValue fp) {
        this.wrappedRegisterAccess.getFP(((DspValue)fp).getWrappedTargetData());
    }

    @Override
    public boolean getGlobalBreakpoints() {
        return this.getParentTask().getGlobalBreakpoints().isEnabled();
    }

    @Override
    public boolean getMapOn() {
        return this.wrappedMemoryMap.getMapOn();
    }

    @Override
    public boolean getMemoryReadable(short pageNum, IDspValue startAddress, IDspValue length) {
        return this.wrappedMemoryMap.memoryReadable(pageNum, ((DspValue)startAddress).getWrappedTargetData(), ((DspValue)length).getWrappedTargetData());
    }

    @Override
    public boolean getMemoryWritable(short pageNum, IDspValue startAddress, IDspValue length) {
        return this.wrappedMemoryMap.memoryWritable(pageNum, ((DspValue)startAddress).getWrappedTargetData(), ((DspValue)length).getWrappedTargetData());
    }

    @Override
    public IOnChipAnalysis getOnChipAnalysis() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getPC(IDspValue pc) {
        this.wrappedRegisterAccess.getPC(((DspValue)pc).getWrappedTargetData());
    }

    @Override
    public IPinConnect getPinConnect() {
        return this.parentTask.getPinConnect();
    }

    @Override
    public IPipeLine getPipeLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IPortConnect getPortConnect() {
        return this.parentTask.getPortConnect();
    }

    @Override
    public boolean getPower() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getProcessorID() {
        return this.processorInfo.getProcessorID();
    }

    @Override
    public boolean getSecure() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ISymbolManager getSymbolManager() {
        return this.parentTask.getSymbolManager();
    }

    @Override
    public boolean getSymbolValue(String symbolName, IDspValue symbolValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTargetFamilyID() {
        return this.processorInfo.getTargetFamilyID();
    }

    @Override
    public int getTargetRev() {
        return this.processorInfo.getTargetRev();
    }

    @Override
    public int getTargetSubFamilyID() {
        return this.processorInfo.getTargetSubFamilyID();
    }

    @Override
    public int getTargetType() {
        return this.processorInfo.getTargetType();
    }

    @Override
    public int getTaskRunningState() {
        return this.getTaskRunningState3(null, null);
    }

    @Override
    public int getTaskRunningState2() {
        return this.getTaskRunningState3(null, null);
    }

    @Override
    public int getTaskRunningState3(boolean[] vbPowered, boolean[] vbSecured) {
        int[] unused = new int[]{0};
        return this.wrappedRunControl.getExecutionState(vbPowered, vbSecured, unused);
    }

    @Override
    public void halt() {
        this.wrappedRunControl.halt();
    }

    @Override
    public void lowPowerRun() {
        throw new UnsupportedOperationException();
    }

    public void memoryWrite(IDspMemory mem, boolean broadcast) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyMemoryMap(IDspValue startAddress, IDspValue endAddress, short pageNumber, boolean readable, boolean writable) {
        this.wrappedMemoryMap.modifyMemoryMap(((DspValue)startAddress).getWrappedTargetData(), ((DspValue)endAddress).getWrappedTargetData(), pageNumber, readable, writable);
    }

    @Override
    public void multipleRun(String condition, int iterations) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short numberOfMemoryPages() {
        return this.wrappedMemoryAccess.getNumberOfMemoryPages();
    }

    @Override
    public boolean probePointSet(IDspValue probeptAddr) {
        return this.wrappedDspUserBreakpoints.probePointSet(((DspValue)probeptAddr).getWrappedTargetData());
    }

    public boolean probePointSetByLine(String srcFileName, int lineNumber) {
        return this.wrappedDspUserBreakpoints.probePointSetByLine(srcFileName, lineNumber);
    }

    @Override
    public void putEnableProfileClock(boolean bEnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readProfileClock(IDspValue profileTickCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeBreakpoint(IDspValue addr) {
        this.wrappedDspUserBreakpoints.removeBreakPoint(((DspValue)addr).getWrappedTargetData());
    }

    @Override
    public void removeBreakpointByLine(String srcFileName, int lineNumber) {
        this.wrappedDspUserBreakpoints.removeBreakPointByLine(srcFileName, lineNumber);
    }

    @Override
    public void requestCExprEval(String expr) {
        this.wrappedExpressionEvaluation.requestCExprEval(expr, true, false);
    }

    @Override
    public void requestFileLoad(String programPath, boolean symbolsOnly) {
        if (symbolsOnly) {
            this.parentTask.getSymbolManager().requestSymbolLoad(programPath, null);
        } else {
            this.parentTask.getSymbolManager().requestFileLoad(programPath, null);
        }
    }

    @Override
    public boolean isProgramLoaded() {
        return this.parentTask.getSymbolManager().isProgramLoaded();
    }

    @Override
    public void requestReload() {
        this.parentTask.getSymbolManager().requestFileReload(null);
    }

    @Override
    public void reset() {
        this.parentTask.getResetManager().getAdvancedResets().getDefaultReset().issueReset();
    }

    @Override
    public void restart() {
        this.wrappedRunControl.restart();
    }

    @Override
    public void run(String condition) {
        if (!this.capableExecutionControl()) {
            throw new UnsupportedOperationException();
        }
        this.wrappedRunControl.runWithCondition(condition);
    }

    @Override
    public void run() {
        if (!this.capableExecutionControl()) {
            throw new UnsupportedOperationException();
        }
        this.wrappedRunControl.run();
    }

    @Override
    public void setGlobalBreakpoints(boolean value) {
        this.getParentTask().getGlobalBreakpoints().enable(value);
    }

    @Override
    public void targetConnect() {
        this.parentTask.getTargetConnection().targetConnect(null);
    }

    @Override
    public void targetDisconnect() {
        this.parentTask.getTargetConnection().targetDisconnect(null);
    }

    @Override
    public void targetDisconnect(boolean removeAll) {
        this.targetDisconnect();
    }

    @Override
    public int wordSizeInBits(short pageNumber) {
        return this.wrappedMemoryAccess.wordSizeInBits(pageNumber);
    }

    public dsIExpressionEvaluation getWrappedExpressionEvaluation() {
        return this.wrappedExpressionEvaluation;
    }

    public dsIMemoryAccess getWrappedMemoryAccess() {
        return this.wrappedMemoryAccess;
    }

    public dsIRegisterAccess getWrappedRegisterAccess() {
        return this.wrappedRegisterAccess;
    }

    @Override
    public boolean capableFreeRun() {
        if (null == this.capableFreeRunCache) {
            this.capableFreeRunCache = this.wrappedRunControl.getCapableFreeRun();
        }
        return this.capableFreeRunCache;
    }

    @Override
    public IDspUser.MemoryMapInfo findMemoryMapSection(IDspValue ulAddress, short usPage) {
        IDspValue startValue = this.createDspValue(IDspValue.Type.POINTER, 0L);
        IDspValue endValue = this.createDspValue(IDspValue.Type.POINTER, 0L);
        IDspValue.Type holdTypeToCast = startValue.bestMatchedUDataTypeType(this.addrSizeInBits(usPage), usPage);
        IDspValue holdValue = startValue.typeCast(DspValue.translateFromDspValueTypeEnum(holdTypeToCast), 0);
        startValue.dispose();
        startValue = holdValue;
        holdValue = endValue.typeCast(DspValue.translateFromDspValueTypeEnum(holdTypeToCast), 0);
        endValue.dispose();
        endValue = holdValue;
        holdValue = null;
        boolean[] bReadable = new boolean[]{false};
        boolean[] bWritable = new boolean[]{false};
        String[] strAttribute = new String[]{""};
        IDspUser.MemoryMapInfo memoryMapInfo = null;
        boolean ret = this.internalFindMemoryMapSection(ulAddress, usPage, startValue, endValue, bReadable, bWritable, strAttribute);
        memoryMapInfo = new IDspUser.MemoryMapInfo(ret, bReadable[0], bWritable[0], startValue.toLong(), endValue.toLong(), usPage, strAttribute[0]);
        startValue.dispose();
        startValue = null;
        endValue.dispose();
        endValue = null;
        return memoryMapInfo;
    }

    @Override
    public String getISAFamily() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompatibleCPUFamily(String programCPUFamily) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String nameOfMemoryPage(short pageNumber) {
        return this.wrappedMemoryAccess.nameOfPage(pageNumber);
    }

    public void setLocalFrame(IDspValue pc, IDspValue fp) {
        throw new UnsupportedOperationException();
    }

    public void writeToStream(String message, String tab, String stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasDebugStateToRestore() {
        return this.parentTask.getTargetConnection().hasDebugStateToRestore();
    }

    @Override
    public void restoreDebugState() {
        this.parentTask.getTargetConnection().restoreDebugState();
    }

    @Override
    public ISimpleEvent onAlreadyRunning() {
        return this.managedOnAlreadyRunning;
    }

    @Override
    public IObjectEvent<IEventData<IDspValue>> onHalt() {
        return this.managedOnHalt;
    }

    @Override
    public ISimpleEvent onPowerStatusChanged() {
        return this.managedOnPowerStatusChanged;
    }

    @Override
    public INumberEvent onRestart() {
        return this.managedOnRestart;
    }

    @Override
    public ISimpleEvent onRunning() {
        return this.managedOnRunning;
    }

    @Override
    public ISimpleEvent onSecureStatusChanged() {
        return this.managedOnSecureStatusChanged;
    }

    @Override
    public ISimpleEvent onExecutionStatusChanged() {
        return this.managedOnExecutionStatusChanged;
    }

    @Override
    public ISimpleEvent onEmulatorReset() {
        return this.managedOnEmulatorReset;
    }

    @Override
    public ISimpleEvent onHaltOnResetChanged() {
        return this.managedOnHaltOnResetChanged;
    }

    @Override
    public ISimpleEvent onHeldInReset() {
        return this.managedOnHeldInReset;
    }

    @Override
    public INumberEvent onReset() {
        return this.managedOnReset;
    }

    @Override
    public IObjectEvent<IFileLoadedEventData> onFileLoaded() {
        return this.managedOnFileLoaded;
    }

    @Override
    public ISimpleEvent onStartFileLoad() {
        return this.managedOnStartFileLoad;
    }

    @Override
    public IObjectEvent<IExpressionEvaluationData> onCExprEvaluated() {
        return this.managedOnCExprEvaluated;
    }

    @Override
    public IBooleanEvent onExtMemoryChanged() {
        return this.managedOnExtMemoryChanged;
    }

    @Override
    public IObjectEvent<IMemoryAccessEventData> onMemoryRequestComplete() {
        return this.managedOnMemoryRequestComplete;
    }

    @Override
    public IObjectEvent<IMemoryAccessEventData> onMemoryUpdate() {
        return this.managedOnMemoryUpdate;
    }

    @Override
    public IObjectEvent<IRegisterAccessEventData> onRegisterRequestComplete() {
        return this.managedOnRegisterRequestComplete;
    }

    @Override
    public IObjectEvent<IRegisterAccessEventData> onRegisterUpdate() {
        return this.managedOnRegisterUpdate;
    }

    @Override
    public IStringEvent onStdErr() {
        return this.managedOnStdErr;
    }

    @Override
    public IStringEvent onStdOut() {
        return this.managedOnStdOut;
    }

    @Override
    public IObjectEvent<IStdInDialog> onStdIn() {
        return this.managedOnStdIn;
    }

    @Override
    public IStringEvent onError() {
        return this.managedOnError;
    }

    @Override
    public IStringEvent onFatal() {
        return this.managedOnFatal;
    }

    @Override
    public IStringEvent onInfo() {
        return this.managedOnInfo;
    }

    @Override
    public IStringEvent onWarning() {
        return this.managedOnWarning;
    }

    @Override
    public ISimpleEvent onMemoryMapUpdate() {
        return this.managedOnMemoryMapUpdate;
    }

    @Override
    public IBooleanEvent onNewSymbols() {
        return this.managedOnNewSymbols;
    }

    @Override
    public ISimpleEvent onNewSymbolsOffline() {
        return this.managedOnNewSymbolsOffline;
    }

    @Override
    public IObjectEvent<IGelTextOutData> onTextOut() {
        return this.managedOnGELTextOut;
    }

    @Override
    public IBooleanEvent onGlobalBreakpointsChanged() {
        return this.getParentTask().getGlobalBreakpoints().onGlobalBreakpointsChanged();
    }

    @Override
    public ISimpleEvent onWindowRefresh() {
        return null;
    }

    public ISimpleEvent onContinuousRefreshUpdate() {
        return this.managedOnContinuousRefreshUpdate;
    }

    public ISimpleEvent onRealtimeModeSwitch() {
        return this.managedOnRealtimeModeSwitch;
    }

    @Override
    public ISimpleEvent onGelFileListChanged() {
        return this.managedOnGelFileListChanged;
    }

    @Override
    public IGelFiles getGelFiles() {
        return this.parentTask.getGelFiles();
    }

    @Override
    public void requestMemoryRead(IDspMemory mem, boolean broadcast) {
        this.requestMemoryRead(mem, broadcast, false);
    }

    @Override
    public void requestMemoryRead(IDspMemory mem, boolean broadcast, boolean removingDebugState) {
        if (!(mem instanceof DspMemory)) {
            throw new UnsupportedOperationException();
        }
        dsIMemory memory = ((DspMemory)mem).getWrappedMemory();
        this.wrappedMemoryAccess.requestMemoryRead(memory, true);
    }

    @Override
    public void requestMemoryWrite(IDspMemory mem, boolean broadcast) {
        this.requestMemoryWrite(mem, broadcast, false);
    }

    @Override
    public void requestMemoryWrite(IDspMemory mem, boolean broadcast, boolean removingDebugState) {
        if (!(mem instanceof DspMemory)) {
            throw new UnsupportedOperationException();
        }
        dsIMemory memory = ((DspMemory)mem).getWrappedMemory();
        this.wrappedMemoryAccess.requestMemoryWrite(memory);
    }

    @Override
    public void requestRegisterRead(IDspRegister reg, boolean broadcast) {
        this.requestRegisterRead(reg, broadcast, false);
    }

    @Override
    public void requestRegisterRead(IDspRegister reg, boolean broadcast, boolean removingDebugState) {
        if (!(reg instanceof DspRegister)) {
            throw new UnsupportedOperationException();
        }
        dsIRegister register = ((DspRegister)reg).getWrappedRegister();
        this.wrappedRegisterAccess.requestRegisterRead(register, true);
    }

    @Override
    public void requestRegisterWrite(IDspRegister reg, boolean broadcast) {
        this.requestRegisterWrite(reg, broadcast, false);
    }

    @Override
    public void requestRegisterWrite(IDspRegister reg, boolean broadcast, boolean removingDebugState) {
        if (!(reg instanceof DspRegister)) {
            throw new UnsupportedOperationException();
        }
        dsIRegister register = ((DspRegister)reg).getWrappedRegister();
        this.wrappedRegisterAccess.requestRegisterWrite(register);
    }

    @Override
    public void srcStepInto() {
        this.multipleSrcStepInto(1);
    }

    @Override
    public void srcStepOver() {
        this.multipleSrcStepOver(1);
    }

    @Override
    public void multipleSrcStepInto(int iterations) {
        if (!this.capableExecutionControl()) {
            throw new UnsupportedOperationException();
        }
        this.wrappedSourceStepping.stepInto(iterations);
    }

    @Override
    public void multipleSrcStepOver(int iterations) {
        if (!this.capableExecutionControl()) {
            throw new UnsupportedOperationException();
        }
        this.wrappedSourceStepping.stepOver(iterations);
    }

    @Override
    public void asmStepInto() {
        this.multipleAsmStepInto(1);
    }

    @Override
    public void asmStepOver() {
        this.multipleAsmStepOver(1);
    }

    @Override
    public void multipleAsmStepInto(int iterations) {
        if (!this.capableExecutionControl()) {
            throw new UnsupportedOperationException();
        }
        this.wrappedSourceStepping.asmStepInto(iterations);
    }

    @Override
    public void multipleAsmStepOver(int iterations) {
        if (!this.capableExecutionControl()) {
            throw new UnsupportedOperationException();
        }
        this.wrappedSourceStepping.asmStepOver(iterations);
    }

    @Override
    public void stepInto() {
        this.multipleStepInto(1);
    }

    @Override
    public void stepOver() {
        this.multipleStepOver(1);
    }

    @Override
    public void multipleStepInto(int iterations) {
        if (this.getSrcStepIntoAllowed()) {
            this.multipleSrcStepInto(iterations);
        } else {
            this.multipleAsmStepInto(iterations);
        }
    }

    @Override
    public void multipleStepOver(int iterations) {
        if (this.getSrcStepOverAllowed()) {
            this.multipleSrcStepOver(iterations);
        } else {
            this.multipleAsmStepOver(iterations);
        }
    }

    @Override
    public void stepOut() {
        this.multipleStepOut(1);
    }

    @Override
    public void multipleStepOut(int iterations) {
        if (!this.capableExecutionControl()) {
            throw new UnsupportedOperationException();
        }
        this.wrappedSourceStepping.stepOut(iterations);
    }

    @Override
    public boolean getSrcStepIntoAllowed() {
        return (Boolean)this.getSrcStepIntoAllowedCache.fetch();
    }

    @Override
    public boolean getSrcStepOverAllowed() {
        return (Boolean)this.getSrcStepOverAllowedCache.fetch();
    }

    @Override
    public boolean getStepOutAllowed() {
        return (Boolean)this.getStepOutAllowedCache.fetch();
    }

    @Override
    public boolean getAsmStepIntoAllowed() {
        return (Boolean)this.getAsmStepIntoAllowedCache.fetch();
    }

    @Override
    public boolean getAsmStepOverAllowed() {
        return (Boolean)this.getAsmStepOverAllowedCache.fetch();
    }

    @Override
    public boolean getStepIntoAllowed() {
        return this.getAsmStepIntoAllowed();
    }

    @Override
    public boolean getStepOverAllowed() {
        return this.getAsmStepOverAllowed();
    }

    @Override
    public boolean capableGlobalBreakpoints() {
        return this.getParentTask().getGlobalBreakpoints().canModifyGlobalBreakpoints();
    }

    @Override
    public DspUser createClone() {
        return new DspUser(this.parentTask, (dsIDspUser)this.wrappedObject.queryInterface("{a19d0553-8ddc-4031-932a-903637ec28cc}"), this.processorInfo, this.breakpointManager, this.registerServer);
    }

    @Override
    public boolean allowUserToPerform(IDspUser.AccessType accessType) {
        return this.wrappedRefreshControl.allowUserToPerform(accessTypeMap.get((Object)accessType));
    }

    @Override
    public boolean allowUserToPerform(int accessType) {
        return this.wrappedRefreshControl.allowUserToPerform(accessType);
    }

    @Override
    public ITransaction beginRefresh() {
        if (0 == this.wrappedRefreshControl.beginRefresh()) {
            return new EmptyTransaction();
        }
        return new RefreshTransaction(this);
    }

    long endRefresh() {
        long result = this.wrappedRefreshControl.endRefresh();
        if (0L == result) {
            // empty if block
        }
        return result;
    }

    @Override
    public RegisteredView registerViewForRefresh(String viewType) {
        return new RegisteredView(this.wrappedRefreshControl.registerViewForRefresh(viewType));
    }

    @Override
    public ISimpleEvent onAllowedUserAccessesChanged() {
        return this.managedOnAllowedUserAccessesChanged;
    }

    @Override
    public IObjectEvent<IRefreshEventData> onRefreshWithReason() {
        return this.managedOnRefresh;
    }

    @Override
    public ISimpleEvent onRefresh() {
        return this.legacyOnRefresh;
    }

    @Override
    public IObjectEvent<IControlPointEventData> onControlPointHit() {
        return this.managedOnControlPointHit;
    }

    @Override
    public boolean capableDisassembly() {
        return this.capableProgramOrSymbolLoad();
    }

    @Override
    public boolean capableExecutionControl() {
        return this.wrappedRunControl.getCapableExecutionControl();
    }

    @Override
    public boolean capableProgramOrSymbolLoad() {
        return this.parentTask.getSymbolManager().capableProgramOrSymbolLoad();
    }

    @Override
    public IObjectEvent<IPriorityFileLoadedEventData> onPriorityFileLoaded() {
        return this.managedOnPriorityFileLoaded;
    }

    @Override
    public boolean capableTargetProperties(IDspUser.TargetProperties type) {
        return this.wrappedTargetProperties.capableTargetProperties(this.translatePropertyEnum(type));
    }

    private int translatePropertyEnum(IDspUser.TargetProperties type) {
        switch (type) {
            case MMU_STATE: {
                return 0;
            }
            case NUM_MMU_TTBR_REGS: {
                return 1;
            }
            case TTBR_REG: {
                return 2;
            }
            case CURRENT_PROCID: {
                return 3;
            }
            case NUM_MMU_DOMAINS: {
                return 4;
            }
            case DOMAIN_ACCESS: {
                return 5;
            }
            case ALL_DOMAIN_ACCESS: {
                return 6;
            }
            case COHERENCY_CONTROL: {
                return 7;
            }
            case COHERENCY_CNTRL_SPECIFIC: {
                return 8;
            }
            case TEST_PROPERTY: {
                return 9;
            }
        }
        throw new RuntimeException("Invalid TargetProperties type");
    }

    @Override
    public void requestPropertyGet(IDspUser.TargetProperties type, long parameter) {
        this.wrappedTargetProperties.requestPropertyGet(this.translatePropertyEnum(type), parameter);
    }

    @Override
    public void requestPropertySet(IDspUser.TargetProperties type, long parameter, long value) {
        this.wrappedTargetProperties.requestPropertySet(this.translatePropertyEnum(type), parameter, value);
    }

    @Override
    public IObjectEvent<ITargetPropertyData> onPropertyGet() {
        return this.managedOnPropertyGet;
    }

    @Override
    public IObjectEvent<ITargetPropertyData> onPropertySet() {
        return this.managedOnPropertySet;
    }

    @Override
    public boolean isRouterSystemFeatureCapable() {
        return this.wrappedRouterSystemFeatures.isRouterSystemFeatureCapable();
    }

    @Override
    public long getNumRouterSystemFeatures() {
        return this.wrappedRouterSystemFeatures.getNumRouterSystemFeatures();
    }

    @Override
    public IRouterSystemFeature getRouterSystemFeature(long featureID) {
        if (this.wrappedRouterSystemFeatures.isRouterSystemFeatureCapable()) {
            return new RouterSystemFeature(this.wrappedRouterSystemFeatures.getRouterSystemFeature(featureID));
        }
        return null;
    }

    private int translateErrorSeverityEnum(IDspUser.ErrorSeverity type) {
        switch (type) {
            case ERROR_WARNING: {
                return 0;
            }
            case ERROR_SEVERE: {
                return 1;
            }
            case ERROR_FATAL: {
                return 2;
            }
            case ERROR_INFO: {
                return 3;
            }
        }
        throw new RuntimeException("Invalid ErrorSeverity type");
    }

    @Override
    public void reportError(IDspUser.ErrorSeverity severity, String componentName, String errorMessage) {
        ((dsIDspUser)this.wrappedObject).reportError(this.translateErrorSeverityEnum(severity), componentName, errorMessage);
    }

    @Override
    public boolean areControlPointsUsable() {
        return this.wrappedControlPointControl.getAreControlPointsUsable();
    }

    @Override
    public void areControlPointsUsable(boolean setUsable) {
        this.wrappedControlPointControl.setAreControlPointsUsable(setUsable);
    }

    @Override
    public INumberEvent onTargetHaltDetected() {
        return this.managedOnTargetHaltDetected;
    }

    @Override
    public ISimpleEvent onConnectFailed() {
        return this.parentTask.getTargetConnection().onConnectFailed();
    }

    @Override
    public ISimpleEvent onConnected() {
        return this.parentTask.getTargetConnection().onConnected();
    }

    @Override
    public ISimpleEvent onConnecting() {
        return this.parentTask.getTargetConnection().onConnecting();
    }

    @Override
    public ISimpleEvent onDisconnected() {
        return this.parentTask.getTargetConnection().onDisconnected();
    }

    @Override
    public IBooleanEvent onDisconnecting() {
        return this.parentTask.getTargetConnection().onDisconnecting();
    }

    @Override
    public IBooleanEvent onRemoveDebugState() {
        return this.onRemoveDebugState;
    }

    @Override
    public ISimpleEvent onRestoreDebugState() {
        return this.parentTask.getTargetConnection().onRestoreDebugState();
    }

    @Override
    public IDspTask getParentTask() {
        return this.parentTask;
    }

    @Override
    public ICancelable goMain(IStringEventListener callback) {
        return this.parentTask.getExpressionEvaluator().evaluateGELBuiltinAsAPI("GEL_Go(main)", callback);
    }

    private abstract class SteppingAllowedCache
    extends FunctionResultCache<Boolean> {
        SteppingAllowedCache() {
            this.InvalidateOn(DspUser.this.onExecutionStatusChanged());
            this.InvalidateOn(DspUser.this.parentTask.getTargetConnection().onConnected());
            this.InvalidateOn(DspUser.this.parentTask.getTargetConnection().onDisconnecting());
            this.InvalidateOn(DspUser.this.onNewSymbols());
            this.InvalidateOn(DspUser.this.onRefresh());
        }
    }

    private final class AddressSizeCache {
        private volatile boolean cacheValid = false;
        private AddressSizesInBits cache = null;
        private final IBooleanEventListener cacheInvalidator = new IBooleanEventListener(){

            @Override
            public void onEvent(boolean data) {
                AddressSizeCache.this.cacheValid = false;
            }
        };

        public AddressSizesInBits fetch() {
            AddressSizesInBits value = this.cache;
            if (null == value || !this.cacheValid) {
                this.cache = value = DspUser.this.uncachedAddrSizeInBits();
                if (value.isSafeToCache()) {
                    this.cacheValid = true;
                }
            }
            return value;
        }

        public AddressSizeCache() {
            DspUser.this.onExtMemoryChanged().addIBooleanEventListener(this.cacheInvalidator);
        }
    }

    private final class AddressSizesInBits {
        private final Map<Short, Short> pageToSizeMap = new HashMap<Short, Short>();
        private final boolean safeToCache;

        public AddressSizesInBits(short[] pageNumbers, short[] sizesPerPage, boolean safeToCache) {
            for (int i = 0; i < pageNumbers.length; ++i) {
                this.pageToSizeMap.put(pageNumbers[i], sizesPerPage[i]);
            }
            this.safeToCache = safeToCache;
        }

        public int get(short pageNumber) {
            if (!this.pageToSizeMap.containsKey(pageNumber)) {
                pageNumber = 0;
            }
            return this.pageToSizeMap.get(pageNumber).shortValue();
        }

        public boolean isSafeToCache() {
            return this.safeToCache;
        }
    }
}

