/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.framework.ICloneableWrapper;
import com.ti.xpcom.interfaces.dsITargetData;
import java.util.ArrayList;
import java.util.List;

public class DspValue
extends AComparableDisposable<dsITargetData>
implements IDspValue,
ICloneableWrapper {
    public DspValue(dsITargetData targetData) {
        super(targetData);
    }

    @Override
    public void assignDouble(double val) {
        ((dsITargetData)this.wrappedObject).assignDouble(val);
    }

    @Override
    public void assignLong(int val) {
        ((dsITargetData)this.wrappedObject).assignLong(val);
    }

    @Override
    public void assignLongLong(long val) {
        ((dsITargetData)this.wrappedObject).assignLongLong(val);
    }

    @Override
    public int bestMatchedUDataType(int nBits, short page) {
        return ((dsITargetData)this.wrappedObject).bestMatchedUDataType(nBits, page);
    }

    @Override
    public IDspValue.Type bestMatchedUDataTypeType(int nBits, short page) {
        return DspValue.translateToDspValueTypeEnum(((dsITargetData)this.wrappedObject).bestMatchedUDataType(nBits, page));
    }

    @Override
    public IDspValue.Type bestMatchedSignedDataTypeType(int nBits, short page) {
        return DspValue.translateToDspValueTypeEnum(((dsITargetData)this.wrappedObject).bestMatchedSignedDataType(nBits, page));
    }

    @Override
    public List<IDspValue.SupportedType> getSupportedTypes(short pageNum) {
        short[][] supportedTypes = new short[][]{{0}};
        short[][] supportedTypesFormat = new short[][]{{0}};
        long[] numTypes = new long[]{0L};
        String[][] supportTypesDisplayString = new String[][]{{""}};
        ((dsITargetData)this.wrappedObject).getSupportedTypes(pageNum, numTypes, supportedTypes, supportedTypesFormat, supportTypesDisplayString);
        ArrayList<IDspValue.SupportedType> supportTypesList = new ArrayList<IDspValue.SupportedType>();
        if (numTypes[0] != 0L && supportedTypes[0] != null) {
            for (int i = 0; i < (int)numTypes[0]; ++i) {
                IDspValue.SupportedType type = new IDspValue.SupportedType();
                type.Type = DspValue.translateToDspValueTypeEnum(supportedTypes[0][i]);
                type.Format = IDspValue.Format.getFromInt(supportedTypesFormat[0][i]);
                type.DisplayString = supportTypesDisplayString[0][i];
                supportTypesList.add(type);
            }
        }
        return supportTypesList;
    }

    @Override
    public short bitSizeOf() {
        return ((dsITargetData)this.wrappedObject).bitSizeOf();
    }

    @Override
    public boolean equal(IDspValue pVal) {
        DspValue val = (DspValue)pVal;
        return ((dsITargetData)this.wrappedObject).equal(val.getWrappedTargetData());
    }

    @Override
    public int getBit(int bitPos) {
        return ((dsITargetData)this.wrappedObject).getBit((short)bitPos);
    }

    @Override
    public int getType() {
        return ((dsITargetData)this.wrappedObject).getType();
    }

    @Override
    public IDspValue.Type getEnumType() {
        for (IDspValue.Type type : IDspValue.Type.values()) {
            if (DspValue.translateFromDspValueTypeEnum(type) != ((dsITargetData)this.wrappedObject).getType()) continue;
            return type;
        }
        return null;
    }

    public static short translateFromDspValueTypeEnum(IDspValue.Type type) {
        switch (type) {
            case CHAR: {
                return 0;
            }
            case UCHAR: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case USHORT: {
                return 3;
            }
            case ENUM: {
                return 4;
            }
            case INT: {
                return 6;
            }
            case UINT: {
                return 7;
            }
            case LONG: {
                return 8;
            }
            case ULONG: {
                return 9;
            }
            case POINTER: {
                return 11;
            }
            case DATA8: {
                return 12;
            }
            case DATA16: {
                return 14;
            }
            case DATA24: {
                return 16;
            }
            case DATA32: {
                return 18;
            }
            case DATA40: {
                return 20;
            }
            case DATA48: {
                return 22;
            }
            case DATA64: {
                return 24;
            }
            case UDATA8: {
                return 13;
            }
            case UDATA16: {
                return 15;
            }
            case UDATA24: {
                return 17;
            }
            case UDATA32: {
                return 19;
            }
            case UDATA40: {
                return 21;
            }
            case UDATA48: {
                return 23;
            }
            case UDATA64: {
                return 25;
            }
            case FARPOINTER: {
                return 27;
            }
            case NEARPOINTER: {
                return 29;
            }
            case LONGLONG: {
                return 30;
            }
            case ULONGLONG: {
                return 31;
            }
            case FLOAT: {
                return 32;
            }
            case IEEE_FLOAT: {
                return 34;
            }
            case DOUBLE: {
                return 36;
            }
            case IEEE_DOUBLE: {
                return 38;
            }
            case LDOUBLE: {
                return 40;
            }
        }
        throw new RuntimeException("Invalid IDspValue type");
    }

    public static IDspValue.Type translateToDspValueTypeEnum(int toConvert) {
        switch (toConvert) {
            case 0: {
                return IDspValue.Type.CHAR;
            }
            case 1: {
                return IDspValue.Type.UCHAR;
            }
            case 2: {
                return IDspValue.Type.SHORT;
            }
            case 3: {
                return IDspValue.Type.USHORT;
            }
            case 4: {
                return IDspValue.Type.ENUM;
            }
            case 6: {
                return IDspValue.Type.INT;
            }
            case 7: {
                return IDspValue.Type.UINT;
            }
            case 8: {
                return IDspValue.Type.LONG;
            }
            case 9: {
                return IDspValue.Type.ULONG;
            }
            case 11: {
                return IDspValue.Type.POINTER;
            }
            case 12: {
                return IDspValue.Type.DATA8;
            }
            case 14: {
                return IDspValue.Type.DATA16;
            }
            case 16: {
                return IDspValue.Type.DATA24;
            }
            case 18: {
                return IDspValue.Type.DATA32;
            }
            case 20: {
                return IDspValue.Type.DATA40;
            }
            case 22: {
                return IDspValue.Type.DATA48;
            }
            case 24: {
                return IDspValue.Type.DATA64;
            }
            case 13: {
                return IDspValue.Type.UDATA8;
            }
            case 15: {
                return IDspValue.Type.UDATA16;
            }
            case 17: {
                return IDspValue.Type.UDATA24;
            }
            case 19: {
                return IDspValue.Type.UDATA32;
            }
            case 21: {
                return IDspValue.Type.UDATA40;
            }
            case 23: {
                return IDspValue.Type.UDATA48;
            }
            case 25: {
                return IDspValue.Type.UDATA64;
            }
            case 27: {
                return IDspValue.Type.FARPOINTER;
            }
            case 29: {
                return IDspValue.Type.NEARPOINTER;
            }
            case 30: {
                return IDspValue.Type.LONGLONG;
            }
            case 31: {
                return IDspValue.Type.ULONGLONG;
            }
            case 32: {
                return IDspValue.Type.FLOAT;
            }
            case 34: {
                return IDspValue.Type.IEEE_FLOAT;
            }
            case 36: {
                return IDspValue.Type.DOUBLE;
            }
            case 38: {
                return IDspValue.Type.IEEE_DOUBLE;
            }
            case 40: {
                return IDspValue.Type.LDOUBLE;
            }
        }
        throw new RuntimeException("Invalid IDspValue type");
    }

    public static int mapToNaturalFormat(int toConvert) {
        switch (toConvert) {
            case 0: 
            case 1: {
                return 4;
            }
            case 2: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 30: {
                return 2;
            }
            case 11: 
            case 27: 
            case 29: {
                return 0;
            }
            case 32: 
            case 36: 
            case 40: {
                return 7;
            }
            case 34: 
            case 38: {
                return 8;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 31: {
                return 3;
            }
            case 41: {
                return 6;
            }
        }
        throw new RuntimeException("Invalid IDspValue type");
    }

    @Override
    public boolean notEqual(IDspValue pVal) {
        DspValue val = (DspValue)pVal;
        return ((dsITargetData)this.wrappedObject).notEqual(val.getWrappedTargetData());
    }

    @Override
    public IDspValue plusLong(int val) {
        return new DspValue(((dsITargetData)this.wrappedObject).plusLong(val));
    }

    @Override
    public void setBit(int bitPos) {
        ((dsITargetData)this.wrappedObject).setBit((short)bitPos);
    }

    @Override
    public void clearBit(int bitPos) {
        ((dsITargetData)this.wrappedObject).clearBit((short)bitPos);
    }

    @Override
    public IDspValue shiftLeftShort(short val) {
        return new DspValue(((dsITargetData)this.wrappedObject).shiftLeftShort(val));
    }

    @Override
    public int sizeOf() {
        return ((dsITargetData)this.wrappedObject).deprecatedSizeOf();
    }

    @Override
    public int sizeOf2(short pageNum) {
        return ((dsITargetData)this.wrappedObject).sizeOf(pageNum);
    }

    @Override
    public float toDouble() {
        return (float)((dsITargetData)this.wrappedObject).toDouble();
    }

    @Override
    public int toLong() {
        return ((dsITargetData)this.wrappedObject).toLong();
    }

    @Override
    public long toLongLong() {
        return ((dsITargetData)this.wrappedObject).toLongLong();
    }

    @Override
    public String toString(int format) {
        return ((dsITargetData)this.wrappedObject).toString(format, (short)0);
    }

    @Override
    public String toString(int format, int Q) {
        return ((dsITargetData)this.wrappedObject).toString(format, (short)Q);
    }

    @Override
    public String toString() {
        return this.toString(DspValue.mapToNaturalFormat(this.getType()));
    }

    @Override
    public String toStringCStyleHex() {
        return ((dsITargetData)this.wrappedObject).toStringCStyleHex();
    }

    @Override
    public String toStringChar() {
        return ((dsITargetData)this.wrappedObject).toStringChar();
    }

    @Override
    public String toStringReal(short Q) {
        return ((dsITargetData)this.wrappedObject).toStringReal(Q);
    }

    @Override
    public String toStringScientific(short Q) {
        return ((dsITargetData)this.wrappedObject).toStringScientific(Q);
    }

    @Override
    public String toStringSignedInt() {
        return ((dsITargetData)this.wrappedObject).toStringSignedInt();
    }

    @Override
    public String toStringUnsignedInt() {
        return ((dsITargetData)this.wrappedObject).toStringUnsignedInt();
    }

    @Override
    public IDspValue typeCast(int nDspValueType, int nQValue) {
        return new DspValue(((dsITargetData)this.wrappedObject).typeCast((short)nDspValueType, nQValue));
    }

    @Override
    public IDspValue typeCast(IDspValue.Type type, int nQValue) {
        return new DspValue(((dsITargetData)this.wrappedObject).typeCast(DspValue.translateFromDspValueTypeEnum(type), nQValue));
    }

    @Override
    public void finalDispose() {
        this.disposeSingleWrappedInterface(this.wrappedObject);
    }

    dsITargetData getWrappedTargetData() {
        return (dsITargetData)this.wrappedObject;
    }

    @Override
    public String toStringReal() {
        return this.toStringReal((short)0);
    }

    @Override
    public String toStringScientific() {
        return this.toStringScientific((short)0);
    }

    @Override
    public String toStringTIStyleHex() {
        return ((dsITargetData)this.wrappedObject).toStringTIStyleHex();
    }

    @Override
    public String toStringBinary() {
        return ((dsITargetData)this.wrappedObject).toStringBinary();
    }

    @Override
    public long toUnsignedInt() {
        return ((dsITargetData)this.wrappedObject).toUnsignedInt();
    }

    @Override
    public void assign(IDspValue dspValue) {
        ((dsITargetData)this.wrappedObject).assign((dsITargetData)((DspValue)dspValue).getWrappedObject());
    }

    @Override
    public DspValue createClone() {
        return new DspValue((dsITargetData)this.wrappedObject.queryInterface("{3fa3a00a-0bb5-4ab7-8b83-bbc1ca049d6a}"));
    }

    @Override
    public void parseString(String value) {
        ((dsITargetData)this.wrappedObject).parseString(value);
    }
}

