/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICallFrame;
import com.ti.debug.engine.ICallStack;
import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IExpressionEvaluator;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.data.impl.ExpressionEvaluationData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.framework.Disposable;
import com.ti.debug.engine.impl.CallStack;
import com.ti.debug.engine.impl.Cancelable;
import com.ti.debug.engine.impl.DspUser;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectEventListenerOneTimeFilter;

class ExpressionEvaluator
extends Disposable
implements IExpressionEvaluator {
    private final DspUser dspUser;

    ExpressionEvaluator(DspUser dspUser) {
        this.dspUser = dspUser;
    }

    @Override
    public ICancelable requestEvaluation(String expression, IObjectEventListener<IExpressionEvaluationData> callback) {
        return this.requestEvaluation(expression, callback, true);
    }

    @Override
    public ICancelable requestEvaluation(String expression, IObjectEventListener<IExpressionEvaluationData> callback, boolean cancelOnRun) {
        return this.requestEvaluation(expression, callback, cancelOnRun, false);
    }

    ICancelable evaluateGELBuiltinAsAPI(String expression, final IStringEventListener callback) {
        IObjectEventListener<IExpressionEvaluationData> callbackAdapter = null;
        if (null != callback) {
            callbackAdapter = new IObjectEventListener<IExpressionEvaluationData>(){

                @Override
                public void onEvent(IExpressionEvaluationData data) {
                    callback.onEvent(data.getErrorMessage());
                }
            };
        }
        return this.requestEvaluation(expression, callbackAdapter, false, true);
    }

    static String convertFilenameForEval(String filename) {
        return filename.replace("\\", "\\\\");
    }

    private ICancelable requestEvaluation(final String expression, IObjectEventListener<IExpressionEvaluationData> callback, boolean cancelOnRun, boolean suppressProgress) {
        if (null == expression) {
            throw new NullPointerException("expression string must not be null");
        }
        ObjectEventListenerOneTimeFilter<IExpressionEvaluationData> listenerFilter = new ObjectEventListenerOneTimeFilter<IExpressionEvaluationData>(callback, this.dspUser.onCExprEvaluated(), new IFilterStrategy<IExpressionEvaluationData>(){

            @Override
            public boolean filter(IExpressionEvaluationData data) {
                return !data.getExpression().equals(expression) || data.hasFPandPC();
            }
        });
        try {
            Cancelable cancelable = new Cancelable(this.dspUser.wrappedExpressionEvaluation.requestCExprEval(expression, cancelOnRun, suppressProgress));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }

    @Override
    public ICancelable requestEvaluation(String expression, ICallStack.FrameInfo frameInfo, IObjectEventListener<IExpressionEvaluationData> callback) {
        return this.requestEvaluation(expression, frameInfo, callback, true);
    }

    @Override
    public ICancelable requestEvaluation(final String expression, ICallStack.FrameInfo frameInfo, IObjectEventListener<IExpressionEvaluationData> callback, boolean cancelOnRun) {
        final IDspValue fp = frameInfo.getFP();
        final IDspValue pc = frameInfo.getPC();
        if (null == expression) {
            throw new NullPointerException("expression string must not be null");
        }
        ObjectEventListenerOneTimeFilter<IExpressionEvaluationData> listenerFilter = new ObjectEventListenerOneTimeFilter<IExpressionEvaluationData>(callback, this.dspUser.onCExprEvaluated(), new IFilterStrategy<IExpressionEvaluationData>(){

            @Override
            public boolean filter(IExpressionEvaluationData dataInterface) {
                ExpressionEvaluationData data = (ExpressionEvaluationData)dataInterface;
                return !data.getExpression().equals(expression) || !data.hasFPandPC() || !data.getFP().equal(fp) || !data.getPC().equal(pc);
            }
        });
        try {
            Cancelable cancelable = new Cancelable(this.dspUser.wrappedExpressionEvaluation.requestCExprEvalOnStackFrame(expression, ((DspValue)fp).getWrappedTargetData(), ((DspValue)pc).getWrappedTargetData(), cancelOnRun));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }

    @Override
    public ICancelable requestEvaluation(String expression, ICallFrame frame, IObjectEventListener<IExpressionEvaluationData> callback) {
        return this.requestEvaluation(expression, frame, callback, true);
    }

    @Override
    public ICancelable requestEvaluation(final String expression, ICallFrame frame, IObjectEventListener<IExpressionEvaluationData> callback, boolean cancelOnRun) {
        final ICallStack stack = frame.getParent();
        final int level = frame.getLevel();
        if (null == expression) {
            throw new NullPointerException("expression string must not be null");
        }
        ObjectEventListenerOneTimeFilter<IExpressionEvaluationData> listenerFilter = new ObjectEventListenerOneTimeFilter<IExpressionEvaluationData>(callback, this.dspUser.onCExprEvaluated(), new IFilterStrategy<IExpressionEvaluationData>(){

            @Override
            public boolean filter(IExpressionEvaluationData dataInterface) {
                ExpressionEvaluationData data = (ExpressionEvaluationData)dataInterface;
                return !data.getExpression().equals(expression) || !data.matchCallFrame(stack, level);
            }
        });
        try {
            Cancelable cancelable = new Cancelable(this.dspUser.wrappedExpressionEvaluation.requestCExprEvalOnCallFrame(expression, ((CallStack)stack).getWrappedTargetData(), level, cancelOnRun));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }
}

