/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IFunctionInfo;
import com.ti.debug.engine.ILineInfo;
import com.ti.debug.engine.ILoopInfo;
import com.ti.debug.engine.ISectionInfo;
import com.ti.debug.engine.ISymbolInfo;
import com.ti.debug.engine.IType;
import com.ti.debug.engine.IValue;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.LineInfo;
import com.ti.debug.engine.impl.LoopInfo;
import com.ti.debug.engine.impl.SectionInfo;
import com.ti.debug.engine.impl.SourceFileName;
import com.ti.debug.engine.impl.SymbolInfo;
import com.ti.debug.engine.impl.Type;
import com.ti.debug.engine.impl.Value;
import com.ti.xpcom.interfaces.dsIFunctionInfo;
import com.ti.xpcom.interfaces.dsISymbolInfo;
import com.ti.xpcom.interfaces.dsIValue;

public class FunctionInfo
extends AComparableDisposable<dsIFunctionInfo>
implements IFunctionInfo {
    FunctionInfo(dsIFunctionInfo functionInfo) {
        super(functionInfo);
        this.wrappedObject = functionInfo;
    }

    @Override
    public String getCategory(int index) {
        return ((dsIFunctionInfo)this.wrappedObject).getCategory(index);
    }

    @Override
    public String getFileName() {
        return this.getFileFullName().getFileNameOnly();
    }

    @Override
    public String getFullFileName() {
        return this.getFileFullName().getFullPath();
    }

    @Override
    public ISymbolInfo getLocalInfo(int nLocalNum) {
        dsISymbolInfo[] symbolInfo = new dsISymbolInfo[]{null};
        ((dsIFunctionInfo)this.wrappedObject).getLocalInfo(nLocalNum, symbolInfo);
        return new SymbolInfo(symbolInfo[0]);
    }

    @Override
    public ISymbolInfo getLocalInfo(int nLocalNum, IDspValue addr) {
        DspValue pc = (DspValue)addr;
        dsISymbolInfo[] symbolInfo = new dsISymbolInfo[]{null};
        ((dsIFunctionInfo)this.wrappedObject).getLocalInfoByAddress(nLocalNum, pc.getWrappedTargetData(), symbolInfo);
        return new SymbolInfo(symbolInfo[0]);
    }

    @Override
    public IValue getLogicalStartAddress() {
        return new Value(((dsIFunctionInfo)this.wrappedObject).getLogicalStartAddress());
    }

    @Override
    public ILoopInfo getLoop(int index) {
        return new LoopInfo(((dsIFunctionInfo)this.wrappedObject).getLoop(index));
    }

    @Override
    public String getName() {
        return ((dsIFunctionInfo)this.wrappedObject).getName();
    }

    @Override
    public int getNumCategories() {
        return ((dsIFunctionInfo)this.wrappedObject).getNumCategories();
    }

    @Override
    public int getNumLocals() {
        return ((dsIFunctionInfo)this.wrappedObject).getNumLocals();
    }

    @Override
    public int getNumLocals(IDspValue addr) {
        DspValue pc = (DspValue)addr;
        return ((dsIFunctionInfo)this.wrappedObject).getNumLocalsByAddress(pc.getWrappedTargetData());
    }

    @Override
    public int getNumLoops() {
        return ((dsIFunctionInfo)this.wrappedObject).getNumLoops();
    }

    @Override
    public int getNumParameters() {
        return ((dsIFunctionInfo)this.wrappedObject).getNumParameters();
    }

    @Override
    public ISymbolInfo getParameter(int paramNum) {
        return new SymbolInfo(((dsIFunctionInfo)this.wrappedObject).getParameter(paramNum));
    }

    @Override
    public IValue getPhysicalStartAddress() {
        return new Value(((dsIFunctionInfo)this.wrappedObject).getPhysicalStartAddress());
    }

    @Override
    public String getReturnType() {
        return ((dsIFunctionInfo)this.wrappedObject).getReturnType();
    }

    @Override
    public IType getReturnType2() {
        return new Type(((dsIFunctionInfo)this.wrappedObject).getReturnType2());
    }

    @Override
    public ISectionInfo getSection() {
        return new SectionInfo(((dsIFunctionInfo)this.wrappedObject).getSection());
    }

    @Override
    public String getSignature() {
        return ((dsIFunctionInfo)this.wrappedObject).getSignature();
    }

    @Override
    public boolean isTrampoline() {
        return ((dsIFunctionInfo)this.wrappedObject).getIsTrampoline();
    }

    dsIFunctionInfo getWrappedFunctionInfo() {
        return (dsIFunctionInfo)this.wrappedObject;
    }

    @Override
    public int getEndLine() {
        return ((dsIFunctionInfo)this.wrappedObject).getEndLine();
    }

    @Override
    public IValue getPhysicalEndAddress() {
        dsIValue realValue = ((dsIFunctionInfo)this.wrappedObject).getPhysicalEndAddress();
        Value value = null;
        if (null != realValue) {
            value = new Value(realValue);
        }
        return value;
    }

    @Override
    public int getStartLine() {
        return ((dsIFunctionInfo)this.wrappedObject).getStartLine();
    }

    @Override
    public String getSymbolFileName() {
        return ((dsIFunctionInfo)this.wrappedObject).getSymbolFileName();
    }

    @Override
    public boolean findSourceLineByAddress(int addr, String[] fileName, int[] sourceLine) {
        return ((dsIFunctionInfo)this.wrappedObject).findSourceLineByAddress(addr, fileName, sourceLine);
    }

    @Override
    public boolean hasMinimalDebugInfo() {
        return ((dsIFunctionInfo)this.wrappedObject).getHasMinimalDebugInfo();
    }

    @Override
    public ILineInfo getStaticLineInfo() {
        return new LineInfo(((dsIFunctionInfo)this.wrappedObject).getStaticLineInfo());
    }

    @Override
    public SourceFileName getFileFullName() {
        return new SourceFileName(((dsIFunctionInfo)this.wrappedObject).getSourceFileName());
    }

    public String toString() {
        return this.getSignature();
    }
}

