/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IExpressionEvaluator;
import com.ti.debug.engine.events.data.IAccessEventData;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.events.impl.ObjectEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.impl.DspUser;
import com.ti.debug.engine.impl.MemoryAccess;
import com.ti.debug.engine.impl.RegisterAccess;

class LegacyDspUser
extends DspUser {
    private final IObjectEventListener<IMemoryAccessEventData> broadcastOnMemoryUpdate;
    private final IObjectEventListener<IRegisterAccessEventData> broadcastOnRegisterUpdate;
    private final IExpressionEvaluator expressionEvaluator;
    private final RegisterAccess registerAccess;
    private final MemoryAccess memoryAccess;
    private final ObjectEvent<IExpressionEvaluationData> onCExprEvaluatedEvent = new ObjectEvent();
    private final IObjectEventListener<IExpressionEvaluationData> onCExprEvaluatedEventAdapter = new IObjectEventListener<IExpressionEvaluationData>(){

        @Override
        public void onEvent(IExpressionEvaluationData data) {
            LegacyDspUser.this.onCExprEvaluatedEvent.fireEvent(data);
        }
    };
    private final ObjectEvent<IMemoryAccessEventData> onMemoryRequestCompleteEvent = new ObjectEvent();
    private final ObjectEvent<IMemoryAccessEventData> onMemoryUpdateEvent = new ObjectEvent();
    private final ObjectEvent<IRegisterAccessEventData> onRegisterRequestCompleteEvent = new ObjectEvent();
    private final ObjectEvent<IRegisterAccessEventData> onRegisterUpdateEvent = new ObjectEvent();
    private final IObjectEventListener<IMemoryAccessEventData> onMemoryEventAdapter = new DataEventRedirector<IMemoryAccessEventData>(this.onMemoryRequestCompleteEvent, this.onMemoryUpdateEvent);
    private final IObjectEventListener<IRegisterAccessEventData> onRegisterEventAdapter = new DataEventRedirector<IRegisterAccessEventData>(this.onRegisterRequestCompleteEvent, this.onRegisterUpdateEvent);

    LegacyDspUser(DspUser cachedDspUser, IExpressionEvaluator expressionEvaluator, RegisterAccess registerAccess, MemoryAccess memoryAccess) {
        super(cachedDspUser);
        this.expressionEvaluator = expressionEvaluator;
        this.registerAccess = registerAccess;
        this.memoryAccess = memoryAccess;
        this.broadcastOnMemoryUpdate = new BroadcastEventRedirector<IMemoryAccessEventData>(this.onMemoryUpdateEvent);
        cachedDspUser.onMemoryUpdate().addIObjectEventListener(this.broadcastOnMemoryUpdate);
        this.broadcastOnRegisterUpdate = new BroadcastEventRedirector<IRegisterAccessEventData>(this.onRegisterUpdateEvent);
        cachedDspUser.onRegisterUpdate().addIObjectEventListener(this.broadcastOnRegisterUpdate);
    }

    @Override
    public void requestCExprEval(String expr) {
        this.expressionEvaluator.requestEvaluation(expr, this.onCExprEvaluatedEventAdapter);
    }

    @Override
    public IObjectEvent<IExpressionEvaluationData> onCExprEvaluated() {
        return this.onCExprEvaluatedEvent;
    }

    @Override
    public void requestMemoryRead(IDspMemory mem, boolean broadcast, boolean removingDebugState) {
        this.memoryAccess.requestMemoryRead(mem, this.onMemoryEventAdapter, true);
    }

    @Override
    public void requestMemoryWrite(IDspMemory mem, boolean broadcast, boolean removingDebugState) {
        this.memoryAccess.requestMemoryWrite(mem, this.onMemoryEventAdapter);
    }

    @Override
    public void requestRegisterRead(IDspRegister reg, boolean broadcast, boolean removingDebugState) {
        this.registerAccess.requestRegisterRead(reg, this.onRegisterEventAdapter, true);
    }

    @Override
    public void requestRegisterWrite(IDspRegister reg, boolean broadcast, boolean removingDebugState) {
        this.registerAccess.requestRegisterWrite(reg, this.onRegisterEventAdapter);
    }

    @Override
    public IObjectEvent<IMemoryAccessEventData> onMemoryRequestComplete() {
        return this.onMemoryRequestCompleteEvent;
    }

    @Override
    public IObjectEvent<IMemoryAccessEventData> onMemoryUpdate() {
        return this.onMemoryUpdateEvent;
    }

    @Override
    public IObjectEvent<IRegisterAccessEventData> onRegisterRequestComplete() {
        return this.onRegisterRequestCompleteEvent;
    }

    @Override
    public IObjectEvent<IRegisterAccessEventData> onRegisterUpdate() {
        return this.onRegisterUpdateEvent;
    }

    private class DataEventRedirector<DataType extends IAccessEventData>
    extends BroadcastEventRedirector<DataType> {
        private final ObjectEvent<DataType> onRequestComplete;

        private DataEventRedirector(ObjectEvent<DataType> onRequestComplete, ObjectEvent<DataType> onUpdate) {
            super(onUpdate, false);
            this.onRequestComplete = onRequestComplete;
        }

        @Override
        public void onEvent(DataType data) {
            super.onEvent(data);
            this.onRequestComplete.fireEvent(data);
        }
    }

    private class BroadcastEventRedirector<DataType extends IAccessEventData>
    implements IObjectEventListener<DataType> {
        private final ObjectEvent<DataType> onUpdate;
        private final boolean redirectOnBroadcast;

        protected BroadcastEventRedirector(ObjectEvent<DataType> onUpdate, boolean redirectOnBroadcast) {
            this.onUpdate = onUpdate;
            this.redirectOnBroadcast = redirectOnBroadcast;
        }

        public BroadcastEventRedirector(ObjectEvent<DataType> onUpdate) {
            this.onUpdate = onUpdate;
            this.redirectOnBroadcast = true;
        }

        @Override
        public void onEvent(DataType data) {
            if (this.redirectOnBroadcast == data.isBroadcast()) {
                this.onUpdate.fireEvent(data);
            }
        }
    }
}

