/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ILineInfo;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.SourceFileName;
import com.ti.xpcom.interfaces.dsILineInfo;
import java.util.ArrayList;

public class LineInfo
extends AComparableDisposable<dsILineInfo>
implements ILineInfo {
    LineInfo(dsILineInfo lineInfo) {
        super(lineInfo);
    }

    @Override
    public long getBeginAddress(int nLineEntry) {
        return ((dsILineInfo)this.wrappedObject).getBeginAddress(nLineEntry);
    }

    @Override
    public int getLineNum(int nLineEntry) {
        return ((dsILineInfo)this.wrappedObject).getLineNum(nLineEntry);
    }

    @Override
    public int getNumLineEntries() {
        return ((dsILineInfo)this.wrappedObject).getNumLineEntries();
    }

    @Override
    public boolean lookupAddressByLine(int nLineNum, int[] nLineEntry) {
        return ((dsILineInfo)this.wrappedObject).lookupAddressByLine(nLineNum, nLineEntry);
    }

    @Override
    public boolean lookupAddressByLine(int nLineNum, String strFullFileName, int[] nLineEntry) {
        return ((dsILineInfo)this.wrappedObject).lookupAddressByLineAndFile(nLineNum, strFullFileName, nLineEntry);
    }

    @Override
    public int[] lookupAllAddressesByLine(int nLineNum, String strFullFileName) {
        long[] numEntries = new long[1];
        int[] entries = ((dsILineInfo)this.wrappedObject).lookupAddressesByLine(nLineNum, strFullFileName, numEntries);
        return entries == null ? new int[]{} : entries;
    }

    @Override
    public boolean lookupLineByAddress(long nAddress, int[] nLineEntry) {
        boolean bRetVal = ((dsILineInfo)this.wrappedObject).lookupLineByAddress(nAddress, nLineEntry);
        return bRetVal;
    }

    @Override
    public ILineInfo.BeginEndAddressPair[] getBeginEndAddressPair(int nLineNum) {
        ArrayList<ILineInfo.BeginEndAddressPair> ret = new ArrayList<ILineInfo.BeginEndAddressPair>();
        int nLineEntries = this.getNumLineEntries();
        for (int i = 0; i < nLineEntries; ++i) {
            int lineNum = this.getLineNum(i);
            if (nLineNum != lineNum) continue;
            ret.add(new ILineInfo.BeginEndAddressPair(this.getBeginAddress(i), this.getEndAddress(i)));
        }
        return ret.toArray(new ILineInfo.BeginEndAddressPair[0]);
    }

    @Override
    public long getEndAddress(int nLineEntry) {
        return ((dsILineInfo)this.wrappedObject).getEndAddress(nLineEntry);
    }

    @Override
    public String getFileName(int lineEntry) {
        return this.getFileFullName(lineEntry).getFullPath();
    }

    @Override
    public SourceFileName getFileFullName(int lineEntry) {
        return new SourceFileName(((dsILineInfo)this.wrappedObject).getSourceFileName(lineEntry));
    }
}

