/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IMemoryAccess;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.IRegisterAccess;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.framework.Disposable;
import com.ti.debug.engine.impl.Cancelable;
import com.ti.debug.engine.impl.DspMemory;
import com.ti.debug.engine.impl.DspRegister;
import com.ti.debug.engine.impl.DspUser;
import com.ti.debug.engine.impl.ExpressionEvaluator;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectEventListenerOneTimeFilter;
import com.ti.debug.engine.impl.Register;
import com.ti.xpcom.interfaces.dsIMemory;
import com.ti.xpcom.interfaces.dsIRegister;
import com.ti.xpcom.interfaces.dsIRegisterInfo;
import java.util.List;

public class MemoryAccess
extends Disposable
implements IMemoryAccess {
    private final DspUser dspUser;
    private final ExpressionEvaluator expressionEvaluator;
    private final IRegisterAccess registerAccess;

    MemoryAccess(DspUser dspUser, ExpressionEvaluator expressionEvaluator, IRegisterAccess registerAccess) {
        this.dspUser = dspUser;
        this.expressionEvaluator = expressionEvaluator;
        this.registerAccess = registerAccess;
    }

    @Override
    public IDspMemory createDspMemory(IDspValue startAddress, int length, short pageNumber) {
        return this.dspUser.createDspMemory(startAddress, length, pageNumber);
    }

    @Override
    public IDspMemory createDspMemory(IRegister register) {
        dsIMemory[] memory = new dsIMemory[1];
        dsIRegister[] reg = new dsIRegister[1];
        this.dspUser.wrappedMemoryAccess.createMemory2((dsIRegisterInfo)((Register)register).getWrappedObject(), memory, reg);
        return null != memory[0] ? new DspMemory(memory[0]) : new DspRegister(reg[0]);
    }

    @Override
    public IDspValue createDspValue(IDspValue.Type type, long initialValue) {
        return this.dspUser.createDspValue(type, initialValue);
    }

    @Override
    public ICancelable requestMemoryRead(IDspMemory mem, IObjectEventListener<IMemoryAccessEventData> callback) {
        return this.requestMemoryRead(mem, callback, true);
    }

    @Override
    public ICancelable requestMemoryRead(IDspMemory mem, IObjectEventListener<IMemoryAccessEventData> callback, boolean cancelOnRun) {
        return this.requestMemoryAccess(mem, callback, true, cancelOnRun);
    }

    @Override
    public ICancelable requestMemoryWrite(IDspMemory mem, IObjectEventListener<IMemoryAccessEventData> callback) {
        return this.requestMemoryAccess(mem, callback, false, false);
    }

    private ICancelable requestMemoryAccess(IDspMemory mem, IObjectEventListener<IMemoryAccessEventData> callback, boolean read, boolean cancelOnRun) {
        ICancelable cancelable = mem instanceof IDspRegister ? this.redirectRegisterAccess(mem, callback, read, cancelOnRun) : this.performMemoryAccess(mem, callback, read, cancelOnRun);
        return cancelable;
    }

    private ICancelable performMemoryAccess(final IDspMemory mem, IObjectEventListener<IMemoryAccessEventData> callback, boolean read, boolean cancelOnRun) {
        ObjectEventListenerOneTimeFilter<IMemoryAccessEventData> listenerFilter = new ObjectEventListenerOneTimeFilter<IMemoryAccessEventData>(callback, this.dspUser.onMemoryRequestComplete(), new IFilterStrategy<IMemoryAccessEventData>(){

            @Override
            public boolean filter(IMemoryAccessEventData data) {
                return !data.getMemory().equals(mem);
            }
        });
        try {
            dsIMemory memory = ((DspMemory)mem).getWrappedMemory();
            Cancelable cancelable = read ? new Cancelable(this.dspUser.wrappedMemoryAccess.requestMemoryRead(memory, cancelOnRun)) : new Cancelable(this.dspUser.wrappedMemoryAccess.requestMemoryWrite(memory));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }

    private ICancelable redirectRegisterAccess(IDspMemory mem, final IObjectEventListener<IMemoryAccessEventData> callback, boolean read, boolean cancelOnRun) {
        IObjectEventListener<IRegisterAccessEventData> adaptedCallback = new IObjectEventListener<IRegisterAccessEventData>(){

            @Override
            public void onEvent(IRegisterAccessEventData data) {
                if (null != callback) {
                    callback.onEvent(data);
                }
            }
        };
        if (read) {
            return this.registerAccess.requestRegisterRead((IDspRegister)mem, adaptedCallback, cancelOnRun);
        }
        return this.registerAccess.requestRegisterRead((IDspRegister)mem, adaptedCallback, cancelOnRun);
    }

    @Override
    public ICancelable requestMemoryFill(IDspValue address, int page, int length, IDspValue value, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemoryFill( " + address.toStringCStyleHex() + ", " + page + ", " + length + ", " + value.toStringCStyleHex() + ", " + value.getType() + " )");
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public ICancelable requestMemorySave(IDspValue address, int page, int length, String file, IMemoryAccess.FileFormat ioFormat, boolean append, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemorySave( " + address.toStringCStyleHex() + ", " + page + ", " + length + ", " + "\"" + file + "\", " + ioFormat.getValue() + ", " + (append ? "1 )" : "0 )"));
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public ICancelable requestMemorySaveCoff(IDspValue address, int page, int length, String file, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemorySave( " + address.toStringCStyleHex() + ", " + page + ", " + length + ", " + "\"" + file + "\", " + "5, )");
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public ICancelable requestMemorySaveRaw(IDspValue address, int page, int length, String file, int typeSize, boolean swapBytes, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemorySave( " + address.toStringCStyleHex() + ", " + page + ", " + length + ", " + "\"" + file + "\", " + "8, " + "0, " + typeSize + ", " + (swapBytes ? "1 )" : "0 )"));
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public ICancelable requestMemoryLoad(IDspValue address, int page, int length, String file, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemoryLoad( " + address.toStringCStyleHex() + ", " + page + ", " + length + ", " + "\"" + file + "\" )");
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public ICancelable requestMemoryLoadRaw(IDspValue address, int page, String file, int typeSize, boolean swapBytes, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemoryLoad( " + address.toStringCStyleHex() + ", " + page + ", " + "-1, " + "\"" + file + "\", " + typeSize + ", " + (swapBytes ? "1 )" : "0 )"));
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public ICancelable requestMemoryLoadData(IDspValue address, int page, int length, String file, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemoryLoadData( " + address.toStringCStyleHex() + ", " + page + ", " + length + ", " + "\"" + file + "\" ) ");
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public ICancelable requestMemorySaveData(IDspValue address, int page, int length, String file, int format, boolean append, IStringEventListener callback) {
        String gelFunction = new String("GEL_MemorySaveData( " + address.toStringCStyleHex() + ", " + page + ", " + length + ", " + "\"" + file + "\", " + format + ", " + (append ? "1 )" : "0 )"));
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelFunction, callback);
    }

    @Override
    public List<IDspValue.SupportedType> getSupportedTypes(int page) {
        IDspValue value = this.createDspValue(IDspValue.Type.DATA32, 0L);
        return value.getSupportedTypes((short)page);
    }
}

