/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IExecObj;
import com.ti.debug.engine.IOSAwareManager;
import com.ti.debug.engine.IOSObj;
import com.ti.debug.engine.IOSObjNodeInfo;
import com.ti.debug.engine.IOSObjPropInfo;
import com.ti.debug.engine.IOSObject;
import com.ti.debug.engine.IOSObjects;
import com.ti.debug.engine.events.impl.ManagedBooleanEvent;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.types.IBooleanEvent;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.ExecObj;
import com.ti.debug.engine.impl.OSObject;
import com.ti.debug.engine.impl.OSObjects;
import com.ti.xpcom.interfaces.dsIOSAwareManager;
import com.ti.xpcom.interfaces.dsIOSAwareManagerEvents;
import com.ti.xpcom.interfaces.dsIOSObject;
import java.util.Vector;

public class OSAwareManager
extends AComparableDisposable<dsIOSAwareManager>
implements IOSAwareManager {
    private Vector<String> drivers = new Vector();
    private int selectedDriver = 0;
    private dsIOSAwareManagerEvents wrappedOSAwareManagerEvents;
    private ManagedBooleanEvent managedonOnOSAwareDebugEnabled;
    private ManagedBooleanEvent managedonOnOSAwareDebugEnabledFailed;
    private ManagedSimpleEvent managedOnOSObjectRefresh;

    OSAwareManager(dsIOSAwareManager oSAwareManager) {
        super(oSAwareManager);
        this.wrappedOSAwareManagerEvents = (dsIOSAwareManagerEvents)oSAwareManager.queryInterface("{04e0f514-3356-48dc-9e11-854c92d2acfd}");
        this.managedonOnOSAwareDebugEnabled = new ManagedBooleanEvent(this.wrappedOSAwareManagerEvents.onOSAwareDebugEnabled());
        this.managedonOnOSAwareDebugEnabledFailed = new ManagedBooleanEvent(this.wrappedOSAwareManagerEvents.onOSAwareDebugEnabledFailed());
        this.managedOnOSObjectRefresh = new ManagedSimpleEvent(this.wrappedOSAwareManagerEvents.onOSObjectRefresh());
    }

    @Override
    public void addDriver(String path) {
        if (!this.drivers.contains(path)) {
            this.drivers.add(path);
        }
    }

    private IOSObject FindOSObjectByIdentifier(IOSObjects osObjects, int uniqueIdentifier) {
        int size = osObjects.getCount();
        for (int i = 0; i < size; ++i) {
            IOSObject osObject = osObjects.getItem(i);
            if (osObject.getUniqueIdentifier() == uniqueIdentifier) {
                return osObject;
            }
            IOSObjects children = osObject.getChildOSObjects();
            IOSObject child = this.FindOSObjectByIdentifier(children, uniqueIdentifier);
            if (null == child) continue;
            return child;
        }
        return null;
    }

    @Override
    public IExecObj createExecObjFromHandle(int handle) {
        IOSObjects executionObjects = this.getExecutionObjects();
        IOSObject osObject = this.FindOSObjectByIdentifier(executionObjects, handle);
        ExecObj toReturn = new ExecObj((dsIOSObject)((dsIOSObject)((OSObject)osObject).getWrappedObject()).queryInterface("{a58e1a0a-de06-422f-b673-67cb34f3e9bb}"));
        return toReturn;
    }

    @Override
    public IOSObj createOSObjFromHandle(int handle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableTaskLevelDebug() {
        ((dsIOSAwareManager)this.wrappedObject).disableOSAwareDebug();
    }

    @Override
    public void enableTaskLevelDebug(int driverIndex) {
        this.enableTaskLevelDebug(this.drivers.get(driverIndex));
    }

    @Override
    public int getCurrentExecObjHandle() {
        IOSObject object = this.getCurrentExecutionObject();
        int handle = 0;
        if (null != object) {
            handle = object.getUniqueIdentifier();
        }
        return handle;
    }

    @Override
    public int getExecObjHandle(int index) {
        IOSObjects OSObjects2 = this.getExecutionObjects();
        IOSObject OSObject2 = OSObjects2.getItem(index);
        int handle = OSObject2.getUniqueIdentifier();
        return handle;
    }

    @Override
    public int getNumExecObj() {
        IOSObjects objects = this.getExecutionObjects();
        int count = objects.getCount();
        return count;
    }

    @Override
    public int getNumOSDrivers() {
        return this.drivers.size();
    }

    @Override
    public int getNumOSObj() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOSDriverInfo(int driverIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOSDriverName(int driverIndex) {
        return this.drivers.get(driverIndex);
    }

    @Override
    public int getOSObjHandle(long handleIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IOSObjNodeInfo getOSObjNodeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IOSObjPropInfo getOSObjProperty(int propertyIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getResourcePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSelectedOSDriver() {
        return this.selectedDriver;
    }

    @Override
    public void enableTaskLevelDebug(String driverName) {
        ((dsIOSAwareManager)this.wrappedObject).enableOSAwareDebug(driverName);
    }

    @Override
    public boolean isTaskLevelDebugEnabled() {
        return ((dsIOSAwareManager)this.wrappedObject).getIsOSAwareDebugEnabled();
    }

    @Override
    public String getOSName() {
        return ((dsIOSAwareManager)this.wrappedObject).getOSName();
    }

    @Override
    public IOSObjects getExecutionObjects() {
        return new OSObjects(((dsIOSAwareManager)this.wrappedObject).getExecutionObjects());
    }

    @Override
    public IOSObject getCurrentExecutionObject() {
        OSObject object = null;
        if (((dsIOSAwareManager)this.wrappedObject).getHasCurrentExecutionObject()) {
            object = new OSObject(((dsIOSAwareManager)this.wrappedObject).getCurrentExecutionObject());
        }
        return object;
    }

    @Override
    public void setSelectedOSDriver(int driverIndex) {
        this.selectedDriver = driverIndex;
    }

    @Override
    public IBooleanEvent onOSAwareDebugEnabled() {
        return this.managedonOnOSAwareDebugEnabled;
    }

    @Override
    public IBooleanEvent onOSAwareDebugEnabledFailed() {
        return this.managedonOnOSAwareDebugEnabledFailed;
    }

    @Override
    public ISimpleEvent onOSObjectRefresh() {
        return this.managedOnOSObjectRefresh;
    }

    @Override
    public boolean allowUserToModify() {
        return ((dsIOSAwareManager)this.wrappedObject).allowUserToModify();
    }
}

