/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.impl.IFilterStrategy;
import java.util.HashSet;
import java.util.Set;

class ObjectEventListenerOneTimeFilter<DataType>
implements IObjectEventListener<DataType> {
    private final IObjectEventListener<DataType> listenerToFilter;
    private final IObjectEvent<DataType> event;
    private final IFilterStrategy<DataType> strategy;
    private static final Set<Object> references = new HashSet<Object>();

    ObjectEventListenerOneTimeFilter(IObjectEventListener<DataType> listenerToFilter, IObjectEvent<DataType> event, IFilterStrategy<DataType> strategy) {
        this.listenerToFilter = listenerToFilter;
        this.event = event;
        this.strategy = strategy;
        if (null != listenerToFilter) {
            references.add(this);
            event.addIObjectEventListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(DataType data) {
        if (!this.strategy.filter(data)) {
            try {
                this.listenerToFilter.onEvent(data);
            }
            finally {
                this.unregister();
            }
        }
    }

    void unregister() {
        references.remove(this);
        this.event.removeIObjectEventListener(this);
    }
}

