/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IPhysicalMappingLookup;
import com.ti.debug.engine.events.data.IPhysicalMappingEventData;
import com.ti.debug.engine.events.data.impl.PhysicalMappingEventData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.tcl.IPhysicalMappingLookupEvents;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.Cancelable;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectEventListenerOneTimeFilter;
import com.ti.debug.engine.xpcom.event.impl.PhysicalMappingDataTranslator;
import com.ti.xpcom.interfaces.dsIPhysicalMappingLookup;
import com.ti.xpcom.interfaces.dsITargetData;

class PhysicalMappingLookup
extends AComparableDisposable<dsIPhysicalMappingLookup>
implements IPhysicalMappingLookup,
IPhysicalMappingLookupEvents {
    private final IObjectEvent<IPhysicalMappingEventData> onPhysicalMappingRetrieved;

    PhysicalMappingLookup(dsIPhysicalMappingLookup object) {
        super(object);
        this.onPhysicalMappingRetrieved = new ManagedObjectEvent<IPhysicalMappingEventData>(((dsIPhysicalMappingLookup)this.wrappedObject).onPhysicalMappingRetrieved(), new PhysicalMappingDataTranslator());
    }

    @Override
    public boolean allowUserToPerform() {
        return ((dsIPhysicalMappingLookup)this.wrappedObject).allowUserToPerform();
    }

    @Override
    public boolean isTargetCapable() {
        return ((dsIPhysicalMappingLookup)this.wrappedObject).isTargetCapable();
    }

    @Override
    public ICancelable requestPhysicalMapping(final IDspValue virtualAddress, int page, IObjectEventListener<IPhysicalMappingEventData> callback) {
        ObjectEventListenerOneTimeFilter<IPhysicalMappingEventData> listenerFilter = new ObjectEventListenerOneTimeFilter<IPhysicalMappingEventData>(callback, this.onPhysicalMappingRetrieved(), new IFilterStrategy<IPhysicalMappingEventData>(){

            @Override
            public boolean filter(IPhysicalMappingEventData data) {
                return ((PhysicalMappingEventData)data).getVirtualAddress().equal(virtualAddress);
            }
        });
        try {
            dsITargetData address = ((DspValue)virtualAddress).getWrappedTargetData();
            Cancelable cancelable = new Cancelable(((dsIPhysicalMappingLookup)this.wrappedObject).requestPhysicalMapping(address, page));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }

    @Override
    public IObjectEvent<IPhysicalMappingEventData> onPhysicalMappingRetrieved() {
        return this.onPhysicalMappingRetrieved;
    }
}

