/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IProcessorInfo;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.xpcom.interfaces.dsIProcessorInfo;

public class ProcessorInfo
extends AComparableDisposable<dsIProcessorInfo>
implements IProcessorInfo {
    private int processorID;
    private int targetFamilyID;
    private int targetRev;
    private int targetSubFamilyID;
    private int targetType;
    private boolean cached = false;

    public ProcessorInfo(dsIProcessorInfo object) {
        super(object);
    }

    private void cacheIfNeeded() {
        if (!this.cached) {
            this.cache();
        }
    }

    private void cache() {
        int[] processorIDArray = new int[1];
        int[] targetFamilyIDArray = new int[1];
        int[] targetRevArray = new int[1];
        int[] targetSubFamilyIDArray = new int[1];
        int[] targetTypeArray = new int[1];
        boolean safeToCache = ((dsIProcessorInfo)this.wrappedObject).getProcessorInfo(targetFamilyIDArray, targetSubFamilyIDArray, targetRevArray, targetTypeArray, processorIDArray);
        this.processorID = processorIDArray[0];
        this.targetFamilyID = targetFamilyIDArray[0];
        this.targetRev = targetRevArray[0];
        this.targetSubFamilyID = targetSubFamilyIDArray[0];
        this.targetType = targetTypeArray[0];
        this.cached = safeToCache;
    }

    @Override
    public int getProcessorID() {
        this.cacheIfNeeded();
        return this.processorID;
    }

    @Override
    public int getTargetFamilyID() {
        this.cacheIfNeeded();
        return this.targetFamilyID;
    }

    @Override
    public int getTargetRev() {
        this.cacheIfNeeded();
        return this.targetRev;
    }

    @Override
    public int getTargetSubFamilyID() {
        this.cacheIfNeeded();
        return this.targetSubFamilyID;
    }

    @Override
    public int getTargetType() {
        this.cacheIfNeeded();
        return this.targetType;
    }

    @Override
    protected void finalDispose() {
        this.disposeSingleWrappedInterface(this.wrappedObject);
    }
}

