/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.IProfProperties;
import com.ti.debug.engine.events.data.IProfCollectionEventData;
import com.ti.debug.engine.events.data.IProfStatusEventData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.ProfProperties;
import com.ti.debug.engine.xpcom.event.impl.ProfCollectionEventDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.ProfStatusEventDataTranslator;
import com.ti.xpcom.interfaces.dsIProfCollector;
import com.ti.xpcom.interfaces.dsIProfCollectorEvents;
import com.ti.xpcom.interfaces.dsIProfProperties;

public class ProfCollector
extends AComparableDisposable<dsIProfCollector>
implements IProfCollector {
    private dsIProfCollectorEvents wrappedProfCollectorEvents;
    private ManagedObjectEvent<IProfStatusEventData> managedOnStatusChanging;
    private ManagedObjectEvent<IProfStatusEventData> managedOnStatusChanged;
    private ManagedObjectEvent<IProfCollectionEventData> managedOnEventChange;
    private ManagedObjectEvent<IProfCollectionEventData> managedOnRangeChange;
    private ManagedSimpleEvent managedOnControlChange;

    ProfCollector(dsIProfCollector collector) {
        super(collector);
        this.wrappedProfCollectorEvents = (dsIProfCollectorEvents)((dsIProfCollector)this.wrappedObject).queryInterface("{a15647b7-6dd4-4eb3-9726-8c8f273cd189}");
        this.managedOnStatusChanging = new ManagedObjectEvent<IProfStatusEventData>(this.wrappedProfCollectorEvents.onStatusChanging(), new ProfStatusEventDataTranslator());
        this.managedOnStatusChanged = new ManagedObjectEvent<IProfStatusEventData>(this.wrappedProfCollectorEvents.onStatusChanged(), new ProfStatusEventDataTranslator());
        this.managedOnEventChange = new ManagedObjectEvent<IProfCollectionEventData>(this.wrappedProfCollectorEvents.onEventChange(), new ProfCollectionEventDataTranslator());
        this.managedOnRangeChange = new ManagedObjectEvent<IProfCollectionEventData>(this.wrappedProfCollectorEvents.onRangeChange(), new ProfCollectionEventDataTranslator());
        this.managedOnControlChange = new ManagedSimpleEvent(this.wrappedProfCollectorEvents.onControlChange());
    }

    private IProfCollectorServer.CollectorServerException generateCollectorException(int errorCode) {
        int[] callStatus = new int[1];
        String strErrorMessage = ((dsIProfCollector)this.wrappedObject).errorStringFromError(errorCode, callStatus);
        if (callStatus[0] != 0) {
            strErrorMessage = "Exception in CollectorServer but unable to extract specific reason";
        }
        return new IProfCollectorServer.CollectorServerException(strErrorMessage);
    }

    private String[] profileEventListToStrings(IProfCollector.ProfileEvent[] profileEventList) {
        if (profileEventList.length == 0) {
            return new String[0];
        }
        String[] returnList = new String[profileEventList.length];
        for (int i = 0; i < profileEventList.length; ++i) {
            returnList[i] = profileEventList[i].getEventName() + "," + profileEventList[i].getDatatypeName();
        }
        return returnList;
    }

    private IProfCollector.ProfileEvent[] profileEventStringsToProfileEventList(String[] eventStringList) {
        if (eventStringList.length == 0) {
            return new IProfCollector.ProfileEvent[0];
        }
        IProfCollector.ProfileEvent[] returnList = new IProfCollector.ProfileEvent[eventStringList.length];
        for (int i = 0; i < eventStringList.length; ++i) {
            String[] splitName = eventStringList[i].split(",");
            assert (splitName.length == 2);
            returnList[i] = new IProfCollector.ProfileEvent(splitName[1], splitName[0]);
        }
        return returnList;
    }

    private void validateAction(short action) throws IProfCollectorServer.CollectorServerException {
        if (action < 0 || action > 9) {
            throw new IProfCollectorServer.CollectorServerException("Invalid action specified for modify operation");
        }
    }

    @Override
    public int getCollectorStatus() throws IProfCollectorServer.CollectorServerException {
        int[] callStatus = new int[1];
        int collectorStatus = 0;
        collectorStatus = ((dsIProfCollector)this.wrappedObject).status(callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
        return collectorStatus;
    }

    @Override
    public IProfProperties getProperties() throws IProfCollectorServer.CollectorServerException {
        int[] callStatus = new int[1];
        dsIProfProperties holdProps = ((dsIProfCollector)this.wrappedObject).properties(callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
        return new ProfProperties(holdProps);
    }

    @Override
    public void enableProfiling(boolean bEnable) throws IProfCollectorServer.CollectorServerException {
        int[] callStatus = new int[1];
        ((dsIProfCollector)this.wrappedObject).enable(bEnable, callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
    }

    @Override
    public void endProfiling() throws IProfCollectorServer.CollectorServerException {
        int[] callStatus = new int[1];
        ((dsIProfCollector)this.wrappedObject).end(callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
    }

    @Override
    public boolean isProfileEventSetValid(IProfCollector.ProfileEvent[] eventList) throws IProfCollectorServer.CollectorServerException {
        int[] callStatus = new int[1];
        String[] stringEvents = this.profileEventListToStrings(eventList);
        boolean bIsValid = ((dsIProfCollector)this.wrappedObject).isProfileEventSetValid(stringEvents.length, stringEvents, callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
        return bIsValid;
    }

    @Override
    public IProfCollector.ProfileEvent[] getProfileEvents() throws IProfCollectorServer.CollectorServerException {
        long[] arrayCount = new long[1];
        int[] callStatus = new int[1];
        String[][] stringEventList = new String[1][0];
        ((dsIProfCollector)this.wrappedObject).profileEvents(callStatus, arrayCount, stringEventList);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
        if (stringEventList != null && stringEventList.length > 0) {
            return this.profileEventStringsToProfileEventList(stringEventList[0]);
        }
        return new IProfCollector.ProfileEvent[0];
    }

    @Override
    public void modifyProfileEvents(short action, IProfCollector.ProfileEvent[] eventList) throws IProfCollectorServer.CollectorServerException {
        this.validateAction(action);
        int[] callStatus = new int[1];
        String[] stringEvents = this.profileEventListToStrings(eventList);
        ((dsIProfCollector)this.wrappedObject).modifyProfileEvents(action, stringEvents.length, stringEvents, callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
    }

    @Override
    public String[] getProfileRanges(String datatype) throws IProfCollectorServer.CollectorServerException {
        int[] callStatus = new int[1];
        long[] arrayCount = new long[1];
        String[][] ranges = null;
        ((dsIProfCollector)this.wrappedObject).ranges(datatype, callStatus, arrayCount, ranges);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
        return ranges != null && ranges.length > 0 ? ranges[0] : new String[]{};
    }

    @Override
    public void modifyProfileRanges(String datatype, short action, String[] rangeList) throws IProfCollectorServer.CollectorServerException {
        this.validateAction(action);
        int[] callStatus = new int[1];
        ((dsIProfCollector)this.wrappedObject).modifyRanges(datatype, action, rangeList.length, rangeList, callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
    }

    @Override
    public String[] getControlPoints() throws IProfCollectorServer.CollectorServerException {
        int[] callStatus = new int[1];
        long[] arrayCount = new long[1];
        String[][] controlPoints = null;
        ((dsIProfCollector)this.wrappedObject).controlEvents(callStatus, arrayCount, controlPoints);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
        return controlPoints != null && controlPoints.length > 0 ? controlPoints[0] : new String[]{};
    }

    @Override
    public void modifyControlPoints(short action, String[] controlList) throws IProfCollectorServer.CollectorServerException {
        this.validateAction(action);
        int[] callStatus = new int[1];
        ((dsIProfCollector)this.wrappedObject).modifyControlEvents(action, controlList.length, controlList, callStatus);
        if (callStatus[0] != 0) {
            throw this.generateCollectorException(callStatus[0]);
        }
    }

    @Override
    public void saveProfileConfiguration(String fileName) throws IProfCollectorServer.CollectorServerException {
        String[] strError = new String[1];
        ((dsIProfCollector)this.wrappedObject).saveProfileConfiguration(fileName, strError);
        if (strError[0] != "") {
            throw new IProfCollectorServer.CollectorServerException(strError[0]);
        }
    }

    @Override
    public void loadProfileConfiguration(String fileName) throws IProfCollectorServer.CollectorServerException {
        String[] strError = new String[1];
        ((dsIProfCollector)this.wrappedObject).loadProfileConfiguration(fileName, strError);
        if (strError[0] != "") {
            throw new IProfCollectorServer.CollectorServerException(strError[0]);
        }
    }

    @Override
    public IObjectEvent<IProfStatusEventData> onStatusChanging() {
        return this.managedOnStatusChanging;
    }

    @Override
    public IObjectEvent<IProfStatusEventData> onStatusChanged() {
        return this.managedOnStatusChanged;
    }

    @Override
    public IObjectEvent<IProfCollectionEventData> onEventChange() {
        return this.managedOnEventChange;
    }

    @Override
    public IObjectEvent<IProfCollectionEventData> onRangeChange() {
        return this.managedOnRangeChange;
    }

    @Override
    public ISimpleEvent onControlChange() {
        return this.managedOnControlChange;
    }

    @Override
    public void triggerControlPoint(IProfCollector.ProfileControlPointType ctrlptType) throws IProfCollectorServer.CollectorServerException {
        boolean[] success = new boolean[1];
        short dsiCtrlPtValue = 0;
        switch (ctrlptType) {
            case EXIT_POINT: {
                dsiCtrlPtValue = 2;
                break;
            }
            case RESUME_POINT: {
                dsiCtrlPtValue = 0;
                break;
            }
            case HALT_POINT: {
                dsiCtrlPtValue = 1;
            }
        }
        ((dsIProfCollector)this.wrappedObject).triggerControlEvent(dsiCtrlPtValue, success);
        if (!success[0]) {
            throw new IProfCollectorServer.CollectorServerException("Unable to trigger Control Point event");
        }
    }

    @Override
    public String[] getErrorStringStack() {
        String[][] error_string_stack = new String[1][0];
        int[] status = new int[1];
        long[] length = new long[1];
        ((dsIProfCollector)this.wrappedObject).getErrorString(status, length, error_string_stack);
        return error_string_stack[0];
    }
}

