/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IProfProperties;
import com.ti.debug.engine.events.data.IProfPropertiesEventData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.xpcom.event.impl.ProfPropertiesEventDataTranslator;
import com.ti.xpcom.interfaces.dsIProfProperties;
import com.ti.xpcom.interfaces.dsIProfPropertiesEvent;

public class ProfProperties
extends AComparableDisposable<dsIProfProperties>
implements IProfProperties {
    private dsIProfPropertiesEvent wrappedProfPropertiesEvent;
    private ManagedObjectEvent<IProfPropertiesEventData> managedOnPropertyChange;

    ProfProperties(dsIProfProperties props) {
        super(props);
        this.wrappedProfPropertiesEvent = (dsIProfPropertiesEvent)((dsIProfProperties)this.wrappedObject).queryInterface("{4aac3c39-88a6-4b8b-b562-4ae466bd8543}");
        this.managedOnPropertyChange = new ManagedObjectEvent<IProfPropertiesEventData>(this.wrappedProfPropertiesEvent.onPropertyChange(), new ProfPropertiesEventDataTranslator());
    }

    private IProfProperties.ProfPropertiesException generatePropertiesException(int errorCode) {
        String[] strErrorMessage = new String[1];
        if (((dsIProfProperties)this.wrappedObject).getErrorString(errorCode, strErrorMessage) != 0 || strErrorMessage[0].length() == 0) {
            strErrorMessage[0] = "Exception during Properties operation but unable to extract specific reason";
        }
        return new IProfProperties.ProfPropertiesException(strErrorMessage[0]);
    }

    private IProfProperties.PropertyKeyValuePair[] StringsToKeyValuePairs(String[] toConvert) {
        if (toConvert == null || toConvert.length == 0) {
            return new IProfProperties.PropertyKeyValuePair[0];
        }
        IProfProperties.PropertyKeyValuePair[] toReturn = new IProfProperties.PropertyKeyValuePair[toConvert.length / 2];
        for (int i = 0; i < toConvert.length / 2; ++i) {
            toReturn[i] = new IProfProperties.PropertyKeyValuePair(toConvert[i * 2], toConvert[i * 2 + 1]);
        }
        return toReturn;
    }

    private String[] KeyValuePairsToStrings(IProfProperties.PropertyKeyValuePair[] toConvert) {
        if (toConvert == null || toConvert.length == 0) {
            return new String[0];
        }
        String[] toReturn = new String[toConvert.length * 2];
        for (int i = 0; i < toConvert.length; ++i) {
            toReturn[i * 2] = toConvert[i].getPropertyKeyName();
            toReturn[i * 2 + 1] = toConvert[i].getPropertyValue();
        }
        return toReturn;
    }

    @Override
    public IProfProperties.PropertyKeyValuePair[] readProperty(String nodeName, short infoType) throws IProfProperties.ProfPropertiesException {
        if (!IProfProperties.PropertyInfoType.IsValidType(infoType)) {
            throw new IProfProperties.ProfPropertiesException("Invalid Property information type request");
        }
        long[] arrayCount = new long[1];
        String[][] resultList = new String[1][0];
        int callStatus = ((dsIProfProperties)this.wrappedObject).readProperty(nodeName, infoType, arrayCount, resultList);
        if (callStatus != 0) {
            throw this.generatePropertiesException(callStatus);
        }
        return this.StringsToKeyValuePairs(resultList[0]);
    }

    @Override
    public void setProperty(String nodeName, short infoType, IProfProperties.PropertyKeyValuePair[] propList) throws IProfProperties.ProfPropertiesException {
        if (!IProfProperties.PropertyInfoType.IsValidType(infoType)) {
            throw new IProfProperties.ProfPropertiesException("Invalid Property information type request");
        }
        String[] strProps = this.KeyValuePairsToStrings(propList);
        int callStatus = ((dsIProfProperties)this.wrappedObject).setProperty(nodeName, infoType, strProps.length, strProps);
        if (callStatus != 0) {
            throw this.generatePropertiesException(callStatus);
        }
    }

    @Override
    public int propertyActionCount(String sParentNodeName, int nAction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readPropertyAction(String sParentNodeName, int nAction, int nIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IObjectEvent<IProfPropertiesEventData> onPropertyChange() {
        return this.managedOnPropertyChange;
    }
}

