/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IProfileClockManager;
import com.ti.debug.engine.events.IServerListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.FunctionResultCache;
import com.ti.xpcom.interfaces.dsIProfileClockManager;
import java.util.ArrayList;
import java.util.List;

public class ProfileClockManager
extends AComparableDisposable<dsIProfileClockManager>
implements IProfileClockManager {
    protected IDspTask task;
    protected EventsListCache cache;

    ProfileClockManager(dsIProfileClockManager profileClockManager, IDspTask cpu) {
        super(profileClockManager);
        this.task = cpu;
        this.cache = new EventsListCache(){

            @Override
            protected List<String> fetchUncachedValue() {
                return ProfileClockManager.this.updateCache();
            }
        };
    }

    private List<String> updateCache() {
        ArrayList<String> retList = new ArrayList<String>();
        String[] fstrHoldAllEvents = null;
        long[] eventCount = new long[]{0L};
        for (String s : fstrHoldAllEvents = ((dsIProfileClockManager)this.wrappedObject).getClockEventNames(eventCount)) {
            retList.add(s);
        }
        return retList;
    }

    @Override
    public String[] getClockEvents() {
        List eventsList = (List)this.cache.fetch();
        String[] ret = eventsList.toArray(new String[eventsList.size()]);
        return ret;
    }

    @Override
    public int getNumClockEvents() {
        List eventsList = (List)this.cache.fetch();
        return eventsList.size();
    }

    @Override
    public void enableClock(boolean enable) {
        ((dsIProfileClockManager)this.wrappedObject).enableClock(enable);
    }

    @Override
    public int getCurrentClockEvent() {
        int[] iHoldCurrentEvent = new int[]{0};
        ((dsIProfileClockManager)this.wrappedObject).getCurrentClockEvent(iHoldCurrentEvent);
        return iHoldCurrentEvent[0];
    }

    @Override
    public boolean getClockEnabled() {
        boolean[] bHoldEnabled = new boolean[]{false};
        ((dsIProfileClockManager)this.wrappedObject).getClockEnabled(bHoldEnabled);
        return bHoldEnabled[0];
    }

    @Override
    public boolean getIsClockAutoReset() {
        boolean[] bHoldAutoReset = new boolean[]{false};
        ((dsIProfileClockManager)this.wrappedObject).getAutoResetClock(bHoldAutoReset);
        return bHoldAutoReset[0];
    }

    @Override
    public void resetClock() {
        ((dsIProfileClockManager)this.wrappedObject).resetClock();
    }

    @Override
    public boolean setCurrentClockEvent(int clockEventID) {
        return ((dsIProfileClockManager)this.wrappedObject).setCurrentClockEvent(clockEventID);
    }

    @Override
    public void setIsClockAutoReset(boolean autoReset) {
        ((dsIProfileClockManager)this.wrappedObject).setAutoResetClock(autoReset);
    }

    @Override
    public long readClockCount() {
        long[] lClockCount = new long[]{0L};
        ((dsIProfileClockManager)this.wrappedObject).readClockCount(lClockCount);
        return lClockCount[0];
    }

    public void addListener(IServerListener listener, int interfaceId, int eventId) {
        throw new UnsupportedOperationException();
    }

    private abstract class EventsListCache
    extends FunctionResultCache<List<String>> {
        EventsListCache() {
            this.InvalidateOn(ProfileClockManager.this.task.getTargetConnection().onConnected());
        }
    }
}

