/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ITransaction;
import com.ti.debug.engine.framework.Disposable;
import com.ti.debug.engine.impl.DspUser;

public class RefreshTransaction
extends Disposable
implements ITransaction {
    private DspUser user;
    private int count = 1;

    RefreshTransaction(DspUser user) {
        this.user = user;
    }

    @Override
    public synchronized void acquire() {
        ++this.count;
    }

    @Override
    public synchronized void dispose() {
        --this.count;
        if (0 == this.count) {
            this.endRefresh();
        }
    }

    private void endRefresh() {
        if (null != this.user) {
            this.user.endRefresh();
            this.user = null;
        }
    }

    protected void finalize() throws Throwable {
        this.endRefresh();
        super.finalize();
    }
}

