/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IRegisterAccess;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.framework.Disposable;
import com.ti.debug.engine.impl.Cancelable;
import com.ti.debug.engine.impl.DspRegister;
import com.ti.debug.engine.impl.DspUser;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectEventListenerOneTimeFilter;
import com.ti.xpcom.interfaces.dsIRegister;

public class RegisterAccess
extends Disposable
implements IRegisterAccess {
    private final DspUser dspUser;

    RegisterAccess(DspUser dspUser) {
        this.dspUser = dspUser;
    }

    @Override
    public IDspRegister createDspRegister(int startRegisterID) {
        return this.dspUser.createDspRegister(startRegisterID);
    }

    @Override
    public ICancelable requestRegisterRead(IDspRegister reg, IObjectEventListener<IRegisterAccessEventData> callback) {
        return this.requestRegisterRead(reg, callback, true);
    }

    @Override
    public ICancelable requestRegisterRead(IDspRegister reg, IObjectEventListener<IRegisterAccessEventData> callback, boolean cancelOnRun) {
        return this.requestRegisterAccess(reg, callback, true, cancelOnRun);
    }

    @Override
    public ICancelable requestRegisterWrite(IDspRegister reg, IObjectEventListener<IRegisterAccessEventData> callback) {
        return this.requestRegisterAccess(reg, callback, false, false);
    }

    private ICancelable requestRegisterAccess(final IDspRegister reg, IObjectEventListener<IRegisterAccessEventData> callback, boolean read, boolean cancelOnRun) {
        ObjectEventListenerOneTimeFilter<IRegisterAccessEventData> listenerFilter = new ObjectEventListenerOneTimeFilter<IRegisterAccessEventData>(callback, this.dspUser.onRegisterRequestComplete(), new IFilterStrategy<IRegisterAccessEventData>(){

            @Override
            public boolean filter(IRegisterAccessEventData data) {
                return !data.getRegister().equals(reg);
            }
        });
        try {
            dsIRegister register = ((DspRegister)reg).getWrappedRegister();
            Cancelable cancelable = read ? new Cancelable(this.dspUser.wrappedRegisterAccess.requestRegisterRead(register, cancelOnRun)) : new Cancelable(this.dspUser.wrappedRegisterAccess.requestRegisterWrite(register));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }
}

