/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IBitfields;
import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.IRegisterServer;
import com.ti.debug.engine.IRegisters;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.Bitfields;
import com.ti.debug.engine.impl.DspTask;
import com.ti.debug.engine.impl.ExpressionEvaluator;
import com.ti.debug.engine.impl.Register;
import com.ti.debug.engine.impl.Registers;
import com.ti.xpcom.interfaces.dsIRegisterInfo;
import com.ti.xpcom.interfaces.dsIRegisterServer;
import java.io.File;
import java.util.Collection;

class RegisterServer
extends AComparableDisposable<dsIRegisterServer>
implements IRegisterServer {
    private DspTask task;

    RegisterServer(dsIRegisterServer registerServer, DspTask task) {
        super(registerServer);
        this.task = task;
    }

    @Override
    public IRegister findRegisterByName(String name) {
        Register register = null;
        dsIRegisterInfo registerInfo = ((dsIRegisterServer)this.wrappedObject).findRegisterByName(name);
        if (null != registerInfo) {
            register = new Register(registerInfo);
        }
        return register;
    }

    @Override
    public IRegisters findRegistersByAddress(long address, int page) {
        return new Registers(((dsIRegisterServer)this.wrappedObject).findRegistersByAddress(address, page));
    }

    @Override
    public String getGroupDescription(int group) {
        return ((dsIRegisterServer)this.wrappedObject).getGroupDescription(group);
    }

    @Override
    public String getGroupName(int group) {
        return ((dsIRegisterServer)this.wrappedObject).getGroupName(group);
    }

    @Override
    public int getNumGroups() {
        return (int)((dsIRegisterServer)this.wrappedObject).getNumGroups();
    }

    @Override
    public int getNumRegistersInGroup(int group) {
        return (int)((dsIRegisterServer)this.wrappedObject).getNumRegistersInGroup(group);
    }

    @Override
    public IRegister getRegisterInGroup(int group, int index) {
        return new Register(((dsIRegisterServer)this.wrappedObject).getRegisterInGroup(group, index));
    }

    @Override
    public IRegister findRegisterByName(String name, int[] index) {
        return this.findRegisterByName(name);
    }

    @Override
    public IRegister findRegisterByAddress(int address, int page, int[] index) {
        return this.findRegisterByAddress(address, page);
    }

    @Override
    public IRegister findRegisterByAddress(int address, int page) {
        IRegisters registers = this.findRegistersByAddress(address, page);
        IRegister register = null;
        if (0L != registers.count()) {
            register = registers.get(0L);
        }
        return register;
    }

    @Override
    public IRegisters searchRegisters(String searchString, boolean bSearchDescriptions, boolean bSearchHidden, long nFetchHint) {
        return new Registers(((dsIRegisterServer)this.wrappedObject).searchRegisters(searchString, bSearchDescriptions, bSearchHidden, nFetchHint));
    }

    @Override
    public IBitfields searchBitfields(String searchString, boolean bSearchDescriptions, boolean bSearchHidden, long nFetchHint) {
        return new Bitfields(((dsIRegisterServer)this.wrappedObject).searchBitfields(searchString, bSearchDescriptions, bSearchHidden, nFetchHint));
    }

    @Override
    public ICancelable saveRegisters(File file, Collection<Integer> groups, IStringEventListener callback) {
        String expression = "GEL_SystemSaveRegisters( \"";
        expression = expression + ExpressionEvaluator.convertFilenameForEval(file.toString()) + "\", 0";
        for (Integer i : groups) {
            expression = expression + ", " + i;
        }
        expression = expression + " )";
        return this.task.getExpressionEvaluator().evaluateGELBuiltinAsAPI(expression, callback);
    }

    @Override
    public ICancelable saveRegistersByName(File file, Collection<String> groups, IStringEventListener callback) {
        String expression = "GEL_SystemSaveRegisters( \"";
        expression = expression + ExpressionEvaluator.convertFilenameForEval(file.toString()) + "\", 0";
        for (String s : groups) {
            expression = expression + ", \"" + s + "\"";
        }
        expression = expression + " )";
        return this.task.getExpressionEvaluator().evaluateGELBuiltinAsAPI(expression, callback);
    }
}

