/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IRegisteredView;
import com.ti.debug.engine.events.data.IRefreshEventData;
import com.ti.debug.engine.events.impl.ManagedNumberToObjectEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.LegacyOnRefreshFilter;
import com.ti.debug.engine.impl.ObjectToSimpleEventAdapter;
import com.ti.debug.engine.xpcom.event.impl.RefreshEventDataTranslator;
import com.ti.xpcom.interfaces.dsIRefreshEvents;
import com.ti.xpcom.interfaces.dsIRefreshableView;

public class RegisteredView
extends AComparableDisposable<dsIRefreshableView>
implements IRegisteredView {
    private final dsIRefreshEvents wrappedRefreshEvents;
    private final ManagedNumberToObjectEvent<IRefreshEventData> managedOnRefresh;
    private final ISimpleEvent legacyOnRefresh;
    private int count = 1;
    private IRegisteredView.RefreshScheme refreshScheme = IRegisteredView.RefreshScheme.REFRESH_SCHEME_ALWAYS;

    RegisteredView(dsIRefreshableView refreshableView) {
        super(refreshableView);
        this.wrappedRefreshEvents = (dsIRefreshEvents)refreshableView.queryInterface("{be8fa9cf-e761-45f4-922c-583952adc2b1}");
        this.managedOnRefresh = new ManagedNumberToObjectEvent<IRefreshEventData>(this.wrappedRefreshEvents.onRefresh(), new RefreshEventDataTranslator());
        this.legacyOnRefresh = new ObjectToSimpleEventAdapter<IRefreshEventData>(this.managedOnRefresh, new LegacyOnRefreshFilter(){

            @Override
            public boolean filter(IRefreshEventData data) {
                return IRegisteredView.RefreshScheme.REFRESH_SCHEME_PROBE_ONLY == RegisteredView.this.refreshScheme && IRefreshEventData.RefreshReason.ProbePointHit != data.getReasonForRefresh() || super.filter(data);
            }
        });
    }

    @Override
    public synchronized void acquire() {
        ++this.count;
    }

    @Override
    public synchronized void dispose() {
        --this.count;
        if (0 == this.count && null != this.wrappedObject) {
            ((dsIRefreshableView)this.wrappedObject).unregisterViewForRefresh();
            this.wrappedObject = null;
        }
    }

    @Override
    public boolean isBreakpointConnected() {
        return ((dsIRefreshableView)this.wrappedObject).isBreakpointConnected();
    }

    @Override
    public void setRefreshScheme(IRegisteredView.RefreshScheme refreshScheme) {
        this.refreshScheme = refreshScheme;
    }

    @Override
    public ISimpleEvent onRefresh() {
        return this.legacyOnRefresh;
    }

    @Override
    public IObjectEvent<IRefreshEventData> onRefreshWithReason() {
        return this.managedOnRefresh;
    }
}

