/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IRtdx;
import com.ti.debug.engine.IRtdxChannel;
import com.ti.debug.engine.IServerObject;
import com.ti.debug.engine.events.data.IRtdxChannelData;
import com.ti.debug.engine.events.data.IRtdxStateData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.framework.ImplementationComparable;
import com.ti.debug.engine.impl.RtdxChannel;
import com.ti.debug.engine.xpcom.event.impl.RtdxChannelObjectDataTranslator;
import com.ti.debug.engine.xpcom.event.impl.RtdxStateEventDataTranslator;
import com.ti.xpcom.XPCOMException;
import com.ti.xpcom.interfaces.dsIRtdx;
import com.ti.xpcom.interfaces.dsIRtdxChannel;
import com.ti.xpcom.interfaces.dsIRtdxDiagnostics;
import com.ti.xpcom.interfaces.dsIRtdxDriverInfo;

public class Rtdx
extends ImplementationComparable<dsIRtdx>
implements IRtdx {
    private dsIRtdxDriverInfo capability = (dsIRtdxDriverInfo)((dsIRtdx)this.wrappedObject).queryInterface("{ee2b9882-90f4-42e3-8596-1c70b1ba2d7c}");
    private dsIRtdxDiagnostics diagnostics = (dsIRtdxDiagnostics)((dsIRtdx)this.wrappedObject).queryInterface("{c365bcb3-3c49-40d6-ac22-8e03bc622428}");
    private long lastStatus = 0L;
    public static final long RTDX_SUCCESS = 0L;
    public static final long Failure = 2147500037L;
    public static final long Warning = 0x80004004L;
    public static final long ENoDataAvailable = 2539978782L;
    public static final long EEndOfLogFile = 2539978754L;
    private static final long MODULE_BASE_OFFSET = 69L;
    private static final long SEVERITY_ERROR = 1L;
    private static final long RTDX_MODULE_BASE = 5920L;
    ManagedObjectEvent<IRtdxChannelData> managedOnChannelOpen;
    ManagedObjectEvent<IRtdxChannelData> managedOnChannelEnabled = new ManagedObjectEvent<IRtdxChannelData>(((dsIRtdx)this.wrappedObject).onChannelEnabled(), new RtdxChannelObjectDataTranslator());
    ManagedObjectEvent<IRtdxStateData> managedOnEnabled;
    ManagedObjectEvent<IRtdxStateData> managedOnConfigured;

    public static long GetErrorCode(long hresult) {
        return hresult & 0xFFFFL;
    }

    public static long GetErrorModule(long hresult) {
        long result = (hresult >> 16) - 69L & 0x1FFFL;
        return result;
    }

    public static long GetErrorSeverity(long hresult) {
        long result = hresult >> 31 & 1L;
        return result;
    }

    public static long HResultFromRtdxError(long errorCode) {
        long severity = 0x80000000L;
        long module = 392495104L;
        long result = severity | module | errorCode;
        return result;
    }

    public static long ExtractError(XPCOMException e) {
        long status = Rtdx.ExtractError(e.errorcode);
        if (0L == status) {
            throw e;
        }
        return status;
    }

    private static long ExtractError(long errorcode) {
        switch ((int)errorcode) {
            case -2147467260: 
            case -2147467259: 
            case -1754988542: 
            case -1754988514: {
                return (int)errorcode;
            }
        }
        if (Rtdx.IsRtdxModuleError(errorcode)) {
            return Rtdx.ExtractRtdxModuleError(errorcode);
        }
        return 0L;
    }

    public static boolean IsRtdxModuleError(XPCOMException e) {
        return Rtdx.IsRtdxModuleError(e.errorcode);
    }

    public static boolean IsRtdxModuleError(long errorcode) {
        return Rtdx.GetErrorModule(errorcode) == 5920L;
    }

    public static long ExtractRtdxModuleError(XPCOMException e) {
        return Rtdx.ExtractRtdxModuleError(e.errorcode);
    }

    public static long ExtractRtdxModuleError(long errorcode) {
        long error = Rtdx.GetErrorCode(errorcode);
        return error;
    }

    public Rtdx(dsIRtdx object) {
        super(object);
        this.managedOnChannelOpen = new ManagedObjectEvent<IRtdxChannelData>(((dsIRtdx)this.wrappedObject).onChannelOpen(), new RtdxChannelObjectDataTranslator());
        this.managedOnEnabled = new ManagedObjectEvent<IRtdxStateData>(((dsIRtdx)this.wrappedObject).onEnabled(), new RtdxStateEventDataTranslator());
        this.managedOnConfigured = new ManagedObjectEvent<IRtdxStateData>(((dsIRtdx)this.wrappedObject).onConfigured(), new RtdxStateEventDataTranslator());
    }

    @Override
    public long configureRtdx(int mode, long bufferSize, long bufferCount) {
        IRtdx.Configuration config = new IRtdx.Configuration(bufferSize, mode, bufferCount);
        try {
            ((dsIRtdx)this.wrappedObject).configure(config);
            config = null;
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public IRtdxChannel createRtdxChannel() {
        dsIRtdxChannel channel = null;
        try {
            channel = ((dsIRtdx)this.wrappedObject).createChannel();
            return new RtdxChannel(channel);
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            throw e;
        }
    }

    @Override
    public long disableChannel(String channelName) {
        try {
            ((dsIRtdx)this.wrappedObject).enableChannel(channelName, false);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long disableRtdx() {
        try {
            ((dsIRtdx)this.wrappedObject).enable(false);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            if (Rtdx.IsRtdxModuleError(e)) {
                this.lastStatus = Rtdx.ExtractError(e);
                return this.lastStatus;
            }
            throw e;
        }
    }

    @Override
    public long enableChannel(String channelName) {
        try {
            ((dsIRtdx)this.wrappedObject).enableChannel(channelName, true);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long enableRtdx() {
        try {
            ((dsIRtdx)this.wrappedObject).enable(true);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long getCapability() {
        try {
            return this.capability.getCapability();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long getChannelID(String channelName) {
        try {
            return ((dsIRtdx)this.wrappedObject).getChannelID(channelName);
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long getChannelStatus(String channelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getRTDXRev() {
        return 0L;
    }

    @Override
    public long getRtdxConfigBufferCount() {
        IRtdx.Configuration config = new IRtdx.Configuration();
        ((dsIRtdx)this.wrappedObject).getConfiguration(config);
        return config.getNumOfMainBuffers();
    }

    @Override
    public long getRtdxConfigBufferSize() {
        IRtdx.Configuration config = new IRtdx.Configuration();
        ((dsIRtdx)this.wrappedObject).getConfiguration(config);
        return config.getMainBufferSize();
    }

    @Override
    public long getRtdxConfigMode() {
        IRtdx.Configuration config = new IRtdx.Configuration();
        ((dsIRtdx)this.wrappedObject).getConfiguration(config);
        return config.getMode();
    }

    @Override
    public String getStatusString() {
        return ((dsIRtdx)this.wrappedObject).getStatusString();
    }

    @Override
    public boolean isEnabled() {
        try {
            return ((dsIRtdx)this.wrappedObject).getEnabled();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return false;
        }
    }

    @Override
    public boolean isRTDXConfigurable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long runDiagnostics(int testType, int testMode, int testInfo) {
        try {
            this.diagnostics.runDiagnostics(testType, testMode, testInfo);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public IServerObject resolve() {
        return this;
    }

    @Override
    public long command(int command, int inBufferPtr, int inBufferSize, int outBufferPtr, int outBufferSizePtr) {
        try {
            ((dsIRtdx)this.wrappedObject).command(command, inBufferPtr, inBufferSize, outBufferPtr, outBufferSizePtr);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long configureLogFile(String fileName, long fileSize, long fileFullMode, int fileOpenMode) {
        try {
            IRtdx.LogConfiguration config = new IRtdx.LogConfiguration(fileFullMode, fileName, fileOpenMode, fileSize);
            ((dsIRtdx)this.wrappedObject).getLogConfiguration(config);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long eraseLogFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public String getLogFileConfig(long fileSize, long fileFullMode, long fileOpenMode) {
        IRtdx.LogConfiguration config = new IRtdx.LogConfiguration();
        ((dsIRtdx)this.wrappedObject).getLogConfiguration(config);
        fileSize = config.getFileSize();
        fileFullMode = config.getFileFullMode();
        fileOpenMode = config.getFileOpenMode();
        return config.getFileName();
    }

    @Override
    public long getRtdxConfig(long mode, long size, long count) {
        IRtdx.Configuration config = new IRtdx.Configuration();
        try {
            ((dsIRtdx)this.wrappedObject).getConfiguration(config);
            mode = config.getMode();
            size = config.getMainBufferSize();
            count = config.getNumOfMainBuffers();
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public void configure(IRtdx.Configuration configuration) {
        try {
            this.lastStatus = 0L;
            ((dsIRtdx)this.wrappedObject).configure(configuration);
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
        }
    }

    @Override
    public void getConfiguration(IRtdx.Configuration configuration) {
        this.lastStatus = 0L;
        this.lastStatus = Rtdx.ExtractError(((dsIRtdx)this.wrappedObject).getConfiguration(configuration));
    }

    @Override
    public void configureLogFile(IRtdx.LogConfiguration configuration) {
        try {
            this.lastStatus = 0L;
            ((dsIRtdx)this.wrappedObject).configureLog(configuration);
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
        }
    }

    @Override
    public void getLogFileConfiguration(IRtdx.LogConfiguration configuration) {
        try {
            this.lastStatus = 0L;
            ((dsIRtdx)this.wrappedObject).getLogConfiguration(configuration);
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
        }
    }

    @Override
    public IObjectEvent<IRtdxChannelData> onChannelEnabled() {
        return this.managedOnChannelEnabled;
    }

    @Override
    public IObjectEvent<IRtdxChannelData> onChannelOpen() {
        return this.managedOnChannelOpen;
    }

    @Override
    public IObjectEvent<IRtdxStateData> onConfigured() {
        return this.managedOnConfigured;
    }

    @Override
    public IObjectEvent<IRtdxStateData> onEnabled() {
        return this.managedOnEnabled;
    }
}

