/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IRtdxChannel;
import com.ti.debug.engine.IServerObject;
import com.ti.debug.engine.events.IServerListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.Rtdx;
import com.ti.xpcom.XPCOMException;
import com.ti.xpcom.interfaces.dsIRtdxChannel;

public class RtdxChannel
extends AComparableDisposable<dsIRtdxChannel>
implements IRtdxChannel {
    private long lastStatus = 0L;
    private static final long RTDX_MODULE = 55072L;
    private static final long NS_ERROR_MODULE_BASE_OFFSET = 69L;

    static boolean IsRtdxError(XPCOMException e) {
        return (e.errorcode & 0xD7650000L) == 3613720576L;
    }

    static long ExtractRtdxError(XPCOMException e) {
        long error = 0xFFFFL & e.errorcode;
        return error;
    }

    public RtdxChannel(dsIRtdxChannel object) {
        super(object);
    }

    @Override
    public long close() {
        try {
            ((dsIRtdxChannel)this.wrappedObject).close();
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            if (RtdxChannel.IsRtdxError(e)) {
                this.lastStatus = RtdxChannel.ExtractRtdxError(e);
                return this.lastStatus;
            }
            throw e;
        }
    }

    @Override
    public long flush() {
        try {
            ((dsIRtdxChannel)this.wrappedObject).flush();
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            if (RtdxChannel.IsRtdxError(e)) {
                this.lastStatus = RtdxChannel.ExtractRtdxError(e);
                return this.lastStatus;
            }
            throw e;
        }
    }

    @Override
    public long getChannelID(String channelName) {
        try {
            this.lastStatus = 0L;
            return ((dsIRtdxChannel)this.wrappedObject).getChannelID(channelName);
        }
        catch (XPCOMException e) {
            if (RtdxChannel.IsRtdxError(e)) {
                this.lastStatus = RtdxChannel.ExtractRtdxError(e);
            }
            throw e;
        }
    }

    @Override
    public long getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public long getMsgID() {
        try {
            this.lastStatus = 0L;
            return ((dsIRtdxChannel)this.wrappedObject).getCurrentMessageID();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long getMsgLength() {
        try {
            this.lastStatus = 0L;
            return ((dsIRtdxChannel)this.wrappedObject).getCurrentMessageLength();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return 0L;
        }
    }

    @Override
    public long getMsgNumber() {
        try {
            this.lastStatus = 0L;
            return ((dsIRtdxChannel)this.wrappedObject).getCurrentMessageNumber();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return 0L;
        }
    }

    @Override
    public long getNumMsgs() {
        try {
            this.lastStatus = 0L;
            return ((dsIRtdxChannel)this.wrappedObject).getNumMessages();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return 0L;
        }
    }

    @Override
    public long gotoNextMsg() {
        try {
            ((dsIRtdxChannel)this.wrappedObject).gotoNextMessage();
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return 0L;
        }
    }

    @Override
    public long open(String channelName, String readWrite) {
        try {
            ((dsIRtdxChannel)this.wrappedObject).open(channelName, readWrite);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long read(int dataArrayPointer, int numBytesToRead, int dataType, int numBytesPtr) {
        try {
            this.lastStatus = ((dsIRtdxChannel)this.wrappedObject).readBytes(dataArrayPointer, numBytesToRead, dataType, numBytesPtr);
            return this.lastStatus;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long readI4() {
        try {
            this.lastStatus = 0L;
            return ((dsIRtdxChannel)this.wrappedObject).readI4();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long reset() {
        try {
            ((dsIRtdxChannel)this.wrappedObject).reset();
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long rewind() {
        try {
            ((dsIRtdxChannel)this.wrappedObject).rewind();
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
        }
        this.lastStatus = 0L;
        return 0L;
    }

    @Override
    public long seek(int msgNum) {
        try {
            ((dsIRtdxChannel)this.wrappedObject).seek(msgNum);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long seekData(int numBytes) {
        try {
            ((dsIRtdxChannel)this.wrappedObject).seekData(numBytes);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long statusOfWrite() {
        return ((dsIRtdxChannel)this.wrappedObject).getStatusOfWrite();
    }

    @Override
    public long write(long values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(int dataPtr, int numBytesToWrite, int dataType, int numBytesPtr) {
        try {
            this.lastStatus = ((dsIRtdxChannel)this.wrappedObject).writeBytes(dataPtr, numBytesToWrite, dataType, numBytesPtr);
            return this.lastStatus;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    @Override
    public long writeI4(long data) {
        try {
            ((dsIRtdxChannel)this.wrappedObject).writeI4(data);
            this.lastStatus = 0L;
            return 0L;
        }
        catch (XPCOMException e) {
            this.lastStatus = Rtdx.ExtractError(e);
            return this.lastStatus;
        }
    }

    public void addListener(IServerListener listener, int interfaceId, int eventId) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(IServerListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IServerObject resolve() {
        return this;
    }

    @Override
    public void finalDispose() {
        this.disposeSingleWrappedInterface(this.wrappedObject);
    }
}

