/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventCallback;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class SimpleEvent
implements ISimpleEvent {
    protected List<ISimpleEventListener> registeredListeners = Collections.synchronizedList(new LinkedList());

    SimpleEvent() {
    }

    @Override
    public synchronized void addISimpleEventListener(ISimpleEventListener listener) {
        if (!this.registeredListeners.contains(listener)) {
            this.registeredListeners.add(listener);
            if (1 == this.registeredListeners.size()) {
                this.firstListenerAdded();
            }
        }
    }

    @Override
    public synchronized void removeISimpleEventListener(ISimpleEventListener listener) {
        if (this.registeredListeners.contains(listener)) {
            this.registeredListeners.remove(listener);
            if (0 == this.registeredListeners.size()) {
                this.lastListenerRemoved();
            }
        }
    }

    void fireEvent() {
        this.fireEvent(null);
    }

    void fireEvent(Logger logger) {
        LinkedList<ISimpleEventListener> listCopy = new LinkedList<ISimpleEventListener>(this.registeredListeners);
        for (ISimpleEventListener listener : listCopy) {
            try {
                listener.onEvent();
            }
            catch (Throwable e) {
                if (null == logger) continue;
                logger.log(Level.SEVERE, "Error firing on generic event", e);
            }
        }
    }

    synchronized void clear() {
        if (0 != this.registeredListeners.size()) {
            this.registeredListeners.clear();
            this.lastListenerRemoved();
        }
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    @Override
    public void addListener(ISimpleEventCallback l) {
        this.addISimpleEventListener(l);
    }

    @Override
    public void removeListener(ISimpleEventCallback l) {
        this.removeISimpleEventListener(l);
    }
}

