/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IStackAnalysis;
import com.ti.debug.engine.events.data.IStackAnalysisEventData;
import com.ti.debug.engine.events.data.impl.StackAnalysisEventData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.Cancelable;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectEventListenerOneTimeFilter;
import com.ti.debug.engine.xpcom.event.impl.StackAnalysisEventDataTranslator;
import com.ti.xpcom.interfaces.dsIStackAnalysis;
import com.ti.xpcom.interfaces.dsITargetData;

public class StackAnalysis
extends AComparableDisposable<dsIStackAnalysis>
implements IStackAnalysis,
com.ti.debug.engine.tcl.IStackAnalysis {
    private final ManagedObjectEvent<IStackAnalysisEventData> onAnalysisComplete;

    StackAnalysis(dsIStackAnalysis object) {
        super(object);
        this.onAnalysisComplete = new ManagedObjectEvent<IStackAnalysisEventData>(((dsIStackAnalysis)this.wrappedObject).onAnalysisComplete(), new StackAnalysisEventDataTranslator());
    }

    @Override
    public ICancelable analyze(IDspValue startAddress, int length, short pageNumber, boolean printDiagnosticInfo) {
        Cancelable cancelable = new Cancelable(((dsIStackAnalysis)this.wrappedObject).analyze((dsITargetData)((DspValue)startAddress).getWrappedObject(), length, pageNumber, printDiagnosticInfo));
        return cancelable;
    }

    @Override
    public IObjectEvent<IStackAnalysisEventData> OnAnalysisComplete() {
        return this.onAnalysisComplete;
    }

    @Override
    public ICancelable analyze(final IDspValue startAddress, final int length, final short pageNumber, boolean printDiagnosticInfo, IObjectEventListener<IStackAnalysisEventData> callback) {
        ObjectEventListenerOneTimeFilter<IStackAnalysisEventData> listenerFilter = new ObjectEventListenerOneTimeFilter<IStackAnalysisEventData>(callback, this.OnAnalysisComplete(), new IFilterStrategy<IStackAnalysisEventData>(){

            @Override
            public boolean filter(IStackAnalysisEventData dataInterface) {
                StackAnalysisEventData data = (StackAnalysisEventData)dataInterface;
                return !data.getStartAddress().equal(startAddress) || data.getLength() != (long)length || data.getPageNumber() != pageNumber;
            }
        });
        try {
            return this.analyze(startAddress, length, pageNumber, printDiagnosticInfo);
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }
}

