/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IStringReader;
import com.ti.debug.engine.events.data.IStringReaderEventData;
import com.ti.debug.engine.events.data.impl.StringReaderEventData;
import com.ti.debug.engine.events.impl.ManagedObjectEvent;
import com.ti.debug.engine.events.tcl.IStringReaderEvents;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.Cancelable;
import com.ti.debug.engine.impl.DspValue;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectEventListenerOneTimeFilter;
import com.ti.debug.engine.xpcom.event.impl.StringReaderDataTranslator;
import com.ti.xpcom.interfaces.dsIStringReader;
import com.ti.xpcom.interfaces.dsITargetData;

class StringReader
extends AComparableDisposable<dsIStringReader>
implements IStringReader,
IStringReaderEvents {
    private final IObjectEvent<IStringReaderEventData> onStringRetrieved;

    StringReader(dsIStringReader object) {
        super(object);
        this.onStringRetrieved = new ManagedObjectEvent<IStringReaderEventData>(((dsIStringReader)this.wrappedObject).onStringRetrieved(), new StringReaderDataTranslator());
    }

    @Override
    public ICancelable requestStringRead(final IDspValue address, int page, int numCharacters, int stringFormat, IObjectEventListener<IStringReaderEventData> callback) {
        ObjectEventListenerOneTimeFilter<IStringReaderEventData> listenerFilter = new ObjectEventListenerOneTimeFilter<IStringReaderEventData>(callback, this.onStringRetrieved(), new IFilterStrategy<IStringReaderEventData>(){

            @Override
            public boolean filter(IStringReaderEventData data) {
                return !((StringReaderEventData)data).getAddress().equal(address);
            }
        });
        try {
            dsITargetData tgtAddress = ((DspValue)address).getWrappedTargetData();
            Cancelable cancelable = new Cancelable(((dsIStringReader)this.wrappedObject).requestStringRead(tgtAddress, page, numCharacters, stringFormat));
            return cancelable;
        }
        catch (RuntimeException e) {
            listenerFilter.unregister();
            throw e;
        }
    }

    @Override
    public IObjectEvent<IStringReaderEventData> onStringRetrieved() {
        return this.onStringRetrieved;
    }
}

