/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.ISymbolManager;
import com.ti.debug.engine.ISymbolPackage;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.ExpressionEvaluator;
import com.ti.debug.engine.impl.SymbolPackage;
import com.ti.xpcom.interfaces.dsIProgramLoader;
import com.ti.xpcom.interfaces.dsISymbolManager;

public class SymbolManager
extends AComparableDisposable<dsISymbolManager>
implements ISymbolManager {
    private final dsIProgramLoader programLoader;
    private final ExpressionEvaluator expressionEvaluator;
    private volatile Boolean capableProgramOrSymbolLoadCache = null;

    SymbolManager(dsISymbolManager symbolManager, dsIProgramLoader programLoader, ExpressionEvaluator expressionEvaluator) {
        super(symbolManager);
        this.programLoader = programLoader;
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public ISymbolPackage createOfflineSymbolPackage() {
        return new SymbolPackage(((dsISymbolManager)this.wrappedObject).createOfflineSymbolPackage());
    }

    @Override
    public ISymbolPackage getSymbolPackage() {
        return new SymbolPackage(((dsISymbolManager)this.wrappedObject).getSymbolPackage());
    }

    @Override
    public boolean capableProgramOrSymbolLoad() {
        if (null == this.capableProgramOrSymbolLoadCache) {
            this.capableProgramOrSymbolLoadCache = this.programLoader.getCapableLoad();
        }
        return this.capableProgramOrSymbolLoadCache;
    }

    @Override
    public boolean isProgramLoaded() {
        return this.programLoader.getIsProgramLoaded();
    }

    @Override
    public ICancelable requestFileLoad(String filename, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_Load( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\" )", callback);
    }

    @Override
    public ICancelable requestFileReload(IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_Reload()", callback);
    }

    @Override
    public ICancelable requestProgramLoad(String filename, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_LoadProgramOnly( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\" )", callback);
    }

    @Override
    public ICancelable requestProgramVerify(String filename, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_VerifyProgram( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\" )", callback);
    }

    @Override
    public ICancelable requestSymbolAdd(String filename, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SymbolAdd( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\" )", callback);
    }

    @Override
    public ICancelable requestSymbolAddWithOffset(String filename, long codeStart, long dataStart, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SymbolAddRel( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\", " + (int)codeStart + ", " + (int)dataStart + ")", callback);
    }

    @Override
    public ICancelable requestSymbolAddWithRelativeOffset(String filename, long codeOffset, long dataOffset, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SymbolAddOffset( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\", " + (int)codeOffset + ", " + (int)dataOffset + ")", callback);
    }

    @Override
    public ICancelable requestSymbolLoad(String filename, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SymbolLoad( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\" )", callback);
    }

    @Override
    public ICancelable requestSymbolLoadWithOffset(String filename, long codeStart, long dataStart, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SymbolLoadRel( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\", " + (int)codeStart + ", " + (int)dataStart + ")", callback);
    }

    @Override
    public ICancelable requestSymbolLoadWithRelativeOffset(String filename, long codeOffset, long dataOffset, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SymbolLoadOffset( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\", " + (int)codeOffset + ", " + (int)dataOffset + ")", callback);
    }

    @Override
    public ICancelable requestSymbolRemove(String filename, IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SymbolRemove( \"" + ExpressionEvaluator.convertFilenameForEval(filename) + "\" )", callback);
    }

    @Override
    public ICancelable requestSymbolUnload(IStringEventListener callback) {
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_UnloadAllSymbols()", callback);
    }

    @Override
    public ICancelable requestSetSemihostingMainArgs(String args, IStringEventListener callback) {
        args = args.replace("\"", "\\\"");
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI("GEL_SetSemihostingMainArgs( \"" + args + "\" )", callback);
    }

    @Override
    public ICancelable requestBinFileProgramLoad(String filename, long startOffset, IStringEventListener callback) {
        String gelCall = String.format("GEL_LoadBin( \"%s\", %d )", ExpressionEvaluator.convertFilenameForEval(filename.trim()), startOffset);
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelCall, callback);
    }

    @Override
    public ICancelable requestBinFileProgramVerify(String filename, long startOffset, IStringEventListener callback) {
        String gelCall = String.format("GEL_VerifyBinProgram( \"%s\", %d )", ExpressionEvaluator.convertFilenameForEval(filename.trim()), startOffset);
        return this.expressionEvaluator.evaluateGELBuiltinAsAPI(gelCall, callback);
    }
}

