/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ICancelable;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.events.impl.ManagedBooleanEvent;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.types.IBooleanEvent;
import com.ti.debug.engine.events.types.IBooleanEventListener;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.xpcom.interfaces.dsIConnectDisconnect;
import com.ti.xpcom.interfaces.dsIConnectDisconnectEvents;
import java.util.HashSet;

public class TargetConnection
extends AComparableDisposable<dsIConnectDisconnect>
implements ITargetConnection {
    private final dsIConnectDisconnectEvents wrappedEvents;
    private final ManagedSimpleEvent OnConnectFailed;
    private final ManagedSimpleEvent OnConnected;
    private final ManagedSimpleEvent OnConnecting;
    private final ManagedBooleanEvent OnDisconencting;
    private final ManagedSimpleEvent OnDisconnected;
    private final ManagedSimpleEvent OnRemoveDebugState;
    private final ManagedSimpleEvent OnRestoreDebugState;
    private final ConnectionStatusCache connectionStatusCache;
    private volatile Boolean capableCache = null;
    private static final HashSet<Object> references = new HashSet();

    public TargetConnection(dsIConnectDisconnect object) {
        super(object);
        this.wrappedEvents = (dsIConnectDisconnectEvents)object.queryInterface("{97774759-2a7b-4381-ac60-2463b84bbd6a}");
        this.OnConnectFailed = new ManagedSimpleEvent(this.wrappedEvents.onConnectFailed());
        this.OnConnected = new ManagedSimpleEvent(this.wrappedEvents.onConnected());
        this.OnConnecting = new ManagedSimpleEvent(this.wrappedEvents.onConnecting());
        this.OnDisconencting = new ManagedBooleanEvent(this.wrappedEvents.onDisconnecting());
        this.OnDisconnected = new ManagedSimpleEvent(this.wrappedEvents.onDisconnected());
        this.OnRemoveDebugState = new ManagedSimpleEvent(this.wrappedEvents.onRemoveDebugState());
        this.OnRestoreDebugState = new ManagedSimpleEvent(this.wrappedEvents.onRestoreDebugState());
        this.connectionStatusCache = new ConnectionStatusCache();
    }

    @Override
    public ITargetConnection.ConnectionStatus getConnectionStatus() {
        return this.connectionStatusCache.getCache();
    }

    private ITargetConnection.ConnectionStatus getUncachedConnectionStatus() {
        switch (((dsIConnectDisconnect)this.wrappedObject).connectionStatus()) {
            case 0: {
                return ITargetConnection.ConnectionStatus.CONNECTED;
            }
            case 2: {
                return ITargetConnection.ConnectionStatus.DISCONNECTED;
            }
            case 1: {
                return ITargetConnection.ConnectionStatus.CONNECTING;
            }
            case 3: {
                return ITargetConnection.ConnectionStatus.DISCONNECTING;
            }
        }
        throw new RuntimeException("Invalid connection type");
    }

    @Override
    public boolean hasDebugStateToRestore() {
        return ((dsIConnectDisconnect)this.wrappedObject).getHasDebugStateToRestore();
    }

    @Override
    public void restoreDebugState() {
        ((dsIConnectDisconnect)this.wrappedObject).restoreDebugState();
    }

    @Override
    public boolean disconnectCapable() {
        if (null == this.capableCache) {
            this.capableCache = new Boolean(((dsIConnectDisconnect)this.wrappedObject).getDisconnectCapable());
        }
        return this.capableCache;
    }

    private void targetConnect() {
        ((dsIConnectDisconnect)this.wrappedObject).connect();
    }

    @Override
    public ICancelable targetConnect(final IBooleanEventListener listener) {
        return new ICancelable(){
            private final ISimpleEventListener onSuccess = new ISimpleEventListener(){

                @Override
                public void onEvent() {
                    this.fireEvent(true);
                }
            };
            private final ISimpleEventListener onFailure = new ISimpleEventListener(){

                @Override
                public void onEvent() {
                    this.fireEvent(false);
                }
            };
            private boolean eventFired;
            {
                if (null != listener) {
                    this.register();
                    if (ITargetConnection.ConnectionStatus.CONNECTED == TargetConnection.this.getConnectionStatus()) {
                        this.fireEvent(true);
                    }
                }
                TargetConnection.this.targetConnect();
                this.eventFired = false;
            }

            @Override
            public boolean cancel() {
                this.fireEvent(false);
                TargetConnection.this.targetDisconnect();
                return true;
            }

            private void unregister() {
                TargetConnection.this.onConnected().removeISimpleEventListener(this.onSuccess);
                TargetConnection.this.onConnectFailed().removeISimpleEventListener(this.onFailure);
                TargetConnection.this.onDisconnected().removeISimpleEventListener(this.onFailure);
                references.remove(this);
            }

            private void register() {
                TargetConnection.this.onConnected().addISimpleEventListener(this.onSuccess);
                TargetConnection.this.onConnectFailed().addISimpleEventListener(this.onFailure);
                TargetConnection.this.onDisconnected().addISimpleEventListener(this.onFailure);
                references.add(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fireEvent(boolean success) {
                this.unregister();
                boolean shouldFireEvent = false;
                1 var3_3 = this;
                synchronized (var3_3) {
                    shouldFireEvent = !this.eventFired;
                    this.eventFired = true;
                }
                if (null != listener && shouldFireEvent) {
                    listener.onEvent(success);
                }
            }
        };
    }

    private void targetDisconnect() {
        ((dsIConnectDisconnect)this.wrappedObject).disconnect(true);
    }

    @Override
    public ICancelable targetDisconnect(final ISimpleEventListener listener) {
        if (null != listener) {
            new ISimpleEventListener(){
                private boolean eventFired = false;
                {
                    TargetConnection.this.onDisconnected().addISimpleEventListener(this);
                    references.add(this);
                    if (ITargetConnection.ConnectionStatus.DISCONNECTED == TargetConnection.this.getConnectionStatus()) {
                        this.onEvent();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onEvent() {
                    TargetConnection.this.onDisconnected().removeISimpleEventListener(this);
                    references.remove(this);
                    boolean shouldFireEvent = false;
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        shouldFireEvent = !this.eventFired;
                        this.eventFired = true;
                    }
                    if (shouldFireEvent) {
                        listener.onEvent();
                    }
                }
            };
        }
        this.targetDisconnect();
        return new ICancelable(){

            @Override
            public boolean cancel() {
                return false;
            }
        };
    }

    @Override
    public ISimpleEvent onConnectFailed() {
        return this.OnConnectFailed;
    }

    @Override
    public ISimpleEvent onConnected() {
        return this.OnConnected;
    }

    @Override
    public ISimpleEvent onConnecting() {
        return this.OnConnecting;
    }

    @Override
    public ISimpleEvent onDisconnected() {
        return this.OnDisconnected;
    }

    @Override
    public IBooleanEvent onDisconnecting() {
        return this.OnDisconencting;
    }

    @Override
    public ISimpleEvent onRemoveDebugState() {
        return this.OnRemoveDebugState;
    }

    @Override
    public ISimpleEvent onRestoreDebugState() {
        return this.OnRestoreDebugState;
    }

    private final class ConnectionStatusCache {
        private volatile boolean cacheValid = false;
        private ITargetConnection.ConnectionStatus cachedStatus = ITargetConnection.ConnectionStatus.CONNECTED;
        private final ISimpleEventListener simpleCacheInvalidator = new ISimpleEventListener(){

            @Override
            public void onEvent() {
                ConnectionStatusCache.this.cacheValid = false;
            }
        };
        private final IBooleanEventListener booleanCacheInvalidator = new IBooleanEventListener(){

            @Override
            public void onEvent(boolean data) {
                ConnectionStatusCache.this.cacheValid = false;
            }
        };

        public ITargetConnection.ConnectionStatus getCache() {
            ITargetConnection.ConnectionStatus status = this.cachedStatus;
            if (!this.cacheValid) {
                status = this.cachedStatus = TargetConnection.this.getUncachedConnectionStatus();
                this.cacheValid = true;
            }
            return status;
        }

        public ConnectionStatusCache() {
            TargetConnection.this.onConnectFailed().addISimpleEventListener(this.simpleCacheInvalidator);
            TargetConnection.this.onConnected().addISimpleEventListener(this.simpleCacheInvalidator);
            TargetConnection.this.onConnecting().addISimpleEventListener(this.simpleCacheInvalidator);
            TargetConnection.this.onDisconnected().addISimpleEventListener(this.simpleCacheInvalidator);
            TargetConnection.this.onDisconnecting().addIBooleanEventListener(this.booleanCacheInvalidator);
        }
    }
}

