/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.ITargetState;
import com.ti.xpcom.interfaces.dsIRunControl;
import java.util.HashMap;
import java.util.Map;

class TargetState
implements ITargetState {
    private static final Map<Integer, ITargetState.ExecutionState> stateMap = new HashMap<Integer, ITargetState.ExecutionState>();
    private static final Map<Integer, ITargetState.HaltReason> reasonMap;
    private final ITargetState.ExecutionState executionState;
    private final boolean isPowered;
    private final boolean isSecure;
    private final ITargetState.HaltReason haltReason;

    TargetState(dsIRunControl runControl) {
        boolean[] arPowered = new boolean[]{false};
        boolean[] arSecure = new boolean[]{false};
        int[] arHaltReason = new int[]{0};
        this.executionState = stateMap.get(runControl.getExecutionState(arPowered, arSecure, arHaltReason));
        this.isPowered = arPowered[0];
        this.isSecure = arSecure[0];
        this.haltReason = this.mapReason(arHaltReason[0]);
    }

    private ITargetState.HaltReason mapReason(int xpcomHaltReason) {
        ITargetState.HaltReason reason = reasonMap.get(xpcomHaltReason);
        if (null == reason) {
            reason = ITargetState.HaltReason.UNKNOWN;
        }
        return reason;
    }

    @Override
    public ITargetState.ExecutionState getExecutionState() {
        return this.executionState;
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public boolean isSecured() {
        return this.isSecure;
    }

    @Override
    public ITargetState.HaltReason getHaltReason() {
        return this.haltReason;
    }

    @Override
    public boolean haltInUserContext() {
        return ITargetState.HaltReason.GLOBAL_BREAKPOINT != this.getHaltReason();
    }

    static {
        stateMap.put(-1, ITargetState.ExecutionState.UNKNOWN);
        stateMap.put(0, ITargetState.ExecutionState.HALTED);
        stateMap.put(1, ITargetState.ExecutionState.RUNNING);
        stateMap.put(2, ITargetState.ExecutionState.FREE_RUNNING);
        stateMap.put(7, ITargetState.ExecutionState.HELD_IN_RESET);
        stateMap.put(3, ITargetState.ExecutionState.NO_POWER);
        stateMap.put(4, ITargetState.ExecutionState.CABLE_BREAK);
        stateMap.put(5, ITargetState.ExecutionState.NO_CLOCK);
        reasonMap = new HashMap<Integer, ITargetState.HaltReason>();
        reasonMap.put(0, ITargetState.HaltReason.USER_REQUESTED);
        reasonMap.put(1, ITargetState.HaltReason.STEP_FINISHED);
        reasonMap.put(2, ITargetState.HaltReason.SW_BREAKPOINT);
        reasonMap.put(3, ITargetState.HaltReason.HW_BREAKPOINT);
        reasonMap.put(6, ITargetState.HaltReason.GLOBAL_BREAKPOINT);
        reasonMap.put(5, ITargetState.HaltReason.UNKNOWN);
    }
}

