/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.impl;

import com.ti.debug.engine.IArithmeticType;
import com.ti.debug.engine.IArrayType;
import com.ti.debug.engine.ICompoundType;
import com.ti.debug.engine.IEnumType;
import com.ti.debug.engine.IFunctionType;
import com.ti.debug.engine.IMaskedType;
import com.ti.debug.engine.IPointerType;
import com.ti.debug.engine.IReferenceType;
import com.ti.debug.engine.IType;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.impl.ArithmeticType;
import com.ti.debug.engine.impl.ArrayType;
import com.ti.debug.engine.impl.CompoundType;
import com.ti.debug.engine.impl.EnumType;
import com.ti.debug.engine.impl.FunctionResultCache;
import com.ti.debug.engine.impl.FunctionType;
import com.ti.debug.engine.impl.MaskedType;
import com.ti.debug.engine.impl.PointerType;
import com.ti.debug.engine.impl.ReferenceType;
import com.ti.xpcom.interfaces.dsIArithmeticType;
import com.ti.xpcom.interfaces.dsIArrayType;
import com.ti.xpcom.interfaces.dsIEnumType;
import com.ti.xpcom.interfaces.dsIFunctionType;
import com.ti.xpcom.interfaces.dsIMaskedType;
import com.ti.xpcom.interfaces.dsIType;

public class Type
extends AComparableDisposable<dsIType>
implements IType {
    private FunctionResultCache<Integer> typeMask = new FunctionResultCache<Integer>(){

        @Override
        protected Integer fetchUncachedValue() {
            return ((dsIType)Type.this.wrappedObject).getType();
        }
    };

    Type(dsIType type) {
        super(type);
    }

    @Override
    public String getString() {
        return ((dsIType)this.wrappedObject).getTypeString();
    }

    @Override
    public String getTypeDefName() {
        return ((dsIType)this.wrappedObject).getTypedefName();
    }

    @Override
    public ICompoundType getCompoundType() {
        return new CompoundType(((dsIType)this.wrappedObject).getCompoundType());
    }

    @Override
    public IPointerType getPointerType() {
        return new PointerType(((dsIType)this.wrappedObject).getPointerType());
    }

    @Override
    public IReferenceType getReferenceType() {
        return new ReferenceType(((dsIType)this.wrappedObject).getReferenceType());
    }

    @Override
    public IArithmeticType getArithmeticType() {
        ArithmeticType type = null;
        dsIArithmeticType realType = null;
        if (this.isArithmetic()) {
            realType = ((dsIType)this.wrappedObject).getArithmeticType();
        }
        if (null != realType) {
            type = new ArithmeticType(realType);
        }
        return type;
    }

    @Override
    public IArrayType getArrayType() {
        ArrayType type = null;
        dsIArrayType realType = null;
        if (this.isArray()) {
            realType = ((dsIType)this.wrappedObject).getArrayType();
        }
        if (null != realType) {
            type = new ArrayType(realType);
        }
        return type;
    }

    @Override
    public IEnumType getEnumType() {
        EnumType type = null;
        dsIEnumType realType = null;
        if (this.isEnum()) {
            realType = ((dsIType)this.wrappedObject).getEnumType();
        }
        if (null != realType) {
            type = new EnumType(realType);
        }
        return type;
    }

    @Override
    public IFunctionType getFunctionType() {
        FunctionType type = null;
        dsIFunctionType realType = null;
        if (this.isFunction()) {
            realType = ((dsIType)this.wrappedObject).getFunctionType();
        }
        if (null != realType) {
            type = new FunctionType(realType);
        }
        return type;
    }

    @Override
    public IMaskedType getMaskedType() {
        dsIMaskedType realType = ((dsIType)this.wrappedObject).getMaskedType();
        MaskedType type = null;
        if (null != realType) {
            type = new MaskedType(realType);
        }
        return type;
    }

    private boolean isOfType(int type) {
        return 0 != (this.typeMask.fetch() & type);
    }

    @Override
    public boolean isArray() {
        return this.isOfType(1);
    }

    @Override
    public boolean isFunction() {
        return this.isOfType(16);
    }

    @Override
    public boolean isVoid() {
        return this.isOfType(256);
    }

    @Override
    public boolean isArithmetic() {
        return this.isOfType(2);
    }

    @Override
    public boolean isCompound() {
        return this.isOfType(4);
    }

    @Override
    public boolean isEnum() {
        return this.isOfType(8);
    }

    @Override
    public boolean isMasked() {
        return this.isOfType(32);
    }

    @Override
    public boolean isPointer() {
        return this.isOfType(64);
    }

    @Override
    public boolean isReference() {
        return this.isOfType(128);
    }

    @Override
    public boolean isTypeDef() {
        return this.isOfType(512);
    }
}

