/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IProcessorInfo;
import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.IProfProperties;
import com.ti.debug.engine.profileactivities.ProfileActivityHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Vector;

class ActivityOptionSet {
    private static final String FILEPARSE_EVENT_ID = "[Events]";
    private static final String FILEPARSE_EVENT_CLASS = "[EventClasses]";
    private static final String FILEPARSE_ATTRIB_ID = "[Attributes]";
    private static final String FILEPARSE_ISA_ID = "[ISA]";
    private static final String FILEPARSE_NAME_ID = "[Name]";
    private static final String FILEPARSE_DESCRIPTION_ID = "[Description]";
    private static final String FILE_PARSE_METADATA_ID = "[MetaData]";
    private AbstractList<PropertyInfo> propertyList = new Vector<PropertyInfo>(10, 10);
    private AbstractList<PropertyInfo> metadataList = new Vector<PropertyInfo>(10, 10);
    private AbstractList<String> eventList = new Vector<String>(10, 10);
    private AbstractList<String> requiredEventList = new Vector<String>(10, 10);
    private String eventClass = "";
    private AbstractList<String> isaList = new Vector<String>(10, 10);
    private String name;
    private String description;
    boolean hardwareSpecific = false;
    boolean simulationSpecific = false;
    boolean partialEventSupport = false;
    boolean bHaveComparedOptions = false;

    public ActivityOptionSet(File inFile) {
        this.setName(new String());
        this.setDescription(new String());
        this.ParseFile(inFile);
    }

    private void Reset() {
        this.propertyList.clear();
        this.eventList.clear();
        this.isaList.clear();
        this.setName(new String());
        this.setDescription(new String());
    }

    private void ParseFile(File activityFile) {
        if (activityFile == null || !activityFile.exists() || !activityFile.canRead()) {
            return;
        }
        this.Reset();
        FileParseModes curParseMode = FileParseModes.FILEPARSE_UNKNOWN_MODE;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(activityFile));
            String curLine = null;
            while ((curLine = reader.readLine()) != null) {
                if (curLine.length() == 0) {
                    curParseMode = FileParseModes.FILEPARSE_UNKNOWN_MODE;
                    continue;
                }
                switch (curParseMode) {
                    case FILEPARSE_UNKNOWN_MODE: {
                        if (curLine.contentEquals(FILEPARSE_EVENT_ID)) {
                            curParseMode = FileParseModes.FILEPARSE_EVENT_MODE;
                            break;
                        }
                        if (curLine.contentEquals(FILEPARSE_EVENT_CLASS)) {
                            curParseMode = FileParseModes.FILEPARSE_EVENT_CLASS_MODE;
                            break;
                        }
                        if (curLine.contentEquals(FILEPARSE_ATTRIB_ID)) {
                            curParseMode = FileParseModes.FILEPARSE_ATTRIB_MODE;
                            break;
                        }
                        if (curLine.contentEquals(FILEPARSE_ISA_ID)) {
                            curParseMode = FileParseModes.FILEPARSE_ISA_MODE;
                            break;
                        }
                        if (curLine.contentEquals(FILEPARSE_NAME_ID)) {
                            curParseMode = FileParseModes.FILEPARSE_NAME_MODE;
                            break;
                        }
                        if (curLine.contentEquals(FILEPARSE_DESCRIPTION_ID)) {
                            curParseMode = FileParseModes.FILEPARSE_DESCRIPTION_MODE;
                            break;
                        }
                        if (!curLine.contentEquals(FILE_PARSE_METADATA_ID)) break;
                        curParseMode = FileParseModes.FILEPARSE_METADATA_MODE;
                        break;
                    }
                    case FILEPARSE_EVENT_MODE: {
                        this.addEvent(curLine.trim());
                        break;
                    }
                    case FILEPARSE_EVENT_CLASS_MODE: {
                        this.setEventClass(curLine.trim());
                        break;
                    }
                    case FILEPARSE_ISA_MODE: {
                        this.addISA(curLine.trim());
                        break;
                    }
                    case FILEPARSE_NAME_MODE: {
                        this.setName(curLine.trim());
                        break;
                    }
                    case FILEPARSE_DESCRIPTION_MODE: {
                        if (this.getDescription().length() != 0) {
                            this.setDescription(this.getDescription() + System.getProperty("line.separator"));
                        }
                        this.setDescription(this.getDescription() + curLine);
                        break;
                    }
                    case FILEPARSE_ATTRIB_MODE: {
                        PropertyInfo curPair;
                        String[] extraSpecifier;
                        Vector<String> propValues = new Vector<String>();
                        String[] firstSplit = curLine.split(",");
                        ((AbstractCollection)propValues).addAll(Arrays.asList(firstSplit[0].split("=")));
                        boolean bCanModify = true;
                        if (firstSplit.length >= 2 && (extraSpecifier = firstSplit[1].split("=")).length == 2) {
                            if (extraSpecifier[0].contentEquals("userCanModify") && extraSpecifier[1].contentEquals("false")) {
                                bCanModify = false;
                            } else if (extraSpecifier[0].contentEquals("dependsOn")) {
                                ((AbstractList)propValues).add(extraSpecifier[1]);
                            }
                        }
                        if ((curPair = new PropertyInfo(propValues, bCanModify)).getName().contentEquals("HardwareOnly")) {
                            this.hardwareSpecific = curPair.getValue().contentEquals("true");
                            break;
                        }
                        if (curPair.getName().contentEquals("SimulationOnly")) {
                            this.simulationSpecific = curPair.getValue().contentEquals("true");
                            break;
                        }
                        if (curPair.getName().contentEquals("PartialEvents")) {
                            this.partialEventSupport = curPair.getValue().contentEquals("true");
                            break;
                        }
                        this.addProperty(curPair);
                        break;
                    }
                    case FILEPARSE_METADATA_MODE: {
                        Vector<String> propValue = new Vector<String>();
                        ((AbstractCollection)propValue).addAll(Arrays.asList(curLine.split("=")));
                        this.addMetaData(new PropertyInfo(propValue, true));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.requiredEventList.addAll(this.getEvents());
    }

    public void addProperty(PropertyInfo property) {
        this.propertyList.add(property);
    }

    public AbstractList<PropertyInfo> getProperties() {
        return this.propertyList;
    }

    private void setProperties(AbstractList<PropertyInfo> propertyList) {
        this.propertyList = propertyList;
    }

    public void addMetaData(PropertyInfo metaData) {
        this.metadataList.add(metaData);
    }

    public AbstractList<PropertyInfo> getMetaData() {
        return this.metadataList;
    }

    public void addISA(String strISA) {
        this.isaList.add(strISA);
    }

    public AbstractList<String> getISAs() {
        return this.isaList;
    }

    public void addEvent(String strEvent) {
        this.eventList.add(strEvent);
    }

    public AbstractList<String> getEvents() {
        return this.eventList;
    }

    public void setEventClass(String strEventClass) {
        this.eventClass = strEventClass;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public boolean supportsPartialEvents() {
        return this.partialEventSupport;
    }

    public boolean isHardwareSpecific() {
        return this.hardwareSpecific;
    }

    public boolean isSimulationSpecific() {
        return this.simulationSpecific;
    }

    boolean isEmpty() {
        return this.propertyList.size() == 0 && this.eventList.size() == 0 && this.isaList.size() == 0;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private Vector<String> generateAttributes(IProfProperties propAttributes) {
        Vector<String> attributes = new Vector<String>(200, 20);
        try {
            IProfProperties.PropertyKeyValuePair[] datatypes = propAttributes.readProperty("dataclass", (short)0);
            for (int i = 0; datatypes != null && i < datatypes.length; ++i) {
                IProfProperties.PropertyKeyValuePair[] nodeValues = propAttributes.readProperty("dataclass." + datatypes[i].getPropertyKeyName(), (short)8);
                for (int j = 0; nodeValues != null && j < nodeValues.length; ++j) {
                    attributes.add("dataclass." + datatypes[i].getPropertyKeyName() + "." + nodeValues[j].getPropertyKeyName());
                }
            }
        }
        catch (IProfProperties.ProfPropertiesException e) {
            attributes.clear();
        }
        attributes.trimToSize();
        return attributes;
    }

    public void restrictOptionsToCurrentCollector(IProfCollector curCollector) {
        IProfProperties propsToUse = null;
        try {
            propsToUse = curCollector.getProperties();
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            return;
        }
        this.restrictProperties(propsToUse);
        this.reduceEvents(propsToUse);
        this.bHaveComparedOptions = true;
    }

    private void reduceEvents(IProfProperties propsToUse) {
        AbstractList<String> collectorEvents = ProfileActivityHelper.generateCollectorEvents(propsToUse);
        AbstractList<String> events = this.getEvents();
        this.requiredEventList.clear();
        for (int i = 0; i < events.size(); ++i) {
            if (!collectorEvents.contains(events.get(i))) continue;
            this.requiredEventList.add(events.get(i));
        }
    }

    private void restrictProperties(IProfProperties propsToUse) {
        Vector<String> collectorAttributes = this.generateAttributes(propsToUse);
        AbstractList<PropertyInfo> activityProps = this.getProperties();
        Vector<PropertyInfo> validProps = new Vector<PropertyInfo>(activityProps.size());
        for (int i = 0; i < activityProps.size(); ++i) {
            if (!((AbstractCollection)collectorAttributes).contains(activityProps.get(i).getName())) continue;
            ((AbstractList)validProps).add(activityProps.get(i));
        }
        this.setProperties(validProps);
    }

    public AbstractList<String> getRequiredEvents() {
        return this.requiredEventList;
    }

    public boolean isActivityOptionSetValid() {
        if (!this.bHaveComparedOptions) {
            return true;
        }
        return this.getRequiredEvents().size() != 0 && (this.getRequiredEvents().size() == this.getEvents().size() || this.supportsPartialEvents());
    }

    public boolean supportsISA(IDspTask dspTask) {
        IProcessorInfo processorInfo = dspTask.getProcessorInfo();
        int family = processorInfo.getTargetFamilyID();
        int subFamily = processorInfo.getTargetSubFamilyID();
        int targetType = processorInfo.getTargetType();
        processorInfo.dispose();
        processorInfo = null;
        String curISA = new String();
        curISA = family == 320 ? String.format("TMS%dC%x", family, subFamily) : String.format("TMS%dR%x", family, subFamily);
        AbstractList<String> isas = this.getISAs();
        boolean matchFound = isas.size() == 0;
        for (int i = 0; !matchFound && i < isas.size(); ++i) {
            if (isas.get(i).startsWith(curISA)) {
                matchFound = true;
                continue;
            }
            if (!isas.get(i).contentEquals("*")) continue;
            matchFound = true;
        }
        if (!matchFound) {
            return false;
        }
        if (this.isSimulationSpecific() && targetType != 1) {
            return false;
        }
        return !this.isHardwareSpecific() || targetType == 0;
    }

    private static enum FileParseModes {
        FILEPARSE_UNKNOWN_MODE,
        FILEPARSE_EVENT_MODE,
        FILEPARSE_ISA_MODE,
        FILEPARSE_ATTRIB_MODE,
        FILEPARSE_NAME_MODE,
        FILEPARSE_DESCRIPTION_MODE,
        FILEPARSE_EVENT_CLASS_MODE,
        FILEPARSE_METADATA_MODE;

    }

    public static class PropertyInfo {
        private String name;
        private String value;
        private String dependent;
        private boolean hasValue = false;
        private boolean canModify;

        public PropertyInfo(AbstractList<String> initValues, boolean canModify) {
            this.canModify = canModify;
            if (initValues.size() > 0) {
                this.setName(initValues.get(0));
            }
            if (initValues.size() > 1) {
                this.setValue(initValues.get(1));
            }
            if (initValues.size() > 2) {
                this.setDependent(initValues.get(2));
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            if (this.hasValue && !this.canModifyValue()) {
                return;
            }
            this.value = value;
            this.hasValue = true;
        }

        public String getDependent() {
            return this.dependent;
        }

        public void setDependent(String dependent) {
            if (this.hasValue && !this.canModifyValue()) {
                return;
            }
            this.dependent = dependent;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public boolean canModifyValue() {
            return this.canModify;
        }
    }
}

