/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IActivityProvider;
import com.ti.debug.engine.IActivityProviderServer;
import com.ti.debug.engine.events.data.IActivityEnabledEventData;
import com.ti.debug.engine.events.impl.StringEvent;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IStringEvent;
import com.ti.debug.engine.profileactivities.ActivityManagedObjectEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ActivityProviderServer
implements IActivityProviderServer {
    private Map<String, IActivityProvider> currentProviders = Collections.synchronizedMap(new HashMap());
    private static ActivityProviderServer INSTANCE;
    private StringEvent managedOnActivityProviderAdded = new StringEvent();
    private StringEvent managedOnActivityProviderRemoved = new StringEvent();
    private ActivityManagedObjectEvent<IActivityEnabledEventData> managedOnActivityEnabled = new ActivityManagedObjectEvent();

    private ActivityProviderServer() {
    }

    public static ActivityProviderServer getActivityProviderServer() {
        if (INSTANCE == null) {
            INSTANCE = new ActivityProviderServer();
        }
        return INSTANCE;
    }

    @Override
    public int getNumActivityProviders() {
        return this.currentProviders.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActivityProvider(IActivityProvider newProvider) throws IActivityProviderServer.ActivityProviderServerException {
        if (newProvider == null) {
            throw new IActivityProviderServer.ActivityProviderServerException("Null providers need not apply");
        }
        ActivityProviderServer activityProviderServer = this;
        synchronized (activityProviderServer) {
            if (this.currentProviders.containsKey(newProvider.getName())) {
                throw new IActivityProviderServer.ActivityProviderServerException("Specified provider could not be added: Provider with the same name already resides within the system");
            }
            this.currentProviders.put(newProvider.getName(), newProvider);
        }
        this.onActivityProviderAdded(newProvider.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IActivityProvider getActivityProvider(int index) throws IActivityProviderServer.ActivityProviderServerException {
        ActivityProviderServer activityProviderServer = this;
        synchronized (activityProviderServer) {
            if (index < 0 || index >= this.currentProviders.size()) {
                throw new IActivityProviderServer.ActivityProviderServerException("Invalid index specified");
            }
            Iterator<IActivityProvider> iter = this.currentProviders.values().iterator();
            while (iter.hasNext() && index > 0) {
                --index;
                iter.next();
            }
            return iter.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActivityProvider(IActivityProvider oldProvider) throws IActivityProviderServer.ActivityProviderServerException {
        if (oldProvider == null) {
            throw new IActivityProviderServer.ActivityProviderServerException("Null providers need not apply");
        }
        ActivityProviderServer activityProviderServer = this;
        synchronized (activityProviderServer) {
            if (!this.currentProviders.containsKey(oldProvider.getName())) {
                throw new IActivityProviderServer.ActivityProviderServerException("Specified provider could not be removed: it does not exist");
            }
            if (this.currentProviders.get(oldProvider.getName()) != oldProvider) {
                throw new IActivityProviderServer.ActivityProviderServerException("Specified provider name found, but associated with different provider instance: provider not removed");
            }
            this.currentProviders.remove(oldProvider.getName());
        }
        this.onActivityProviderRemoved(oldProvider.getName());
    }

    public void onActivityProviderAdded(String providerName) {
        this.managedOnActivityProviderAdded.fireEvent(providerName);
    }

    public void onActivityProviderRemoved(String providerName) {
        this.managedOnActivityProviderRemoved.fireEvent(providerName);
    }

    @Override
    public void notifyListenersOfEnabledActivity(IActivityEnabledEventData activityInfo) {
        this.managedOnActivityEnabled.onEvent(activityInfo);
    }

    @Override
    public IStringEvent onActivityProviderAdded() {
        return this.managedOnActivityProviderAdded;
    }

    @Override
    public IStringEvent onActivityProviderRemoved() {
        return this.managedOnActivityProviderRemoved;
    }

    @Override
    public IObjectEvent<IActivityEnabledEventData> onActivityEnabled() {
        return this.managedOnActivityEnabled;
    }
}

