/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IControlPointClient;
import com.ti.debug.engine.IControlPointServer;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.events.data.IControlPointEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import java.util.AbstractList;
import java.util.Vector;

public class BreakpointBasedControlPoints
implements IControlPointServer {
    private AbstractList<IControlPointClient> controlPointClients = new Vector<IControlPointClient>();
    private InternalCtrlPointListener myInternalCPListener;
    private IDspUser myDspUser;
    private IProfCollector myProfCollector = null;

    public BreakpointBasedControlPoints(IDspTask associatedTask) {
        this.myDspUser = associatedTask.createDspUser();
        this.myInternalCPListener = new InternalCtrlPointListener();
        this.myDspUser.onControlPointHit().addIObjectEventListener(this.myInternalCPListener);
        IProfCollectorServer collectorServer = associatedTask.getCollectorServer();
        try {
            this.myProfCollector = collectorServer.openConnection((short)0);
        }
        catch (IProfCollectorServer.CollectorServerException collectorServerException) {
            // empty catch block
        }
        collectorServer.dispose();
    }

    public void detachFromDebugger() {
        this.myDspUser.onControlPointHit().removeIObjectEventListener(this.myInternalCPListener);
        this.myDspUser.dispose();
        this.myDspUser = null;
        this.myProfCollector.dispose();
        this.myProfCollector = null;
    }

    @Override
    public void registerControlPointClient(IControlPointClient toRegister) {
        if (!this.controlPointClients.contains(toRegister)) {
            this.controlPointClients.add(toRegister);
        }
    }

    @Override
    public boolean unregisterControlPointClient(IControlPointClient toUnregister) {
        return this.controlPointClients.remove(toUnregister);
    }

    private void dispatchExitPointHit() {
        if (this.myProfCollector != null) {
            try {
                this.myProfCollector.triggerControlPoint(IProfCollector.ProfileControlPointType.EXIT_POINT);
            }
            catch (IProfCollectorServer.CollectorServerException collectorServerException) {
                // empty catch block
            }
        }
    }

    private void dispatchHaltPointHit() {
        if (this.myProfCollector != null) {
            try {
                this.myProfCollector.triggerControlPoint(IProfCollector.ProfileControlPointType.HALT_POINT);
            }
            catch (IProfCollectorServer.CollectorServerException collectorServerException) {
                // empty catch block
            }
        }
    }

    private void dispatchResumePointHit() {
        if (this.myProfCollector != null) {
            try {
                this.myProfCollector.triggerControlPoint(IProfCollector.ProfileControlPointType.RESUME_POINT);
            }
            catch (IProfCollectorServer.CollectorServerException collectorServerException) {
                // empty catch block
            }
        }
    }

    private class InternalCtrlPointListener
    implements IObjectEventListener<IControlPointEventData> {
        private InternalCtrlPointListener() {
        }

        @Override
        public void onEvent(IControlPointEventData eventData) {
            IControlPointEventData.ControlPointType holdCPType = eventData.getControlPointType();
            if (holdCPType == IControlPointEventData.ControlPointType.CONTROL_POINT_TYPE_HALT) {
                BreakpointBasedControlPoints.this.dispatchHaltPointHit();
            } else if (holdCPType == IControlPointEventData.ControlPointType.CONTROL_POINT_TYPE_EXIT) {
                BreakpointBasedControlPoints.this.dispatchExitPointHit();
            } else if (holdCPType == IControlPointEventData.ControlPointType.CONTROL_POINT_TYPE_RESUME) {
                BreakpointBasedControlPoints.this.dispatchResumePointHit();
            }
        }
    }
}

