/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.genericproperties.impl.ActivityBooleanProperty;
import com.ti.debug.engine.genericproperties.impl.ActivityIntegerProperty;
import com.ti.debug.engine.genericproperties.impl.ActivityStringProperty;
import com.ti.debug.engine.profileactivities.ProfileCollectorProperty;
import com.ti.debug.genericproperties.IProperty;
import com.ti.debug.genericproperties.IPropertyOperations;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

class CollectorPropertyConverter {
    private static final String cannotModifyWhileCollecting = "\nActivity properties cannot be modified while profiling is occuring: disable this activity if you wish to modify the property.";
    private static final char INTPROPCHAR = 'i';
    private static final char BOOLPROPCHAR = 'b';
    private static final char STRINGPROPCHAR = 's';
    private static final char VALUESETSEPARATORCHAR = '|';
    private static final String VALUESETSEPARATORSTR = "[|]";

    CollectorPropertyConverter() {
    }

    public static IProperty collectorPropToActivityProp(boolean bCollectorCollecting, ProfileCollectorProperty toConvert, IProperty parentProp) {
        IProperty toReturn = null;
        PropertyPOD propertyInfo = new PropertyPOD();
        propertyInfo.strValidValues = toConvert.getValidValue();
        propertyInfo.strDescription = toConvert.getDescription();
        if (bCollectorCollecting) {
            propertyInfo.strDescription = propertyInfo.strDescription + cannotModifyWhileCollecting;
        }
        propertyInfo.parentProp = parentProp;
        propertyInfo.bIsEditable = !(bCollectorCollecting | toConvert.isReadOnly());
        switch (propertyInfo.strValidValues.charAt(0)) {
            case 's': {
                toReturn = CollectorPropertyConverter.convertStringProperty(bCollectorCollecting, toConvert, propertyInfo);
                break;
            }
            case 'b': {
                toReturn = CollectorPropertyConverter.convertBooleanProperty(bCollectorCollecting, toConvert, propertyInfo);
                break;
            }
            case 'i': {
                toReturn = CollectorPropertyConverter.extractIntegerProperty(bCollectorCollecting, toConvert, propertyInfo);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return toReturn;
    }

    private static IProperty extractIntegerProperty(boolean bCollectorCollecting, ProfileCollectorProperty toConvert, PropertyPOD propertyInfo) {
        IProperty toReturn = null;
        long lValue = Long.parseLong(toConvert.getValue());
        if (propertyInfo.strValidValues.contentEquals("i:")) {
            try {
                toReturn = new ActivityIntegerProperty(toConvert.getName(), propertyInfo.strDescription, propertyInfo.parentProp, bCollectorCollecting, propertyInfo.bIsEditable, lValue);
            }
            catch (IPropertyOperations.PropertyException e) {}
        } else {
            toReturn = propertyInfo.strValidValues.indexOf(124) != -1 ? CollectorPropertyConverter.extractIntegerValueSetProperty(bCollectorCollecting, toConvert, propertyInfo, lValue) : CollectorPropertyConverter.extractIntegerRangeProperty(bCollectorCollecting, toConvert, propertyInfo, lValue);
        }
        return toReturn;
    }

    private static IProperty extractIntegerRangeProperty(boolean bCollectorCollecting, ProfileCollectorProperty toConvert, PropertyPOD propertyInfo, long lValue) {
        ActivityIntegerProperty toReturn = null;
        int holdSeparatorIndex = propertyInfo.strValidValues.indexOf(45);
        String holdValue = propertyInfo.strValidValues.substring(3, holdSeparatorIndex);
        long lMinValue = Long.parseLong(holdValue);
        holdValue = propertyInfo.strValidValues.substring(holdSeparatorIndex + 1, propertyInfo.strValidValues.length() - 1);
        long lMaxValue = Long.parseLong(holdValue);
        try {
            toReturn = new ActivityIntegerProperty(toConvert.getName(), propertyInfo.strDescription, propertyInfo.parentProp, bCollectorCollecting, propertyInfo.bIsEditable, lMinValue, lMaxValue, lValue);
        }
        catch (IPropertyOperations.PropertyException e) {
            // empty catch block
        }
        return toReturn;
    }

    private static IProperty extractIntegerValueSetProperty(boolean bCollectorCollecting, ProfileCollectorProperty toConvert, PropertyPOD propertyInfo, long lValue) {
        ActivityIntegerProperty toReturn = null;
        String holdValidValue = toConvert.getValidValue().substring(3, toConvert.getValidValue().length() - 1);
        Vector<String> validValueList = new Vector<String>(Arrays.asList(holdValidValue.split(VALUESETSEPARATORSTR)));
        Collections.sort(validValueList);
        long[] lValidValues = new long[validValueList.size()];
        for (int i = 0; i < validValueList.size(); ++i) {
            lValidValues[i] = Long.parseLong(validValueList.get(i));
        }
        try {
            toReturn = new ActivityIntegerProperty(toConvert.getName(), propertyInfo.strDescription, propertyInfo.parentProp, bCollectorCollecting, propertyInfo.bIsEditable, lValidValues, Arrays.binarySearch(lValidValues, lValue));
        }
        catch (IPropertyOperations.PropertyException e) {
            // empty catch block
        }
        return toReturn;
    }

    private static IProperty convertBooleanProperty(boolean bCollectorCollecting, ProfileCollectorProperty toConvert, PropertyPOD propertyInfo) {
        ActivityBooleanProperty toReturn = null;
        boolean bValue = toConvert.getValue().contentEquals("1");
        try {
            toReturn = new ActivityBooleanProperty(toConvert.getName(), propertyInfo.strDescription, propertyInfo.parentProp, bCollectorCollecting, propertyInfo.bIsEditable, bValue);
        }
        catch (IPropertyOperations.PropertyException e) {
            // empty catch block
        }
        return toReturn;
    }

    private static IProperty convertStringProperty(boolean bCollectorCollecting, ProfileCollectorProperty toConvert, PropertyPOD propertyInfo) {
        ActivityStringProperty toReturn = null;
        if (toConvert.getValidValue().indexOf(124) == -1) {
            try {
                toReturn = new ActivityStringProperty(toConvert.getName(), propertyInfo.strDescription, propertyInfo.parentProp, bCollectorCollecting, propertyInfo.bIsEditable, toConvert.getValue());
            }
            catch (IPropertyOperations.PropertyException e) {}
        } else {
            String holdValidValue = toConvert.getValidValue().substring(3, toConvert.getValidValue().length() - 1);
            Vector<String> validValueList = new Vector<String>(Arrays.asList(holdValidValue.split(VALUESETSEPARATORSTR)));
            Collections.sort(validValueList);
            int index = Collections.binarySearch(validValueList, toConvert.getValue());
            try {
                toReturn = new ActivityStringProperty(toConvert.getName(), propertyInfo.strDescription, propertyInfo.parentProp, bCollectorCollecting, propertyInfo.bIsEditable, validValueList, index);
            }
            catch (IPropertyOperations.PropertyException e) {
                // empty catch block
            }
        }
        return toReturn;
    }

    private static class PropertyPOD {
        public String strDescription;
        public String strValidValues;
        public IProperty parentProp;
        public boolean bIsEditable;

        private PropertyPOD() {
        }
    }
}

